/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.table.impl.Cell;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.CodeUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeString;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexString;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.OperationCopy;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.ILazyView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class StringsFragment
extends AbstractFilteredTableFragment<ICodeUnit, ICodeString>
implements ILazyView {
    private static final ILogger logger = GlobalLog.getLogger(StringsFragment.class);

    public StringsFragment(Composite parent, int flags, IRcpClientContext context, ICodeUnit unit, IRcpUnitView unitView) {
        super(parent, flags, unit, unitView, context, new ContentProvider(unit), null);
        this.setLabelProvider(new LabelProvider((ContentProvider)this.getProvider()));
        this.setLayout((Layout)new FillLayout());
    }

    @Override
    public void lazyInitialization() {
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{S.s(52), S.s(591), S.s(203), S.s(351), S.s(815)};
        FilteredTableViewer viewer = this.buildFilteredViewer(container, columnNames, 0, true);
        if (this.unit instanceof INativeCodeUnit) {
            this.setRefreshListener(viewer, e -> {
                (new Object[1])[0] = e;
                return this.unit != null && e.getSource() == this.unit;
            }, () -> {
                Object[] cfr_ignored_0 = new Object[0];
            });
        }
        this.addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                menuMgr.add(new Separator());
                menuMgr.add(new OperationCopy(StringsFragment.this));
                menuMgr.add(new Action("Jump to first reference"){

                    @Override
                    public void run() {
                        String address = StringsFragment.this.getActiveAddress();
                        if (address != null) {
                            StringsFragment.this.navigateTo(address);
                        }
                    }
                });
                menuMgr.add(new Action("Cross References"){

                    @Override
                    public void run() {
                        StringsFragment.this.openXref();
                    }
                });
            }
        });
        new AddressNavigator(this.context, this.unit, this).addDefaultListeners(this.getViewer());
        this.layout();
    }

    private void resizeColumns(Table table) {
        int i;
        int fullw = table.getClientArea().width;
        int cnt = table.getColumnCount();
        int[] sizes = new int[cnt];
        for (int i2 = 0; i2 < cnt; ++i2) {
            int w;
            TableColumn col = table.getColumn(i2);
            sizes[i2] = w = col.getWidth();
        }
        int avgw = fullw / cnt;
        int left = fullw;
        for (i = 0; i < cnt - 1; ++i) {
            if (sizes[i] > avgw) {
                sizes[i] = avgw;
            }
            left -= sizes[i];
        }
        sizes[cnt - 1] = left;
        for (i = 0; i < cnt; ++i) {
            TableColumn col = table.getColumn(i);
            col.setWidth(sizes[i]);
        }
    }

    @Override
    public IItem getActiveItem() {
        ICodeString str = this.getSelectedRow();
        if (str == null) {
            return null;
        }
        Cell pseudoItem = new Cell(null);
        pseudoItem.setItemId(str.getIdentifier());
        return pseudoItem;
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof ICodeString;
    }

    @Override
    public ICodeString getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof ICodeString)) {
            return null;
        }
        return (ICodeString)row;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        ICodeString str = this.getSelectedRow();
        if (str == null) {
            return null;
        }
        return CodeUtil.findCodeItemReference((ICodeUnit)this.unit, str, 0);
    }

    private void openXref() {
        ICodeString str = this.getSelectedRow();
        if (str == null) {
            return;
        }
        if (this.unitView == null) {
            return;
        }
        long id = str.getIdentifier();
        if (id != 0L) {
            IUnitFragment textFragment = null;
            for (IUnitFragment iUnitFragment : this.unitView.getFragments()) {
                if (!(iUnitFragment instanceof TextFragment)) continue;
                textFragment = iUnitFragment;
            }
            if (textFragment == null) {
                return;
            }
            ActionContext actionContext = new ActionContext((IInteractiveUnit)this.unit, 4, id);
            ActionUIContext actionUIContext = new ActionUIContext(actionContext, textFragment);
            new GraphicalActionExecutor(this.getShell(), this.getContext()).execute(actionUIContext);
        }
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        ICodeUnit unit;

        public ContentProvider(ICodeUnit unit) {
            this.unit = unit;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            List<? extends ICodeString> strings = this.unit.getStrings();
            return strings == null ? ArrayUtil.NO_OBJECT : strings.toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        ContentProvider provider;

        public LabelProvider(ContentProvider provider) {
            this.provider = provider;
        }

        @Override
        public int getColumns(Object row) {
            return 5;
        }

        @Override
        public String getStringAt(Object element, int key) {
            ICodeString e = (ICodeString)element;
            switch (key) {
                case 0: {
                    return e.getAddress();
                }
                case 1: {
                    return e.getName(true);
                }
                case 2: {
                    String address = e.getAddress();
                    return address == null ? null : this.provider.unit.getFullComment(address);
                }
                case 3: {
                    Object f = "";
                    int flags = e.getGenericFlags();
                    if ((flags & 0x40000000) != 0) {
                        f = "ARTIFICIAL ";
                    }
                    if (e instanceof IDexString) {
                        IDexString str = (IDexString)e;
                        if (Boolean.FALSE.equals(str.getHintUsedInDex())) {
                            f = (String)f + "UNUSED ";
                        } else if (Boolean.FALSE.equals(str.getHintUsedAsImmediate())) {
                            f = (String)f + "META ";
                        }
                    }
                    return f;
                }
                case 4: {
                    return e.getValue();
                }
            }
            return null;
        }
    }
}

