/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IMemoryModel;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IMemoryModelListener;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IMethodStackMemoryModel;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.MemoryModelEvent;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.WidgetActionWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.InfiniTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractInfiniTableSectionProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.InfiniTableViewer;
import com.pnfsoftware.jeb.rcpclient.operations.JebAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionDefine;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionDefineArray;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionRename;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionSetType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionUndefine;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackEditorView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(StackEditorView.class);
    private INativeCodeUnit<?> unit;
    private INativeMethodItem routine;
    private InfiniTableView view;
    private InfiniTableViewer viewer;
    private StackItemsProvider provider;
    protected Boolean allowUndefine;
    private IMemoryModelListener sfModelListener = new IMemoryModelListener(){

        @Override
        public void onModelUpdate(MemoryModelEvent event) {
            UIExecutor.async(() -> StackEditorView.this.refresh());
        }
    };

    public StackEditorView(final Composite parent, int style, INativeCodeUnit<?> unit) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        final ArrayList<StackEditorAction> actions = new ArrayList<StackEditorAction>();
        actions.add(new StackEditorActionDefine(this));
        actions.add(new StackEditorActionUndefine(this));
        actions.add(new StackEditorActionRename(this));
        actions.add(new StackEditorActionDefineArray(this));
        actions.add(new StackEditorActionSetType(this));
        Composite bar = new Composite((Composite)this, 0);
        bar.setLayoutData((Object)UIUtil.createGridDataFill(true, false));
        bar.setLayout((Layout)new RowLayout(256));
        SelectionAdapter actionPushboxListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = (Integer)e.widget.getData("action_index");
                StackEditorAction a = (StackEditorAction)actions.get(index);
                if (a.canExecute()) {
                    a.execute();
                } else {
                    UI.warn("Cannot execute action");
                }
            }
        };
        UIUtil.createPushbox(bar, "Define", (SelectionListener)actionPushboxListener).setData("action_index", (Object)0);
        UIUtil.createPushbox(bar, "Delete", (SelectionListener)actionPushboxListener).setData("action_index", (Object)1);
        UIUtil.createPushbox(bar, "Name", (SelectionListener)actionPushboxListener).setData("action_index", (Object)2);
        UIUtil.createPushbox(bar, "Array", (SelectionListener)actionPushboxListener).setData("action_index", (Object)3);
        UIUtil.createPushbox(bar, "Type", (SelectionListener)actionPushboxListener).setData("action_index", (Object)4);
        UIUtil.createPushbox(bar, S.s(365), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg = "This widget is the native routine stack editor. The table represents a stack memory layout.\n\nRight click on a row, at the given offset, to perform any of the following actions:\n- Define a variable\n- Undefine a variable\n- Rename a variable\n- Create an array variable\n- Set the type of a variable\n\nYou may scroll up/down to access lower/higher offsets.\n";
                MessageDialog.openInformation(parent.getShell(), "Controls", msg);
            }
        });
        this.view = new InfiniTableView(this, 4, new String[]{"Offset", "Size", "Name", "Type", "Comment"});
        this.view.setLayoutData(UIUtil.createGridDataFill(true, true));
        this.viewer = new InfiniTableViewer(this.view);
        this.provider = new StackItemsProvider();
        this.viewer.setContentProvider(this.provider);
        this.viewer.setLabelProvider(new StackItemLabelProvider());
        this.viewer.setTopId(0L, false);
        this.viewer.setInput(null);
        WidgetActionWrapper actionWrapper = new WidgetActionWrapper((Control)this.view.getTable());
        actions.forEach(a -> actionWrapper.registerAction((JebAction)a));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (StackEditorView.this.routine != null) {
                    StackEditorView.this.routine.getData().getStackframeModel().removeListener(StackEditorView.this.sfModelListener);
                    StackEditorView.this.routine = null;
                }
            }
        });
    }

    public INativeCodeUnit<?> getInputUnit() {
        return this.unit;
    }

    public INativeMethodItem getInputRoutine() {
        return this.routine;
    }

    public void setInputRoutine(INativeMethodItem routine_) {
        if (this.routine != null) {
            this.routine.getData().getStackframeModel().removeListener(this.sfModelListener);
            this.routine = null;
        }
        this.routine = routine_;
        this.viewer.setInput(routine_);
        if (this.routine != null) {
            this.routine.getData().getStackframeModel().addListener(this.sfModelListener);
        }
    }

    void refresh() {
        IStructuredSelection sel1;
        int index0 = this.view.getTable().getSelectionIndex();
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        this.viewer.refresh();
        if (sel != null) {
            this.viewer.setSelection(sel, true);
        }
        if ((sel1 = (IStructuredSelection)this.viewer.getSelection()).isEmpty()) {
            this.view.getTable().setSelection(index0);
        }
    }

    public ItemEntry getSelectedEntry() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel.isEmpty() ? null : (ItemEntry)sel.getFirstElement();
    }

    class StackItemsProvider
    extends AbstractInfiniTableSectionProvider {
        StackItemsProvider() {
        }

        @Override
        public Object[] get(Object inputElement, long id, int cnt) {
            Assert.a(StackEditorView.this.routine == (INativeMethodItem)inputElement);
            if (StackEditorView.this.routine == null) {
                return ArrayUtil.NO_OBJECT;
            }
            return this.readSlots(StackEditorView.this.unit, StackEditorView.this.routine, id, cnt);
        }

        private INativeContinuousItem createGapItem(IMemoryModel model, long address, int size) {
            INativeContinuousItem item = model.getGapFactory().create(address, address + (long)size);
            item.setName("undefined");
            return item;
        }

        private Object[] readSlots(INativeCodeUnit<?> unit, INativeMethodItem routine, long id, int cnt) {
            int i0;
            INativeMethodDataItem routineData = routine.getData();
            IMethodStackMemoryModel stk = routineData.getStackframeModel();
            int indexZero = -1;
            ArrayList<INativeContinuousItem> list = new ArrayList<INativeContinuousItem>();
            HashSet<Long> slackset = new HashSet<Long>();
            if (!stk.isEmpty()) {
                INativeContinuousItem item;
                Long lastAddress = null;
                SortedMap<Long, INativeContinuousItem> stkview0 = stk.getView(null, null);
                TreeMap<Long, INativeContinuousItem> stkview = new TreeMap<Long, INativeContinuousItem>(stkview0);
                for (Long address : stkview.descendingKeySet()) {
                    INativeContinuousItem item2 = stkview.get(address);
                    if (lastAddress != null && !lastAddress.equals(item2.getEnd())) {
                        for (long a = lastAddress - 1L; a >= (Long)item2.getEnd(); --a) {
                            list.add(this.createGapItem(stk, a, 1));
                        }
                    }
                    list.add(item2);
                    lastAddress = (Long)item2.getBegin();
                }
                INativeContinuousItem slot = (INativeContinuousItem)list.get(0);
                long first = Math.max(1L, (Long)slot.getEnd() + (long)(cnt * 1));
                ArrayList<INativeContinuousItem> tmplist = new ArrayList<INativeContinuousItem>();
                for (long a = first - 1L; a >= (Long)slot.getEnd(); --a) {
                    tmplist.add(this.createGapItem(stk, a, 1));
                    slackset.add(a);
                }
                list.addAll(0, tmplist);
                slot = (INativeContinuousItem)list.get(list.size() - 1);
                long last = Math.min(0L, (Long)slot.getBegin() - (long)(cnt * 1));
                for (long a = (Long)slot.getBegin() - 1L; a >= last; --a) {
                    list.add(this.createGapItem(stk, a, 1));
                    slackset.add(a);
                }
                indexZero = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && ((Long)(item = (INativeContinuousItem)iterator.next()).getBegin() > 0L || (Long)item.getEnd() <= 0L)) {
                    ++indexZero;
                }
            }
            if (indexZero >= list.size() || id + (long)indexZero < 0L || id + (long)indexZero + (long)cnt > (long)list.size()) {
                list.clear();
                for (long a = id; a < id + (long)cnt; ++a) {
                    INativeContinuousItem item = this.createGapItem(stk, -a, 1);
                    list.add(item);
                    slackset.add(-a);
                }
                indexZero = (int)(-id);
            }
            ArrayList<ItemEntry> r = new ArrayList<ItemEntry>();
            for (int i = i0 = (int)(id + (long)indexZero); i < i0 + cnt; ++i) {
                INativeContinuousItem item = (INativeContinuousItem)list.get(i);
                ItemEntry e = new ItemEntry();
                e.offset = (int)item.getMemoryAddress();
                e.name = item.getName(true);
                e.size = (int)item.getMemorySize();
                e.type = item instanceof INativeDataItem ? ((INativeDataItem)item).getType() : null;
                e.comment = stk.getCommentManager().getComment(e.offset);
                e.slack = slackset.contains(e.offset);
                r.add(e);
            }
            return r.toArray();
        }
    }

    static class StackItemLabelProvider
    extends DefaultCellLabelProvider {
        StackItemLabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 5;
        }

        @Override
        public void update(ViewerCell cell) {
            super.update(cell);
            if (cell.getColumnIndex() == 0 || cell.getColumnIndex() == 1) {
                cell.setFont(UIUtil.getCodeFont());
            }
            ItemEntry entry = (ItemEntry)cell.getElement();
            if (!entry.slack && ThemeManager.getInstance().isStandardTheme()) {
                int rgb = entry.type != null ? 0xFFFFB0 : 0xFFFFE0;
                cell.setBackground(UIAssetManager.getInstance().getColor(rgb));
            }
        }

        @Override
        public String getStringAt(Object element, int key) {
            ItemEntry e = (ItemEntry)element;
            switch (key) {
                case 0: {
                    if (e.offset >= 0) {
                        return Strings.ff("+%08X", e.offset);
                    }
                    return Strings.ff("-%08X", -e.offset);
                }
                case 1: {
                    return Strings.ff("%04X", e.size);
                }
                case 2: {
                    return e.name;
                }
                case 3: {
                    if (e.type != null) {
                        return e.type.getSignature(true);
                    }
                    return null;
                }
                case 4: {
                    return e.comment;
                }
            }
            return null;
        }
    }
}

