/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeTypeDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorView;
import com.pnfsoftware.jeb.util.format.Strings;

public class StackEditorActionSetType
extends StackEditorAction {
    public StackEditorActionSetType(StackEditorView v) {
        super("Set Type", v);
        this.keyCode = 121;
        this.setAccelerator(89);
    }

    @Override
    public boolean isEnabled() {
        return this.v.getSelectedEntry() != null;
    }

    @Override
    public void run() {
        ItemEntry e = this.v.getSelectedEntry();
        if (e == null) {
            return;
        }
        String currentFieldSig = "";
        if (e.type != null) {
            currentFieldSig = e.type.getSignature(true);
        }
        NativeTypeDialog dlg = new NativeTypeDialog(this.v.getShell(), 0, null, null, this.v.getInputUnit());
        dlg.setInitialValue(currentFieldSig);
        String fieldSig = dlg.open();
        if (fieldSig == null) {
            return;
        }
        ITypeManager typeman = this.v.getInputUnit().getTypeManager();
        INativeType itemType = typeman.getType(fieldSig);
        if (itemType == null) {
            UI.error(Strings.ff("The type \"%s\" was not found", fieldSig));
            return;
        }
        if (StackEditorActionSetType.setItemType(this.v, e, this.v.getInputRoutine(), itemType)) {
            this.v.refresh();
        }
    }

    static boolean setItemType(StackEditorView v, ItemEntry e, INativeMethodItem routine, INativeType newItemType) {
        if (newItemType == e.type) {
            return false;
        }
        if (!StackEditorActionSetType.offerClearItems(v, routine, e.offset, newItemType.getSize())) {
            return false;
        }
        INativeDataItem item = routine.getData().getStackframeManager().defineItem(e.offset, newItemType);
        if (item == null) {
            UI.error(Strings.ff("A item of type \"%s\" could not be created at offset %Xh", newItemType.getName(true), e.offset));
            return false;
        }
        item.setName(e.name);
        return true;
    }
}

