/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrototypeAttribute;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParseException;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParser;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.CallingConventionManagerDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeTypeChooserDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RoutineSignatureEditorView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(RoutineSignatureEditorView.class);
    private INativeCodeUnit<?> unit;
    private INativeMethodItem m;
    private Text widgetSig;
    private Text widgetCC;
    private StyledText widgetIn;
    private StyledText widgetOut;
    private Text widgetError;
    private Map<PrototypeAttribute, Button> wAttrMap = new HashMap<PrototypeAttribute, Button>();
    ICallingConvention selectedCC;
    IPrototypeItem generatedProto;
    List<INativeType> returnTypes;
    List<INativeType> paramTypes;
    List<PrototypeAttribute> attributes;
    List<String> paramNames;
    String methodName;

    public RoutineSignatureEditorView(Composite parent, int style, final INativeCodeUnit<?> unit, final INativeMethodItem m) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (unit == null || m == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        this.m = m;
        Composite c = UIUtil.createCompositeGrid(this, 0, 1, 2, 0);
        UIUtil.createLabelInGridLayout(c, 0, "Current: ", 1);
        this.widgetSig = new Text(c, 2060);
        this.widgetSig.setFont(UIUtil.getCodeFont());
        GridData griddata = new GridData();
        griddata.horizontalSpan = 1;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        this.widgetSig.setLayoutData((Object)griddata);
        this.widgetSig.setText(m.getSignature());
        c = UIUtil.createCompositeGrid(this, 0, 1, 3, 0);
        UIUtil.createLabelInGridLayout(c, 0, "Calling Convention: ", 1);
        this.widgetCC = new Text(c, 2060);
        this.widgetCC.setFont(UIUtil.getCodeFont());
        griddata = new GridData();
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        this.widgetCC.setLayoutData((Object)griddata);
        UIUtil.createPushbox(c, "Select or Create...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICallingConvention cc = m.getPrototype() != null ? m.getPrototype().getCallingConvention() : null;
                CallingConventionManagerDialog dlg = new CallingConventionManagerDialog(RoutineSignatureEditorView.this.getShell(), null, unit, cc);
                cc = dlg.open();
                if (cc != null) {
                    RoutineSignatureEditorView.this.selectedCC = cc;
                    RoutineSignatureEditorView.this.widgetCC.setText(RoutineSignatureEditorView.this.selectedCC.getName());
                    RoutineSignatureEditorView.this.verifySig();
                }
            }
        });
        Group grp = UIUtil.createGroupGrid(this, 0, "Input", 1, 1);
        UIUtil.createLabelInGridLayout((Composite)grp, 0, "Method parameters, one per line:", 1);
        this.widgetIn = new StyledText((Composite)grp, 2818);
        this.widgetIn.setFont(UIUtil.getCodeFont());
        this.widgetIn.setAlwaysShowScrollBars(false);
        griddata = UIUtil.createGridDataForText((Control)this.widgetIn, 50, 8, false);
        griddata.horizontalSpan = 1;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        griddata.grabExcessVerticalSpace = true;
        griddata.verticalAlignment = 4;
        this.widgetIn.setLayoutData((Object)griddata);
        UIUtil.disableTabOutput((Control)this.widgetIn);
        this.widgetIn.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RoutineSignatureEditorView.this.verifySig();
            }
        });
        UIUtil.createPushbox((Composite)grp, "Select or import a parameter type...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeChooserDialog dlg = new NativeTypeChooserDialog(RoutineSignatureEditorView.this.getShell(), unit);
                INativeType t = dlg.open();
                if (t != null) {
                    UIUtil.textinsert(RoutineSignatureEditorView.this.widgetIn, t.getSignature() + " ");
                    RoutineSignatureEditorView.this.widgetIn.setFocus();
                    RoutineSignatureEditorView.this.verifySig();
                }
            }
        });
        grp = UIUtil.createGroupGrid(this, 0, "Output", 1, 1);
        UIUtil.createLabelInGridLayout((Composite)grp, 0, "Method returns, one return value per line:", 1);
        this.widgetOut = new StyledText((Composite)grp, 2818);
        this.widgetOut.setFont(UIUtil.getCodeFont());
        this.widgetOut.setAlwaysShowScrollBars(false);
        this.widgetOut.setText(unit.getNotes());
        griddata = UIUtil.createGridDataForText((Control)this.widgetOut, 50, 1, false);
        griddata.horizontalSpan = 1;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        this.widgetOut.setLayoutData((Object)griddata);
        UIUtil.disableTabOutput((Control)this.widgetOut);
        this.widgetOut.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RoutineSignatureEditorView.this.verifySig();
            }
        });
        UIUtil.createPushbox((Composite)grp, "Select or import a return Type...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeChooserDialog dlg = new NativeTypeChooserDialog(RoutineSignatureEditorView.this.getShell(), unit);
                INativeType t = dlg.open();
                if (t != null) {
                    UIUtil.textinsert(RoutineSignatureEditorView.this.widgetOut, t.getSignature() + " ");
                    RoutineSignatureEditorView.this.widgetOut.setFocus();
                    RoutineSignatureEditorView.this.verifySig();
                }
            }
        });
        grp = UIUtil.createGroupGrid(this, 0, "Attributes", 1, 3);
        SelectionAdapter attrListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RoutineSignatureEditorView.this.verifySig();
            }
        };
        for (PrototypeAttribute attr : PrototypeAttribute.values()) {
            Button btn = UIUtil.createCheckbox((Composite)grp, attr.toString(), (SelectionListener)attrListener);
            btn.setData("attr", (Object)attr);
            this.wAttrMap.put(attr, btn);
        }
        UIUtil.createLabelInGridLayout(this, 0, "Parsing results:", 1);
        this.widgetError = new Text((Composite)this, 2826);
        this.widgetError.setFont(UIUtil.getCodeFont());
        griddata = UIUtil.createGridDataForText((Control)this.widgetError, 50, 2, false);
        griddata.horizontalSpan = 1;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        this.widgetError.setLayoutData((Object)griddata);
        this.generateFromRoutine();
        this.widgetIn.setFocus();
    }

    public boolean verifySig() {
        return this.verifySig(false);
    }

    public boolean applySig() {
        return this.verifySig(true);
    }

    public void generateFromRoutine() {
        this.widgetIn.setText("");
        this.widgetOut.setText("");
        this.widgetError.setText("");
        IPrototypeItem proto = this.m.getPrototype();
        if (proto != null) {
            this.widgetCC.setText(proto.getCallingConvention().getName());
            for (PrototypeAttribute attr : proto.getPrototypeAttributes()) {
                this.wAttrMap.get((Object)attr).setSelection(true);
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (INativeType iNativeType : proto.getParameterTypes()) {
                sb.append(iNativeType.getSignature(true));
                String name = this.m.getParameterName(i);
                if (name != null) {
                    sb.append(' ').append(name);
                }
                sb.append('\n');
                ++i;
            }
            this.widgetIn.setText(sb.toString());
            sb = new StringBuilder();
            for (INativeType iNativeType : proto.getReturnTypes()) {
                sb.append(iNativeType.getSignature(true));
                sb.append('\n');
            }
            this.widgetOut.setText(sb.toString());
        }
    }

    private boolean verifySig(boolean generate) {
        this.widgetError.setText("");
        this.generatedProto = null;
        this.methodName = null;
        this.returnTypes = new ArrayList<INativeType>();
        this.paramTypes = new ArrayList<INativeType>();
        this.attributes = new ArrayList<PrototypeAttribute>();
        this.paramNames = new ArrayList<String>();
        try {
            List<String> in = this.preparseBlock(this.widgetIn.getText(), true);
            List<String> out = this.preparseBlock(this.widgetOut.getText(), false);
            if (generate) {
                TypeStringParser parser = new TypeStringParser(this.unit.getTypeManager());
                int i = 0;
                for (String str : in) {
                    TypeStringParser.Decl r = parser.parseDeclaration(str, true);
                    this.paramTypes.add(r.getType());
                    this.paramNames.add((String)(r.isGenericName() ? "param" + i : r.getName()));
                    ++i;
                }
                for (String str : out) {
                    INativeType t = parser.parseType(str);
                    this.returnTypes.add(t);
                }
                for (PrototypeAttribute attr : this.wAttrMap.keySet()) {
                    if (!this.wAttrMap.get((Object)attr).getSelection()) continue;
                    this.attributes.add(attr);
                }
                this.generatedProto = this.unit.getTypeManager().createPrototypeEx(this.selectedCC, this.returnTypes, this.paramTypes, this.attributes);
                this.m.setPrototype(this.generatedProto);
                this.m.setParameterNames(this.paramNames);
            }
            this.widgetError.setText("OK");
            return true;
        }
        catch (Exception e) {
            this.widgetError.setText("Verifying: " + e.getMessage());
            return false;
        }
    }

    private List<String> preparseBlock(String data, boolean decllist) {
        ArrayList<String> r = new ArrayList<String>();
        for (String line : Strings.splitLines(data)) {
            String str = line.trim();
            if (str.isEmpty()) continue;
            try {
                if (decllist) {
                    TypeStringParser.verifyDeclaration(str, true);
                } else {
                    TypeStringParser.verifyType(str, true);
                }
            }
            catch (TypeStringParseException e) {
                throw new IllegalArgumentException("Parsing error: " + e.getMessage());
            }
            r.add(str);
        }
        return r;
    }
}

