/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionXrefsData;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.OperationCopy;
import com.pnfsoftware.jeb.rcpclient.parts.ILazyView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ReferencedMethodsFragment
extends AbstractFilteredTableFragment<INativeCodeUnit<?>, INativeMethodItem>
implements ILazyView {
    private static final ILogger logger = GlobalLog.getLogger(ReferencedMethodsFragment.class);

    public ReferencedMethodsFragment(Composite parent, int flags, IRcpClientContext context, INativeCodeUnit<?> unit, IRcpUnitView unitView) {
        super(parent, flags, unit, unitView, context, new ContentProvider(unit), new LabelProvider());
        this.setLayout((Layout)new FillLayout());
    }

    @Override
    public void lazyInitialization() {
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{"Name", "Signature"};
        FilteredTableViewer viewer = this.buildFilteredViewer(container, columnNames, 0, true);
        this.setRefreshListener(viewer, e -> {
            (new Object[1])[0] = e;
            return this.unit != null && e.getSource() == this.unit;
        });
        this.addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                menuMgr.add(new Separator());
                menuMgr.add(new OperationCopy(ReferencedMethodsFragment.this));
                menuMgr.add(new Action("Jump to first reference"){

                    @Override
                    public void run() {
                        ReferencedMethodsFragment.this.jumpToFirstMethodReference();
                    }
                });
                menuMgr.add(new Action("Cross References"){

                    @Override
                    public void run() {
                        ReferencedMethodsFragment.this.openXref();
                    }
                });
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                ReferencedMethodsFragment.this.jumpToFirstMethodReference();
            }
        });
        this.layout();
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof INativeMethodItem;
    }

    @Override
    public INativeMethodItem getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof INativeMethodItem)) {
            return null;
        }
        return (INativeMethodItem)row;
    }

    private void jumpToFirstMethodReference() {
        INativeMethodItem m = this.getSelectedRow();
        if (m != null) {
            String address = m.getAddress();
            this.jumpToFirstMethodReference(m, address);
        }
    }

    private boolean jumpToFirstMethodReference(INativeMethodItem m, String originAddress) {
        List<String> addresses;
        ActionXrefsData data;
        ActionContext actionContext;
        long id;
        if (this.unitView == null) {
            return false;
        }
        String address = originAddress;
        if (address == null && (id = m.getItemId()) != 0L && ((INativeCodeUnit)this.unit).prepareExecution(actionContext = new ActionContext((IInteractiveUnit)this.unit, 4, id), data = new ActionXrefsData()) && (addresses = data.getAddresses()) != null && !addresses.isEmpty()) {
            address = addresses.get(0);
        }
        if (address != null) {
            for (IUnitFragment iUnitFragment : this.unitView.getFragments()) {
                if (!(iUnitFragment instanceof TextFragment)) continue;
                (new Object[1])[0] = address;
                if (!((TextFragment)iUnitFragment).isValidActiveAddress(address, null)) continue;
                this.unitView.setActiveFragment(iUnitFragment);
                boolean found = this.unitView.setActiveAddress(address, null, false, true);
                if (found) {
                    return true;
                }
                this.unitView.setActiveFragment(this);
            }
        }
        if (originAddress != null) {
            this.jumpToFirstMethodReference(m, null);
        }
        return false;
    }

    private void openXref() {
        INativeMethodItem m = this.getSelectedRow();
        if (m == null) {
            return;
        }
        if (this.unitView == null) {
            return;
        }
        long id = m.getItemId();
        if (id != 0L) {
            IUnitFragment textFragment = null;
            for (IUnitFragment iUnitFragment : this.unitView.getFragments()) {
                if (!(iUnitFragment instanceof TextFragment)) continue;
                textFragment = iUnitFragment;
            }
            if (textFragment == null) {
                return;
            }
            ActionContext actionContext = new ActionContext((IInteractiveUnit)this.unit, 4, id);
            ActionUIContext actionUIContext = new ActionUIContext(actionContext, textFragment);
            new GraphicalActionExecutor(this.getShell(), this.getContext()).execute(actionUIContext);
        }
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        private INativeCodeUnit<?> codeunit;

        public ContentProvider(INativeCodeUnit<?> codeunit) {
            this.codeunit = codeunit;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            ArrayList<INativeMethodItem> list = new ArrayList<INativeMethodItem>();
            for (INativeMethodItem m : this.codeunit.getMethods()) {
                if (m.getData() != null) continue;
                list.add(m);
            }
            return list.toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 2;
        }

        @Override
        public String getStringAt(Object element, int key) {
            INativeMethodItem m = (INativeMethodItem)element;
            if (key == 0) {
                return m.getName(true);
            }
            if (key == 1) {
                return m.getSignature(true);
            }
            return null;
        }
    }
}

