/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.units.code.asm.INativeDisassemblerPlugin;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterBankService;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProcessorManagerView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(ProcessorManagerView.class);
    private IEnginesContext engctx;
    private Combo comboSelectedProc;
    private Text widgetText;

    public ProcessorManagerView(Composite parent, int style, IEnginesContext engctx) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.engctx = engctx;
        Composite c = UIUtil.createCompositeGrid(this, 0, 1, 2, 0);
        UIUtil.createLabelInGridLayout(c, 0, "Processor: ", 1);
        this.comboSelectedProc = new Combo(c, 2056);
        this.refreshProcList();
        this.comboSelectedProc.pack();
        c.pack();
        this.comboSelectedProc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ProcessorManagerView.this.comboSelectedProc.getSelectionIndex();
                if (index >= 0) {
                    String procname = ProcessorManagerView.this.comboSelectedProc.getItem(index);
                    ProcessorType proc = ProcessorType.valueOf(procname);
                    ProcessorManagerView.this.onProcSelectionChange(proc);
                }
            }
        });
        this.widgetText = UIUtil.createTextboxInGrid(this, 2826, null, null, true, true);
        this.widgetText.setFont(UIUtil.getCodeFont());
    }

    private void refreshProcList() {
        this.comboSelectedProc.removeAll();
        if (this.engctx != null) {
            for (INativeDisassemblerPlugin<?> plugin : this.engctx.getNativeDisassemblerPlugins()) {
                List<ProcessorType> proctypes = plugin.getProcessorTypes();
                for (ProcessorType proctype : proctypes) {
                    this.comboSelectedProc.add(proctype.toString());
                }
            }
        } else {
            for (ProcessorType proctype : RegisterBankService.getInstance().getSupportedProcessors()) {
                this.comboSelectedProc.add(proctype.toString());
            }
        }
    }

    private void onProcSelectionChange(ProcessorType proc) {
        if (proc == null) {
            return;
        }
        this.setSelectedProc(proc, false, true);
    }

    public ProcessorType getSelectedProc() {
        int index = this.comboSelectedProc.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        String name = this.comboSelectedProc.getItems()[index];
        return ProcessorType.valueOf(name);
    }

    public void setSelectedProc(ProcessorType proc) {
        this.setSelectedProc(proc, true, true);
    }

    private void setSelectedProc(ProcessorType proctype, boolean selectEntry, boolean refreshText) {
        if (selectEntry && proctype != null) {
            int i = 0;
            for (String itemName : this.comboSelectedProc.getItems()) {
                if (itemName.equals(proctype.toString())) {
                    this.comboSelectedProc.select(i);
                    break;
                }
                ++i;
            }
        }
        if (refreshText) {
            this.renderText(proctype);
        }
    }

    private void renderText(ProcessorType proctype) {
        IRegisterBank regbank = RegisterBankService.getInstance().get(proctype);
        String text = regbank != null ? regbank.format(1) : "No register bank or register bank is undefined";
        this.widgetText.setText(text);
    }
}

