/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NativeTypesFragment
extends AbstractFilteredTableFragment<INativeCodeUnit<?>, INativeType> {
    private static final ILogger logger = GlobalLog.getLogger(NativeTypesFragment.class);
    private Combo comboSource;
    private FilteredTableViewer viewer;
    private ViewerRefresher refresher;

    public NativeTypesFragment(Composite parent, int style, IRcpClientContext context, final INativeCodeUnit<?> pbcu, IRcpUnitView unitView, int initialTypesource) {
        super(parent, style, pbcu, unitView, context, new ContentProvider(pbcu, initialTypesource), new LabelProvider());
        this.setLayout((Layout)new GridLayout(1, false));
        Composite c = UIUtil.createCompositeGrid(this, 0, 1, 2, null);
        UIUtil.createLabelInGridLayout(c, 0, "Source: ", 1);
        this.comboSource = new Combo(c, 2056);
        this.comboSource.add("In-use types");
        this.comboSource.add("All types");
        this.comboSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NativeTypesFragment.this.comboSource.getSelectionIndex();
                ((ContentProvider)NativeTypesFragment.this.getProvider()).setTypeSource(NativeTypesFragment.this.getTypeSourceFromIndex(index));
                NativeTypesFragment.this.viewer.setInput(pbcu);
            }
        });
        this.comboSource.pack();
        this.setSource(initialTypesource);
        String[] columnNames = new String[]{S.s(738), S.s(740)};
        this.viewer = this.buildFilteredViewer(this, columnNames, 0, false);
        this.refresher = this.setRefreshListener(this.viewer, e -> pbcu != null);
        this.layout();
    }

    @Override
    protected void initFilteredView(FilteredTableView view) {
        view.setLayoutData(UIUtil.createGridDataFill(true, true));
    }

    public int getTypeSourceFromIndex(int index) {
        switch (index) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    public void setSource(int source) {
        int index = -1;
        if (source == 1) {
            index = 0;
        } else if (source == 3) {
            index = 1;
        }
        if (index >= 0) {
            this.comboSource.select(index);
        } else {
            this.comboSource.clearSelection();
        }
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof INativeType;
    }

    @Override
    public INativeType getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof INativeType)) {
            return null;
        }
        return (INativeType)row;
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        IEventListener listener;
        INativeCodeUnit<?> pbcu;
        int typesource;
        ViewerRefresher refresher;

        public ContentProvider(INativeCodeUnit<?> pbcu, int initialTypesource) {
            this.pbcu = pbcu;
            this.typesource = initialTypesource;
        }

        public void setTypeSource(int typesource) {
            this.typesource = typesource;
        }

        public int getTypeSource() {
            return this.typesource;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (!this.pbcu.isProcessed()) {
                return ArrayUtil.NO_OBJECT;
            }
            List<INativeType> types = TypeUtil.retrieveAvailableTypes(this.pbcu, this.typesource);
            return types.toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }

    static class LabelProvider
    implements IFilteredLabelProvider,
    ITableLabelProvider {
        LabelProvider() {
        }

        @Override
        public void addListener(ILabelProviderListener listener) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener listener) {
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            INativeType t = (INativeType)element;
            if (columnIndex == 0) {
                return t == null ? "" : t.getSignature(true);
            }
            if (columnIndex == 1) {
                return t == null ? "" : "" + t.getSize();
            }
            throw new RuntimeException();
        }

        @Override
        public String getStringAt(Object element, int key) {
            return this.getColumnText(element, key);
        }

        @Override
        public Object[] getRowElements(Object row) {
            INativeType e = (INativeType)row;
            return new Object[]{e.getSignature(true), "" + e.getSize()};
        }
    }
}

