/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.IllegalTypeNameException;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrettyTypeFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParser;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.WidgetActionWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.InfiniTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.autocomplete.combo.AutocompleteComboInput;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractInfiniTableSectionProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.InfiniTableViewer;
import com.pnfsoftware.jeb.rcpclient.operations.JebAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionDefine;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionDefineArray;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionRename;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionSetType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionUndefine;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NativeTypeEditorView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(NativeTypeEditorView.class);
    private static final int previewDepthLevel = 10;
    private INativeCodeUnit<?> unit;
    private INativeType type;
    private InfiniTableView view;
    private InfiniTableViewer viewer;
    private StructFieldsProvider provider;
    private Combo comboSource;
    private Combo comboSelectedType;
    private Text widgetPreview;
    private Button btnPreviewDeep;
    private Button btnPreviewPadding;
    private Button btnPreviewOffsets;
    int typeSourceFlags;
    Boolean allowUndefine;
    Integer assumedResponseForTypeImportPopup = null;

    public NativeTypeEditorView(final Composite parent, int style, final INativeCodeUnit<?> unit) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        final ArrayList<StructEditorAction> actions = new ArrayList<StructEditorAction>();
        actions.add(new StructEditorActionDefine(this));
        actions.add(new StructEditorActionUndefine(this));
        actions.add(new StructEditorActionRename(this));
        actions.add(new StructEditorActionDefineArray(this));
        actions.add(new StructEditorActionSetType(this));
        Composite bar = new Composite((Composite)this, 0);
        bar.setLayout((Layout)new RowLayout());
        UIUtil.createLabel(bar, "Source: ");
        this.comboSource = new Combo(bar, 2056);
        this.comboSource.setToolTipText("The source of available types can be one of:\n- the types currently used by your project\n- all the types in the project and the types available in the loaded type libraries compatible with your project\n");
        this.comboSource.add("In-use types");
        this.comboSource.add("All types");
        this.comboSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NativeTypeEditorView.this.comboSource.getSelectionIndex();
                NativeTypeEditorView.this.selectSource(index);
            }
        });
        this.comboSource.select(0);
        this.typeSourceFlags = 1;
        UIUtil.createLabel(bar, "Type: ");
        this.comboSelectedType = new Combo(bar, 2048);
        this.comboSelectedType.setToolTipText("Start typing to trigger auto-complete. The star (*) wildcard character is allowed for flexible matching.");
        this.refreshTypesList();
        this.comboSelectedType.forceFocus();
        new AutocompleteComboInput(this.comboSelectedType){

            @Override
            protected char[] getAutoActivationChars() {
                StringBuilder sb = new StringBuilder("\b");
                for (char c = ' '; c < '\u007f'; c = (char)(c + '\u0001')) {
                    sb.append(c);
                }
                return sb.toString().toCharArray();
            }
        };
        this.btnPreviewDeep = new Button(bar, 32);
        this.btnPreviewDeep.setText("Deep Preview");
        this.btnPreviewDeep.setSelection(true);
        this.btnPreviewDeep.setToolTipText(Strings.ff("Include nested structures (up to %d) in preview", 10));
        this.btnPreviewDeep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeEditorView.this.generatePreview();
            }
        });
        this.btnPreviewPadding = new Button(bar, 32);
        this.btnPreviewPadding.setText("Padding");
        this.btnPreviewPadding.setToolTipText("Display padding and packing information as comments in preview");
        this.btnPreviewPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeEditorView.this.generatePreview();
            }
        });
        this.btnPreviewOffsets = new Button(bar, 32);
        this.btnPreviewOffsets.setText("Offsets");
        this.btnPreviewOffsets.setToolTipText("Display field offsets as comments in preview");
        this.btnPreviewOffsets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeEditorView.this.generatePreview();
            }
        });
        Button btnCreate = UIUtil.createPushbox(bar, "Create Structure...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextDialog dlg = new TextDialog(parent.getShell(), "Structure Name (global namespace)", "", null);
                dlg.setLineCount(1);
                String structName = dlg.open();
                if (structName != null) {
                    try {
                        IStructureType t = unit.getTypeManager().createStructure(structName);
                        NativeTypeEditorView.this.refreshTypesList();
                        NativeTypeEditorView.this.setSelectedType(t);
                        NativeTypeEditorView.this.view.setFocus();
                    }
                    catch (IllegalTypeNameException ex) {
                        UI.error(ex.getMessage());
                    }
                }
            }
        });
        btnCreate.setToolTipText("Click to create a new C-style structure type");
        Button btnImport = UIUtil.createPushbox(bar, "&Import C type...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<INativeType> types;
                String text;
                FileDialog dlg = new FileDialog(NativeTypeEditorView.this.getShell(), 4096);
                dlg.setText("Select a file containing the type definitions to import");
                dlg.setFilterExtensions(new String[]{"*.h;*.hpp;*.i", "*"});
                String path = dlg.open();
                if (path == null) {
                    return;
                }
                try {
                    text = Strings.decodeLocal(IO.readFile(path));
                }
                catch (IOException iOException) {
                    UI.error("Error reading input file");
                    return;
                }
                try {
                    TypeStringParser parser = new TypeStringParser(unit.getTypeManager());
                    types = parser.parseTypesRaw(text);
                }
                catch (Exception e1) {
                    UI.error("An error occurred while parsing the types");
                    logger.catching(e1);
                    return;
                }
                UI.info(NativeTypeEditorView.this.getShell(), "Imports", Strings.ff("Imported %d types", types.size()));
                NativeTypeEditorView.this.refreshTypesList();
            }
        });
        btnImport.setToolTipText("Import types defined in pure C");
        UIUtil.createPushbox(bar, S.s(365), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg = "If a structure is selected, the left-hand side panel represents the selected data structure memory layout.\n\nRight click on a row, at the given offset, to perform any of the following actions:\n- Define a field\n- Undefine a field\n- Rename a field\n- Create an array field\n- Set the type of a field\n\nYou may scroll down to access higher offsets.\n\nThe right-hand side represents a C-like representation of the structure.";
                MessageDialog.openInformation(parent.getShell(), "Native Type Editor - Help", msg);
            }
        });
        this.comboSelectedType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeEditorView.this.onTypeSelectionChange();
            }
        });
        this.comboSelectedType.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    int i = 0;
                    for (String s : NativeTypeEditorView.this.comboSelectedType.getItems()) {
                        if (s.equals(NativeTypeEditorView.this.comboSelectedType.getText())) {
                            NativeTypeEditorView.this.comboSelectedType.select(i);
                            NativeTypeEditorView.this.onTypeSelectionChange();
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        SashForm sashContainer = new SashForm((Composite)this, 256);
        sashContainer.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        Composite c1 = new Composite((Composite)sashContainer, 0);
        c1.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        Composite bar2 = new Composite(c1, 0);
        bar2.setLayoutData((Object)UIUtil.createGridDataFill(true, false));
        bar2.setLayout((Layout)new RowLayout(256));
        SelectionAdapter actionPushboxListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = (Integer)e.widget.getData("action_index");
                StructEditorAction a = (StructEditorAction)actions.get(index);
                if (a.canExecute()) {
                    a.execute();
                } else {
                    UI.warn("Cannot execute action");
                }
            }
        };
        UIUtil.createPushbox(bar2, "Define", (SelectionListener)actionPushboxListener).setData("action_index", (Object)0);
        UIUtil.createPushbox(bar2, "Delete", (SelectionListener)actionPushboxListener).setData("action_index", (Object)1);
        UIUtil.createPushbox(bar2, "Name", (SelectionListener)actionPushboxListener).setData("action_index", (Object)2);
        UIUtil.createPushbox(bar2, "Array", (SelectionListener)actionPushboxListener).setData("action_index", (Object)3);
        UIUtil.createPushbox(bar2, "Type", (SelectionListener)actionPushboxListener).setData("action_index", (Object)4);
        this.view = new InfiniTableView(c1, 4, new String[]{"Offset", "Size", "Name", "Type", "Comment"});
        this.view.setLayoutData(UIUtil.createGridDataFill(true, true));
        this.viewer = new InfiniTableViewer(this.view);
        this.provider = new StructFieldsProvider();
        this.viewer.setContentProvider(this.provider);
        this.viewer.setLabelProvider(new StructFieldLabelProvider());
        this.viewer.setTopId(0L, false);
        this.viewer.setMinimumAllowedId(0L);
        this.viewer.setInput(null);
        this.widgetPreview = new Text((Composite)sashContainer, 2818);
        this.widgetPreview.setEditable(false);
        this.widgetPreview.setFont(UIUtil.getCodeFont());
        WidgetActionWrapper actionWrapper = new WidgetActionWrapper((Control)this.view.getTable());
        actions.forEach(a -> actionWrapper.registerAction((JebAction)a));
    }

    public INativeCodeUnit<?> getInputUnit() {
        return this.unit;
    }

    public INativeType getSelectedType() {
        return this.type;
    }

    public IStructureType getSelectedStructure() {
        return TypeUtil.getNonAlias(this.type, IStructureType.class);
    }

    void selectSource(int index) {
        if (index == 0) {
            this.typeSourceFlags = 1;
        }
        if (index == 1) {
            this.typeSourceFlags = 3;
        }
        this.refreshTypesList();
        this.viewer.setInput(null);
    }

    private void refreshTypesList() {
        this.comboSelectedType.removeAll();
        List<INativeType> types = TypeUtil.retrieveAvailableTypes(this.unit, this.typeSourceFlags);
        types.addAll(0, this.unit.getTypeManager().getPrimitives().getTypes());
        int i = 0;
        for (INativeType t : types) {
            if ((t.getGenericFlags() & 0x200000) != 0 || Strings.startsWith(t.getSignature(false), "__synth_struct_", "__synth_enum_")) continue;
            String sig = t.getSignature(true);
            this.comboSelectedType.add(sig);
            this.comboSelectedType.setData("index_" + i, (Object)t);
            ++i;
        }
    }

    private void onTypeSelectionChange() {
        int index = this.comboSelectedType.getSelectionIndex();
        if (index >= 0) {
            INativeType t = (INativeType)this.comboSelectedType.getData("index_" + index);
            this.onTypeSelectionChange(t);
        }
    }

    private void onTypeSelectionChange(INativeType t) {
        if (t == null) {
            return;
        }
        this.setSelectedType(t);
    }

    void refresh() {
        int index0 = this.view.getTable().getSelectionIndex();
        this.viewer.refresh();
        this.generatePreview();
        IStructuredSelection sel1 = (IStructuredSelection)this.viewer.getSelection();
        if (sel1.isEmpty()) {
            this.view.getTable().setSelection(index0);
        }
    }

    public void setSelectedType(INativeType type) {
        this.type = type;
        this.viewer.setInput(type);
        if (type != null) {
            int currentSourceIndex;
            boolean ownType = type.getTypeManager() == this.unit.getTypeManager();
            int wantedSourceIndex = ownType ? 0 : 1;
            if (wantedSourceIndex != (currentSourceIndex = this.comboSource.getSelectionIndex())) {
                this.comboSource.select(wantedSourceIndex);
                if (wantedSourceIndex == 0) {
                    this.typeSourceFlags = 1;
                }
                if (wantedSourceIndex == 1) {
                    this.typeSourceFlags = 3;
                }
                this.refreshTypesList();
            }
            int i = 0;
            for (String itemName : this.comboSelectedType.getItems()) {
                if (itemName.equals(type.getSignature(true))) {
                    this.comboSelectedType.select(i);
                }
                ++i;
            }
        }
        this.generatePreview();
    }

    public ItemEntry getSelectedEntry() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel.isEmpty() ? null : (ItemEntry)sel.getFirstElement();
    }

    void generatePreview() {
        INativeType type = (INativeType)this.viewer.getInput();
        if (type == null) {
            this.widgetPreview.setText("<No Preview>");
            return;
        }
        boolean previewDeep = this.btnPreviewDeep.getSelection();
        boolean previewPadding = this.btnPreviewPadding.getSelection();
        boolean previewOffsets = this.btnPreviewOffsets.getSelection();
        PrettyTypeFormatter f = new PrettyTypeFormatter();
        if (previewDeep) {
            f.setLevelStructDepth(10);
        }
        f.setDisplayOffsets(previewOffsets);
        f.setDisplayPaddingInfo(previewPadding);
        f.setDisplayAliasedType(true);
        String str = f.format(type);
        INativeType type0 = TypeUtil.getNonAlias(type);
        if (type0 instanceof IStructureType) {
            IStructureType struc = (IStructureType)type0;
            int pad = struc.getPadding();
            int align = struc.getAlignment();
            if (pad != 1 || align != 0) {
                str = Strings.ff("// Size: %d, Padding: %s, Alignment: %d\n%s", struc.getSize(), pad == Integer.MAX_VALUE ? "NATURAL" : Integer.valueOf(pad), align, str);
            }
        } else {
            str = Strings.ff("// Size: %d\n%s", type0.getSize(), str);
        }
        this.widgetPreview.setText(str);
    }

    class StructFieldsProvider
    extends AbstractInfiniTableSectionProvider {
        StructFieldsProvider() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && !(newInput instanceof INativeType)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Object[] get(Object inputElement, long id, int cnt) {
            INativeType type0 = TypeUtil.getNonAlias((INativeType)inputElement);
            if (!(type0 instanceof IStructureType)) {
                return ArrayUtil.NO_OBJECT;
            }
            return this.readFields((IStructureType)type0, id, cnt);
        }

        private Object[] readFields(IStructureType struc, long id, int cnt) {
            int i;
            Assert.a(id >= 0L && cnt >= 0);
            long id1 = id + (long)cnt;
            ArrayList<ItemEntry> r = new ArrayList<ItemEntry>();
            List<? extends IStructureTypeField> fields = struc.getFieldsWithGaps();
            long currentId = 0L;
            for (i = 0; i < fields.size() && id < id1; ++i) {
                long nextId;
                IStructureTypeField elt = fields.get(i);
                long l = nextId = elt.isSynthetic() ? currentId + (long)elt.getSize() : currentId + 1L;
                if (id >= currentId && id < nextId) {
                    if (!elt.isSynthetic()) {
                        Assert.a(id == currentId);
                        r.add(new ItemEntry(elt.getOffset(), elt.getSize(), elt.getName(), elt.getType(), elt.isBitfield() ? Strings.ff("bitfield [%d:%d[", elt.getBitstart(), elt.getBitend()) : null, false));
                    } else {
                        int off = elt.getOffset() + (int)(id - currentId);
                        while (id < nextId && id < id1) {
                            r.add(new ItemEntry(off, 1, null, null, null, false));
                            ++off;
                            ++id;
                        }
                    }
                    currentId = ++id;
                    continue;
                }
                currentId = nextId;
            }
            if (id < id1) {
                long typeLastId = 0L;
                for (i = 0; i < fields.size(); ++i) {
                    IStructureTypeField elt = fields.get(i);
                    typeLastId += elt.isSynthetic() ? (long)elt.getSize() : 1L;
                }
                int delta = (int)((long)NativeTypeEditorView.this.type.getSize() - typeLastId);
                while (id < id1) {
                    r.add(new ItemEntry((int)(id + (long)delta), 1, null, null, null, true));
                    ++id;
                }
            }
            return r.toArray();
        }
    }

    static class StructFieldLabelProvider
    extends DefaultCellLabelProvider {
        StructFieldLabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 5;
        }

        @Override
        public void update(ViewerCell cell) {
            super.update(cell);
            if (cell.getColumnIndex() == 0 || cell.getColumnIndex() == 1) {
                cell.setFont(UIUtil.getCodeFont());
            }
            ItemEntry entry = (ItemEntry)cell.getElement();
            if (!entry.slack && ThemeManager.getInstance().isStandardTheme()) {
                int rgb = entry.type != null ? 0xFFFFB0 : 0xFFFFE0;
                cell.setBackground(UIAssetManager.getInstance().getColor(rgb));
            }
        }

        @Override
        public String getStringAt(Object element, int key) {
            ItemEntry e = (ItemEntry)element;
            switch (key) {
                case 0: {
                    return Strings.ff("+%08X", e.offset);
                }
                case 1: {
                    return Strings.ff("%04X", e.size);
                }
                case 2: {
                    return e.name;
                }
                case 3: {
                    if (e.type != null) {
                        return e.type.getSignature(true);
                    }
                    return null;
                }
                case 4: {
                    return e.comment;
                }
            }
            return null;
        }
    }
}

