/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryService;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NativeRoutinesFragment
extends AbstractFilteredTableFragment<INativeCodeUnit<?>, INativeMethodItem> {
    private static final ILogger logger = GlobalLog.getLogger(NativeRoutinesFragment.class);
    public static final int TYPESOURCE_INUSE = 1;
    public static final int TYPESOURCE_TYPELIBS = 2;
    public static final int TYPESOURCE_ALL = 3;
    private Combo comboSource;

    public NativeRoutinesFragment(Composite parent, int style, IRcpClientContext context, INativeCodeUnit<?> pbcu, IRcpUnitView unitView, int initialTypesource) {
        super(parent, style, pbcu, unitView, context, new ContentProvider(pbcu, initialTypesource), new LabelProvider());
        this.setLayout((Layout)new GridLayout(1, false));
        Composite c = UIUtil.createCompositeGrid(this, 0, 1, 2, null);
        UIUtil.createLabelInGridLayout(c, 0, "Source: ", 1);
        this.comboSource = new Combo(c, 2056);
        this.comboSource.add("Show all available routines");
        this.comboSource.add("Show only in-use routines (from unit)");
        this.comboSource.add("Show only importable routines (from typelibs)");
        this.comboSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NativeRoutinesFragment.this.comboSource.getSelectionIndex();
                ((ContentProvider)NativeRoutinesFragment.this.getProvider()).setTypeSource(index);
                NativeRoutinesFragment.this.refresh();
            }
        });
        this.comboSource.pack();
        this.setSource(initialTypesource);
        String[] columnNames = new String[]{S.s(738)};
        FilteredTableViewer viewer = this.buildFilteredViewer(this, columnNames, 0, false);
        this.setRefreshListener(viewer, e -> pbcu != null);
        this.layout();
    }

    @Override
    protected void initFilteredView(FilteredTableView view) {
        view.setLayoutData(UIUtil.createGridDataFill(true, true));
    }

    public void setSource(int source) {
        int index = -1;
        if ((source &= 3) == 3) {
            index = 0;
        } else if (source == 1) {
            index = 1;
        } else if (source == 2) {
            index = 2;
        }
        if (index >= 0) {
            this.comboSource.select(index);
        } else {
            this.comboSource.clearSelection();
        }
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof INativeMethodItem;
    }

    @Override
    public INativeMethodItem getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof INativeMethodItem)) {
            return null;
        }
        return (INativeMethodItem)row;
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        IEventListener listener;
        INativeCodeUnit<?> pbcu;
        int typesource;
        ViewerRefresher refresher;

        public ContentProvider(INativeCodeUnit<?> pbcu, int initialTypesource) {
            this.pbcu = pbcu;
            this.typesource = initialTypesource;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            TypeLibraryService tlsvc;
            ArrayList<INativeMethodItem> entries = new ArrayList<INativeMethodItem>();
            if ((this.typesource & 1) != 0) {
                for (INativeMethodItem m : this.pbcu.getMethods()) {
                    entries.add(m);
                }
            }
            if ((this.typesource & 2) != 0 && (tlsvc = this.pbcu.getTypeLibraryService()) != null) {
                for (ITypeLibrary tlib : tlsvc.getLoadedTypeLibraries()) {
                    for (INativeMethodItem m : tlib.getRoutines()) {
                        entries.add(m);
                    }
                }
            }
            return entries.toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }

        public void setTypeSource(int index) {
            switch (index) {
                case 0: {
                    this.typesource = 3;
                    break;
                }
                case 1: {
                    this.typesource = 1;
                    break;
                }
                case 2: {
                    this.typesource = 2;
                    break;
                }
                default: {
                    this.typesource = 0;
                }
            }
        }
    }

    static class LabelProvider
    implements IFilteredLabelProvider,
    ITableLabelProvider {
        LabelProvider() {
        }

        @Override
        public void addListener(ILabelProviderListener listener) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener listener) {
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            INativeMethodItem m = (INativeMethodItem)element;
            if (columnIndex == 0) {
                return m == null ? "" : m.getSignature(true);
            }
            throw new RuntimeException();
        }

        @Override
        public String getStringAt(Object element, int key) {
            return this.getColumnText(element, key);
        }

        @Override
        public Object[] getRowElements(Object row) {
            INativeMethodItem e = (INativeMethodItem)row;
            return new Object[]{e.getSignature(true)};
        }
    }
}

