/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.CodeConstant;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryService;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.NativeTypesFragment;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NamedConstantsFragment
extends AbstractFilteredTableFragment<INativeCodeUnit<?>, CodeConstant> {
    private static final ILogger logger = GlobalLog.getLogger(NativeTypesFragment.class);
    private FilteredTableViewer viewer;
    private ViewerRefresher refresher;

    public NamedConstantsFragment(Composite parent, int style, IRcpClientContext context, INativeCodeUnit<?> pbcu, IRcpUnitView unitView, Object sourceValue) {
        super(parent, style, pbcu, unitView, context, new ContentProvider(pbcu, sourceValue), new LabelProvider());
        this.setLayout((Layout)new GridLayout(1, false));
        String[] columnNames = new String[]{S.s(591), "Value"};
        this.viewer = this.buildFilteredViewer(this, columnNames, 0, false);
        this.refresher = this.setRefreshListener(this.viewer, e -> pbcu != null);
        this.layout();
    }

    @Override
    protected void initFilteredView(FilteredTableView view) {
        view.setLayoutData(UIUtil.createGridDataFill(true, true));
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof CodeConstant;
    }

    @Override
    public CodeConstant getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof CodeConstant)) {
            return null;
        }
        return (CodeConstant)row;
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        IEventListener listener;
        INativeCodeUnit<?> pbcu;
        Object sourceValue;
        ViewerRefresher refresher;

        public ContentProvider(INativeCodeUnit<?> pbcu, Object sourceValue) {
            this.pbcu = pbcu;
            this.sourceValue = sourceValue;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            ArrayList<CodeConstant> entries = new ArrayList<CodeConstant>();
            TypeLibraryService tlsvc = this.pbcu.getTypeLibraryService();
            if (tlsvc != null) {
                for (ITypeLibrary tlib : tlsvc.getLoadedTypeLibraries()) {
                    entries.addAll(tlib.getConstantManager().getNamedConstantsByValue(this.sourceValue));
                }
            }
            return entries.toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 1;
        }

        @Override
        public String getStringAt(Object element, int key) {
            CodeConstant e = (CodeConstant)element;
            if (key == 0) {
                return e == null ? "" : e.getName();
            }
            return "";
        }
    }
}

