/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeHierarchyNativeDetails;

public class DebugCodeHierarchyNativeDetails
extends CodeHierarchyNativeDetails {
    public DebugCodeHierarchyNativeDetails(INativeCodeUnit<?> nativeUnit) {
        super(nativeUnit);
    }

    @Override
    public String[] getColumnLabels() {
        String[] columnLabels = new String[]{"Name", "Address", "Size", "Height", "First insn"};
        ProcessorType procType = this.getNativeUnit().getProcessor().getType();
        if (procType == ProcessorType.ARM) {
            columnLabels = new String[]{"Name", "Address", "Size", "Mode", "Height", "First insn"};
        }
        return columnLabels;
    }

    @Override
    public int[] getColumnWidths() {
        ProcessorType procType = this.getNativeUnit().getProcessor().getType();
        int[] columnWidths = new int[]{150, 100, 60, 60, 60};
        if (procType == ProcessorType.ARM) {
            columnWidths = new int[]{150, 100, 60, 60, 60, 60};
        }
        return columnWidths;
    }

    @Override
    public int getColumnSize() {
        return this.getProcType() == ProcessorType.ARM ? 6 : 5;
    }

    private int column(int index) {
        return index + (this.getProcType() == ProcessorType.ARM ? 1 : 0);
    }

    @Override
    protected String getStringAt(ICodeItem item, CFG<? extends IInstruction> cfg, int key) {
        if (key == this.column(4)) {
            IInstruction insn = cfg.getInstruction(cfg.getEntryAddress());
            if (insn == null) {
                return null;
            }
            return insn.getMnemonic();
        }
        if (key == this.column(3)) {
            long height = cfg.getEndAddress() - cfg.getFirstAddress();
            if (height == (long)cfg.getEffectiveSize()) {
                return null;
            }
            return Long.toHexString(height).toUpperCase() + "h";
        }
        return super.getStringAt(item, cfg, key);
    }

    @Override
    public boolean[] useHexadecimalOrdering() {
        boolean[] blArray;
        if (this.getProcType() == ProcessorType.ARM) {
            boolean[] blArray2 = new boolean[6];
            blArray2[0] = true;
            blArray2[1] = true;
            blArray2[2] = true;
            blArray2[3] = false;
            blArray2[4] = true;
            blArray = blArray2;
            blArray2[5] = false;
        } else {
            boolean[] blArray3 = new boolean[5];
            blArray3[0] = true;
            blArray3[1] = true;
            blArray3[2] = true;
            blArray3[3] = true;
            blArray = blArray3;
            blArray3[4] = false;
        }
        return blArray;
    }
}

