/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import java.util.List;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class CodeUnitHierarchyFooter {
    private Composite parent;
    private Label l;
    private ICodeUnit unit;
    private ResizeListener listener;

    public CodeUnitHierarchyFooter(ICodeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.unit = unit;
    }

    public void buildRightAlignedOneLineLabel(Composite parent) {
        this.parent = parent;
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        UIUtil.setStandardLayout(c, 2, 0);
        Label filler = new Label(c, 16384);
        filler.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.l = new Label(c, 64);
        this.l.setLayoutData((Object)UIUtil.createGridDataFillHorizontalRightAligned());
    }

    public Label buildLabel(Composite parent) {
        this.parent = parent;
        Composite c = new Composite(parent, 0);
        GridLayout gl = UIUtil.setStandardLayout(c, 1, 0, 0);
        this.l = new Label(c, 64);
        this.l.setLayoutData((Object)UIUtil.createGridDataFillHorizontalRightAligned());
        this.listener = new ResizeListener(c, gl);
        parent.addListener(11, (Listener)this.listener);
        this.l.addListener(11, (Listener)this.listener);
        return this.l;
    }

    private static String buildText(int count, boolean classes, String unsure) {
        return count + unsure + " " + (classes ? PluralFormatter.count(count, "class", "classes") : PluralFormatter.countS(count, "method"));
    }

    private void setText(int count, boolean classes, String unsure) {
        this.l.setText(CodeUnitHierarchyFooter.buildText(count, classes, unsure));
        this.parent.getParent().getParent().layout(true, true);
    }

    public void resetFooter() {
    }

    public void updateFooter(FilteredTreeViewer treeViewer) {
    }

    private void populate(TreeItem[] items, FooterResult footerResult) {
        for (TreeItem t : items) {
            if (t.getData() instanceof ICodeNode && this.populate((ICodeNode)t.getData(), footerResult) || t.getItemCount() <= 0) continue;
            if (t.getExpanded()) {
                this.populate(t.getItems(), footerResult);
                continue;
            }
            footerResult.unsure = true;
        }
    }

    private void populateRecursive(ICodeNode node, FooterResult footerResult) {
        if (this.populate(node, footerResult)) {
            return;
        }
        for (ICodeNode iCodeNode : node.getChildren()) {
            this.populateRecursive(iCodeNode, footerResult);
        }
    }

    private boolean populate(ICodeNode node, FooterResult footerResult) {
        if (footerResult.hasClasses && node.getObject() instanceof ICodeClass) {
            ++footerResult.count;
            return true;
        }
        if (!footerResult.hasClasses && node.getObject() instanceof ICodeMethod) {
            ++footerResult.count;
            return true;
        }
        return false;
    }

    public void bindTree(final FilteredTreeViewer treeViewer) {
        treeViewer.addFilteredTextListener(new Listener(){

            public void handleEvent(Event event) {
            }
        });
        treeViewer.addTreeListener(new ITreeViewerListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
    }

    private class ResizeListener
    implements Listener {
        Composite c;
        GridLayout gl;
        int spaceFromRight = 20;
        boolean disabled = false;

        public ResizeListener(Composite c, GridLayout gl) {
            this.c = c;
            this.gl = gl;
        }

        public void handleEvent(Event event) {
            if (this.c.getBounds().width == 0 || this.disabled) {
                return;
            }
            this.disabled = true;
            try {
                int totalWidth = CodeUnitHierarchyFooter.this.parent.getSize().x;
                Control previous = null;
                for (Control child : CodeUnitHierarchyFooter.this.parent.getChildren()) {
                    if (child == this.c) break;
                    previous = child;
                }
                if (previous == null) {
                    return;
                }
                int previousElementEnd = previous.getBounds().x + previous.getBounds().width;
                if (previousElementEnd + (this.c.getBounds().width - this.gl.marginLeft) + 3 <= totalWidth) {
                    int space = totalWidth - previousElementEnd - (this.c.getBounds().width - this.gl.marginLeft) - this.spaceFromRight;
                    this.gl.marginLeft = space < 0 ? 0 : space;
                } else {
                    int space;
                    int xBound = this.c.getBounds().x;
                    if (xBound + (this.c.getBounds().width - this.gl.marginLeft) >= totalWidth) {
                        xBound = 0;
                    }
                    this.gl.marginLeft = (space = totalWidth - xBound - (this.c.getBounds().width - this.gl.marginLeft) - this.spaceFromRight) < 0 ? 0 : space;
                }
                CodeUnitHierarchyFooter.this.parent.layout(true, true);
                CodeUnitHierarchyFooter.this.parent.getParent().getParent().layout(true, true);
            }
            finally {
                this.disabled = false;
            }
        }
    }

    private class FooterResult {
        private boolean unsure;
        private int count;
        private boolean hasClasses;

        private FooterResult() {
            if (CodeUnitHierarchyFooter.this.unit.isDisposed()) {
                return;
            }
            List<? extends ICodeClass> classes = CodeUnitHierarchyFooter.this.unit.getClasses();
            this.hasClasses = classes != null && !classes.isEmpty();
        }
    }
}

