/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CodeNodeWrapper
implements Comparable<CodeNodeWrapper> {
    private ICodeNode node;
    private ICodeItem item;
    private String name;

    static List<CodeNodeWrapper> wrapNodes(Collection<? extends ICodeNode> nodes, boolean retrieveNames) {
        ArrayList<CodeNodeWrapper> r = new ArrayList<CodeNodeWrapper>(nodes.size());
        for (ICodeNode iCodeNode : nodes) {
            r.add(new CodeNodeWrapper(iCodeNode, retrieveNames));
        }
        return r;
    }

    static List<ICodeNode> unwrapNodes(Collection<CodeNodeWrapper> wnodes) {
        ArrayList<ICodeNode> r = new ArrayList<ICodeNode>(wnodes.size());
        for (CodeNodeWrapper wnode : wnodes) {
            r.add(wnode.node);
        }
        return r;
    }

    public CodeNodeWrapper(ICodeNode node, boolean retrieveName) {
        this.node = node;
        this.item = node.getObject();
        this.name = this.item == null || !retrieveName ? null : this.item.getName(true);
    }

    @Override
    public int compareTo(CodeNodeWrapper o) {
        return CodeNodeWrapper.compare(this, o);
    }

    private static int compare(CodeNodeWrapper a, CodeNodeWrapper b) {
        int score2;
        ICodeItem item1 = a.item;
        ICodeItem item2 = b.item;
        int score1 = CodeNodeWrapper.getBaseScore(item1);
        if (score1 > (score2 = CodeNodeWrapper.getBaseScore(item2))) {
            return -1;
        }
        if (score1 < score2) {
            return 1;
        }
        Integer r = CodeNodeWrapper.compareNullFirst(item1, item2);
        if (r != null) {
            return r;
        }
        String name1 = a.name;
        String name2 = b.name;
        r = CodeNodeWrapper.compareNullFirst(name1, name2);
        if (r != null) {
            return r;
        }
        return name1.compareTo(name2);
    }

    private static int getBaseScore(ICodeItem item) {
        if (item instanceof ICodePackage) {
            return 100;
        }
        if (item instanceof ICodeClass) {
            return 90;
        }
        if (item instanceof ICodeField) {
            return 80;
        }
        if (item instanceof ICodeMethod) {
            return 70;
        }
        return 0;
    }

    private static Integer compareNullFirst(Object item1, Object item2) {
        if (item1 == null) {
            if (item2 == null) {
                return 0;
            }
            return -1;
        }
        if (item2 == null) {
            return 1;
        }
        return null;
    }
}

