/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ICodeHierarchyExtraDetails;

public class CodeHierarchyNativeDetails
implements ICodeHierarchyExtraDetails {
    private final INativeCodeUnit<?> nativeUnit;
    private final ProcessorType procType;

    public CodeHierarchyNativeDetails(INativeCodeUnit<?> nativeUnit) {
        this.nativeUnit = nativeUnit;
        this.procType = nativeUnit.getProcessor().getType();
    }

    @Override
    public String[] getColumnLabels() {
        String[] stringArray;
        if (this.procType == ProcessorType.ARM) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "Name";
            stringArray2[1] = "Address";
            stringArray2[2] = "Size";
            stringArray = stringArray2;
            stringArray2[3] = "Mode";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "Name";
            stringArray3[1] = "Address";
            stringArray = stringArray3;
            stringArray3[2] = "Size";
        }
        return stringArray;
    }

    @Override
    public int[] getColumnWidths() {
        int[] nArray;
        if (this.procType == ProcessorType.ARM) {
            int[] nArray2 = new int[4];
            nArray2[0] = 150;
            nArray2[1] = 100;
            nArray2[2] = 60;
            nArray = nArray2;
            nArray2[3] = 60;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 150;
            nArray3[1] = 100;
            nArray = nArray3;
            nArray3[2] = 60;
        }
        return nArray;
    }

    @Override
    public int getColumnSize() {
        return this.procType == ProcessorType.ARM ? 4 : 3;
    }

    @Override
    public String getStringAt(ICodeItem item, int key) {
        INativeMethodDataItem data;
        if (item instanceof INativeMethodItem && (data = ((INativeMethodItem)item).getData()) != null && key < this.getColumnSize()) {
            if (key == 1) {
                return Long.toHexString(data.getMemoryAddress()).toUpperCase() + "h";
            }
            CFG<? extends IInstruction> cfg = data.getCFG();
            try {
                return this.getStringAt(item, cfg, key);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected String getStringAt(ICodeItem item, CFG<? extends IInstruction> cfg, int key) {
        if (key == 2) {
            return Integer.toHexString(cfg.getEffectiveSize()).toUpperCase() + "h";
        }
        if (key == 3) {
            int procMode = ((BasicBlock)cfg.getEntryBlock()).get(0).getProcessorMode();
            if (this.procType == ProcessorType.ARM) {
                return procMode == 16 ? "T32" : "A32";
            }
            return Integer.toString(procMode);
        }
        return null;
    }

    public INativeCodeUnit<?> getNativeUnit() {
        return this.nativeUnit;
    }

    public ProcessorType getProcType() {
        return this.procType;
    }

    @Override
    public boolean[] useHexadecimalOrdering() {
        boolean[] blArray;
        if (this.procType == ProcessorType.ARM) {
            boolean[] blArray2 = new boolean[4];
            blArray2[0] = true;
            blArray2[1] = true;
            blArray2[2] = true;
            blArray = blArray2;
            blArray2[3] = false;
        } else {
            boolean[] blArray3 = new boolean[3];
            blArray3[0] = true;
            blArray3[1] = true;
            blArray = blArray3;
            blArray3[2] = true;
        }
        return blArray;
    }
}

