/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.tree.CodeNodeUtil;
import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.UnitChangeEventData;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeHierarchy;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.AssetManagerOverlay;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.ActionEx;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.CodeHierarchyCustomFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTreeView;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.CodeUnitFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellTreeLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewerComparator;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IDndProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredStructuredViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayLogicalGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroupProperties;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.SeparatorRule;
import com.pnfsoftware.jeb.rcpclient.handlers.navigation.NavigationTreeCollapseAllHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.navigation.NavigationTreeCollapseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.navigation.NavigationTreeExpandHandler;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.HtmlSwtTreeFormatter;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.TreeUtil;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeFragmentUtil;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeHierarchyArrayGroupProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeNodeWrapper;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeUnitHierarchyFooter;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ICodeHierarchyExtraDetails;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.impl.SimpleCodeNode;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.impl.SimpleCodePackage;
import com.pnfsoftware.jeb.rcpclient.util.regex.PatternFilter;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CodeHierarchyFragment
extends AbstractUnitFragment<ICodeUnit> {
    private static final ILogger logger = GlobalLog.getLogger(CodeHierarchyFragment.class);
    private final INativeCodeUnit<?> nativeUnit;
    private final ICodeHierarchyExtraDetails extraDetails;
    private final ViewerRefresher refresher;
    private final FilteredTreeViewer ftv;
    private CodeUnitHierarchyFooter footer;
    private final ContentProvider contentProvider;
    private final LabelProvider labelProvider;
    private boolean autoRefreshDisabled;
    private Boolean usesExplicitDefaultPackage;
    private Boolean forceLogicalGroups;
    private AtomicInteger cacheCommand = new AtomicInteger();
    private WeakIdentityHashMap<ICodeNode, List<ICodeNode>> cacheMap = new WeakIdentityHashMap();
    private IEventListener pmListener;

    public CodeHierarchyFragment(Composite parent, int flags, IRcpClientContext context, final ICodeUnit unit, ICodeNode baseNode, int includedFlags, int excludedFlags, boolean disableInitialExpansion, Boolean usesExplicitDefaultPackage, boolean supportRefactoring, boolean showFilterByItemType) {
        super(parent, flags, unit, null, context);
        ToolItem item;
        ICodeHierarchy hier;
        UIUtil.setStandardLayout(this, 1, 0, 0);
        if (baseNode == null && (hier = unit.getHierarchy()) != null) {
            baseNode = hier.getRoot();
        }
        if (unit instanceof INativeCodeUnit) {
            this.nativeUnit = (INativeCodeUnit)unit;
            ToolBar toolBar = UIUtil.createHorizontalSwtToolBar(0, this);
            item = UIUtil.addToolItemCheck(toolBar, "eclipse/hierarchy_co.png", e -> this.toggleCheckPackages(e.getSelection()));
            item.setToolTipText("Hierarchical View");
            item.setSelection(this.shouldForceLogicalGroups());
            toolBar.setLayoutData((Object)UIUtil.createGridDataFillHorizontalRightAligned());
            UIUtil.createSeparator(this, true);
        } else {
            this.nativeUnit = null;
            item = null;
        }
        this.extraDetails = ICodeHierarchyExtraDetails.getExtraDetails(this.nativeUnit, this.getShowExtraColumns());
        this.cacheCommand.set(this.getUseCache() ? 0 : -2);
        this.usesExplicitDefaultPackage = usesExplicitDefaultPackage;
        int style = 0;
        String[] columnLabels = null;
        int[] columnWidths = null;
        if (this.hasExtraDetails()) {
            style = 65536;
            columnLabels = this.extraDetails.getColumnLabels();
            columnWidths = this.extraDetails.getColumnWidths();
        }
        this.contentProvider = new ContentProvider();
        this.contentProvider.setFlags(includedFlags, excludedFlags);
        final boolean[] displayedStates = new boolean[4];
        final boolean[] initialStates = new boolean[4];
        if (!showFilterByItemType) {
            displayedStates[0] = false;
            displayedStates[1] = false;
            displayedStates[2] = false;
            displayedStates[3] = false;
            initialStates[0] = true;
            initialStates[1] = true;
            initialStates[2] = true;
            initialStates[3] = true;
        } else if (this.nativeUnit != null) {
            displayedStates[0] = true;
            displayedStates[1] = false;
            displayedStates[2] = true;
            displayedStates[3] = false;
            initialStates[0] = false;
            initialStates[1] = false;
            initialStates[2] = true;
            initialStates[3] = false;
        } else {
            displayedStates[0] = true;
            displayedStates[1] = true;
            displayedStates[2] = true;
            displayedStates[3] = true;
            initialStates[0] = false;
            initialStates[1] = true;
            initialStates[2] = true;
            initialStates[3] = true;
        }
        this.labelProvider = new LabelProvider();
        FilteredTreeView view = new FilteredTreeView(this, style, columnLabels, columnWidths){

            @Override
            protected FilterText buildFilterText(Composite parent) {
                CodeHierarchyCustomFilter filterText = new CodeHierarchyCustomFilter(parent, displayedStates, initialStates);
                CodeHierarchyFragment.this.footer = new CodeUnitHierarchyFooter(unit);
                CodeHierarchyFragment.this.footer.buildLabel(filterText.getIconContainer());
                return filterText;
            }
        };
        view.setLayoutData(UIUtil.createGridDataFill(true, true));
        this.ftv = new FilteredTreeViewer(view, true){

            @Override
            protected FilteredTreeViewerComparator buildComparator(Comparator<? super String> comp) {
                return new FilteredTreeViewerComparator(comp, this){

                    @Override
                    public int compare(Viewer viewer, Object e1, Object e2) {
                        Object e1_ = e1;
                        Object e2_ = e2;
                        if (e1 instanceof IArrayGroup && ((IArrayGroup)e1).isSingle()) {
                            e1_ = ((IArrayGroup)e1).getFirstElement();
                        }
                        if (e2 instanceof IArrayGroup && ((IArrayGroup)e2).isSingle()) {
                            e2_ = ((IArrayGroup)e2).getFirstElement();
                        }
                        if (e1_ instanceof ICodeNode && ((ICodeNode)e1_).getObject() instanceof ICodePackage) {
                            if (!(e2_ instanceof ICodeNode) || !(((ICodeNode)e2_).getObject() instanceof ICodePackage)) {
                                return -1;
                            }
                        } else if (e2_ instanceof ICodeNode && ((ICodeNode)e2_).getObject() instanceof ICodePackage) {
                            return 1;
                        }
                        return super.compare(viewer, e1, e2);
                    }
                };
            }

            @Override
            protected AbstractFilteredFilter buildFilter(TreeViewer viewer) {
                return new CodeUnitFilter(viewer, this);
            }
        };
        this.ftv.getComparator().setGroupFirst(true);
        this.footer.bindTree(this.ftv);
        this.refresher = this.setRefreshListener(this.ftv, e -> {
            if (!this.autoRefreshDisabled && unit != null && e.getSource() == unit && e.getType() == J.UnitChange) {
                if (this.cacheCommand.get() >= 0) {
                    this.cacheCommand.set(-1);
                    if (e.getData() instanceof UnitChangeEventData) {
                        UnitChangeEventData edata = (UnitChangeEventData)e.getData();
                        if (edata.type == 1 || edata.type == 2 || edata.type == 3 || edata.type == 6 || edata.type == 9) {
                            this.cacheCommand.set(1);
                        }
                    } else {
                        e.getData();
                    }
                }
                return true;
            }
            return false;
        }, () -> {}, () -> {
            if (this.cacheCommand.get() == -1) {
                this.cacheMap.clear();
                this.cacheCommand.set(0);
            }
        });
        this.ftv.setFilterPatternFactory(new PatternFilter("", columnLabels));
        this.ftv.addFilteredTextListener(new Listener(){

            public void handleEvent(Event event) {
                if (event.data instanceof Integer && (Integer)event.data == -1) {
                    String msg = "Too many results: The tree was not fully expanded.";
                    logger.warn(msg, new Object[0]);
                    CodeHierarchyFragment.this.infoOptional(msg, "dlgCodeHierFilterTooManyResults");
                }
            }
        });
        Tree tree = this.getTree();
        if (this.hasExtraDetails()) {
            this.ftv.displayTreeAsTable();
            boolean[] ordering = this.extraDetails.useHexadecimalOrdering();
            if (ordering != null) {
                for (int i = 0; i < ordering.length; ++i) {
                    if (ordering[i]) continue;
                    this.ftv.getComparator().setAlternativeComparator(i, Strings.getComparator(false, false));
                }
            }
        }
        this.setPrimaryWidget((Control)tree);
        ColumnViewerToolTipSupport.enableFor(this.ftv.getViewer());
        if (context != null) {
            this.ftv.addSelectionChangedListener(e -> {
                if (!this.isFocusControl()) {
                    return;
                }
                String address = this.getActiveAddress();
                String text = Strings.ff("%s", address);
                this.context.getStatusIndicator().setText(text);
                context.recordLastUnitFragmentPosition(unit, this, null, address, this.getActiveItem());
            });
        }
        if (supportRefactoring) {
            this.ftv.addDragnDropSupport(new DndProvider());
        }
        this.ftv.setContentProvider(this.contentProvider);
        this.ftv.setLabelProvider(this.labelProvider);
        if (baseNode != null) {
            this.ftv.setInput(new ICodeNode[]{baseNode});
            this.ftv.getViewer().setExpandedState(baseNode, true);
            if (!disableInitialExpansion) {
                int expandedCount = 0;
                ArrayList<? extends ICodeNode> currentNodes = new ArrayList<ICodeNode>(baseNode.getChildren());
                while (true) {
                    ArrayList<? extends ICodeNode> nextNodes = new ArrayList<ICodeNode>();
                    for (ICodeNode iCodeNode : currentNodes) {
                        int expansion = iCodeNode.getInitialExpansion();
                        if (expansion < 1) continue;
                        this.ftv.setExpandedState(iCodeNode, true);
                        if (!this.ftv.getExpandedState(iCodeNode)) continue;
                        nextNodes.addAll(iCodeNode.getChildren());
                        if (expandedCount++ < 100) continue;
                        nextNodes.clear();
                        break;
                    }
                    if (nextNodes.isEmpty()) break;
                    currentNodes = nextNodes;
                }
                this.ftv.refresh();
            }
        }
        this.ftv.addDoubleClickListener(e -> {
            ICodeNode selected = this.getSelectedNode();
            if (selected == null) {
                ISelection selection = this.ftv.getSelection();
                if (!(selection instanceof TreeSelection)) {
                    return;
                }
                Object elt = ((TreeSelection)selection).getFirstElement();
                if (elt instanceof IArrayGroup) {
                    this.ftv.setExpandedState(elt, !this.ftv.getExpandedState(elt));
                }
            } else if (selected.getObject() instanceof ICodePackage) {
                this.ftv.setExpandedState(selected, !this.ftv.getExpandedState(selected));
            }
        });
        this.ftv.addContextMenu(this.labelProvider, new String[0], new Boolean[0], new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                AllHandlers.getInstance().fillManager(menuMgr, 16);
                menuMgr.add(new Separator());
                menuMgr.add(new NavigationTreeCollapseAllHandler());
                menuMgr.add(new NavigationTreeCollapseHandler());
                menuMgr.add(new NavigationTreeExpandHandler());
                menuMgr.add(new Separator());
                menuMgr.add(new ActionEx("toggleCacheUse", "Toggle Cache Use"){

                    @Override
                    public void run() {
                        boolean enabled = CodeHierarchyFragment.this.cacheCommand.compareAndSet(-2, 0);
                        if (!enabled) {
                            CodeHierarchyFragment.this.cacheCommand.set(-2);
                        }
                        CodeHierarchyFragment.this.cacheMap.clear();
                        logger.info("The cache of code hierarchy nodes is now %s (this setting can be set permanently in the options)", enabled ? "ENABLED" : "DISABLED");
                    }
                });
                menuMgr.add(new ActionEx("forceRefresh", "Force Refresh"){

                    @Override
                    public void run() {
                        if (CodeHierarchyFragment.this.cacheCommand.get() != -2) {
                            CodeHierarchyFragment.this.cacheCommand.set(-1);
                        }
                        CodeHierarchyFragment.this.refresher.request();
                    }
                });
            }
        });
        final IPropertyManager pm = context.getPropertyManager();
        int lastDot = ".ui.tree.treeBucket.Threshold".lastIndexOf(46);
        final String treeBucket = ".ui.tree.treeBucket.Threshold".substring(0, lastDot);
        lastDot = ".ui.tree.flatBucket.Threshold".lastIndexOf(46);
        final String flatBucket = ".ui.tree.flatBucket.Threshold".substring(0, lastDot);
        this.pmListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (e.getType() == J.PropertyChange && e.getData() instanceof PropertyChangeNotification) {
                    PropertyChangeNotification changes = (PropertyChangeNotification)e.getData();
                    for (PropertyChangeNotification.Entry entry : changes.entries()) {
                        boolean raiseRefresh = CodeHierarchyFragment.this.onPropertyChange(entry.getPropertyFullyQualifiedName(), treeBucket, flatBucket);
                        if (!raiseRefresh) continue;
                        CodeHierarchyFragment.this.usesExplicitDefaultPackage = null;
                        CodeHierarchyFragment.this.forceLogicalGroups = null;
                        if (item != null) {
                            item.setSelection(CodeHierarchyFragment.this.shouldForceLogicalGroups());
                        }
                        CodeHierarchyFragment.this.ftv.refresh();
                        break;
                    }
                }
            }
        };
        pm.addListener(this.pmListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                pm.removeListener(CodeHierarchyFragment.this.pmListener);
            }
        });
    }

    protected boolean onPropertyChange(String fqName, String treeBucket, String flatBucket) {
        return fqName.equals(".ui.tree.code.UseCache") || fqName.equals(".ui.tree.code.AlwaysShowExtraColumns") || fqName.startsWith(treeBucket) || fqName.startsWith(flatBucket);
    }

    private void toggleCheckPackages(boolean selected) {
        this.forceLogicalGroups = selected;
        this.ftv.refresh();
    }

    public void setAutoRefreshDisabled(boolean autoRefreshDisabled) {
        this.autoRefreshDisabled = autoRefreshDisabled;
    }

    public boolean isAutoRefreshDisabled() {
        return this.autoRefreshDisabled;
    }

    private boolean hasExtraDetails() {
        return this.extraDetails != null;
    }

    public void setHideTypes(boolean hideTypes) {
        if (hideTypes) {
            this.contentProvider.setFlags(-1, 65536);
        } else {
            this.contentProvider.setFlags(-1, 0);
        }
        this.ftv.refresh();
    }

    public boolean getHideTypes() {
        int[] flags = this.contentProvider.getFlags();
        return (flags[1] & 0x10000) != 0;
    }

    public void setShowAll(boolean showAll) {
        if (showAll) {
            this.contentProvider.setFlags(0, 0);
        } else {
            this.contentProvider.setFlags(256, 65536);
        }
        this.ftv.refresh();
    }

    public boolean getShowAll() {
        int[] flags = this.contentProvider.getFlags();
        return flags[0] == 0 && flags[1] == 0;
    }

    public IFilteredStructuredViewer getViewer() {
        return this.ftv;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.ftv.addDoubleClickListener(listener);
    }

    private boolean getUseCache() {
        if (this.context == null) {
            return false;
        }
        String pname = ".ui.tree.code.UseCache";
        return this.context.getPropertyManager().getBoolean(pname);
    }

    private boolean getShowExtraColumns() {
        if (this.context == null) {
            return false;
        }
        String pname = ".ui.tree.code.AlwaysShowExtraColumns";
        return this.context.getPropertyManager().getBoolean(pname);
    }

    private int getBucketLimit() {
        if (this.context == null) {
            return 1000;
        }
        String pname = this.nativeUnit != null ? ".ui.tree.flatBucket.Threshold" : ".ui.tree.treeBucket.Threshold";
        return this.context.getPropertyManager().getInteger(pname);
    }

    private int getBucketMaxElements() {
        if (this.context == null) {
            return 100;
        }
        String pname = this.nativeUnit != null ? ".ui.tree.flatBucket.MaxElements" : ".ui.tree.treeBucket.MaxElements";
        return this.context.getPropertyManager().getInteger(pname);
    }

    private int getMinimumSmartBucketSize() {
        if (this.context == null) {
            return 3;
        }
        String pname = this.nativeUnit != null ? ".ui.tree.flatBucket.MinSmartSize" : ".ui.tree.treeBucket.MinSmartSize";
        return this.context.getPropertyManager().getInteger(pname);
    }

    private List<SeparatorRule> getBucketSeparatorRules() {
        int endIndex;
        if (this.context == null) {
            return Arrays.asList(new SeparatorRule("_", "_*", false));
        }
        ArrayList<SeparatorRule> rules = new ArrayList<SeparatorRule>();
        String pname = this.nativeUnit != null ? ".ui.tree.flatBucket.SmartSeparators" : ".ui.tree.treeBucket.SmartSeparators";
        String s = this.context.getPropertyManager().getString(pname);
        ArrayList<String> rs = new ArrayList<String>();
        int startIndex = 0;
        while ((endIndex = s.indexOf("\",\"", startIndex)) > 0) {
            rs.add(s.substring(startIndex, endIndex + 1));
            startIndex = endIndex + 2;
        }
        rs.add(s.substring(startIndex));
        for (String r : rs) {
            if (!r.startsWith("\"") || !r.endsWith("\"")) {
                logger.error("Wrong bucket smart separator %s", r);
                continue;
            }
            r = r.substring(1, r.length() - 1);
            rules.add(new SeparatorRule(r, r + "*", false));
        }
        return rules;
    }

    private boolean getUsesExplicitDefaultPackage() {
        if (this.usesExplicitDefaultPackage == null) {
            if (this.context == null) {
                return false;
            }
            return this.context.getPropertyManager().getBoolean(".ui.tree.UseExplicitDefaultPackage");
        }
        return this.usesExplicitDefaultPackage;
    }

    private boolean shouldForceLogicalGroups() {
        if (this.forceLogicalGroups == null) {
            if (this.context == null) {
                return false;
            }
            String pname = this.nativeUnit != null ? ".ui.tree.flatBucket.SmartForce" : ".ui.tree.treeBucket.SmartForce";
            return this.context.getPropertyManager().getBoolean(pname);
        }
        return this.forceLogicalGroups;
    }

    private AbstractFilteredFilter getAbstractFilter() {
        ViewerFilter[] filters = this.ftv.getViewer().getFilters();
        if (filters != null && filters.length > 0 && filters[0] instanceof AbstractFilteredFilter) {
            return (AbstractFilteredFilter)filters[0];
        }
        return null;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case REFRESH: 
            case FIND: {
                return true;
            }
            case TREE_COLLAPSE_ALL: 
            case TREE_EXPAND_ALL: {
                return true;
            }
            case TREE_COLLAPSE: 
            case TREE_EXPAND: {
                return this.ftv.getViewer().getStructuredSelection() != null;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case REFRESH: {
                this.refresher.request();
                return true;
            }
            case FIND: {
                this.ftv.getFilteredTreeWidget().setFilterVisibility(true);
                return true;
            }
            case TREE_COLLAPSE_ALL: {
                this.ftv.getViewer().collapseAll();
                return true;
            }
            case TREE_EXPAND_ALL: {
                this.ftv.getViewer().expandAll();
                return true;
            }
            case TREE_COLLAPSE: {
                ITreeSelection sel = this.ftv.getViewer().getStructuredSelection();
                if (sel.getFirstElement() != null) {
                    this.ftv.getViewer().collapseToLevel(sel.getFirstElement(), -1);
                    return true;
                }
                return false;
            }
            case TREE_EXPAND: {
                ITreeSelection sel = this.ftv.getViewer().getStructuredSelection();
                if (sel.getFirstElement() != null) {
                    this.ftv.getViewer().expandToLevel(sel.getFirstElement(), -1);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private Object getSelectedElement() {
        ISelection selection = this.ftv.getSelection();
        if (!(selection instanceof TreeSelection)) {
            return null;
        }
        Object elt = ((TreeSelection)selection).getFirstElement();
        if (elt instanceof IArrayGroup && ((IArrayGroup)elt).isSingle()) {
            elt = ((IArrayGroup)elt).getFirstElement();
        }
        return elt;
    }

    public ICodeNode getSelectedNode() {
        Object elt = this.getSelectedElement();
        if (!(elt instanceof ICodeNode)) {
            return null;
        }
        return (ICodeNode)elt;
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return item != null && this.getActiveItem() == item;
    }

    @Override
    public IItem getActiveItem() {
        Object elt = this.getSelectedElement();
        if (!(elt instanceof IItem)) {
            return null;
        }
        return (IItem)elt;
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        return ((ICodeUnit)this.unit).getHierarchy().findNode(address, true) != null;
    }

    @Override
    public boolean setActiveAddress(String address, Object extraAddressDetails, boolean recordPosition, boolean allowComplexNavigation) {
        ICodeNode node = ((ICodeUnit)this.unit).getHierarchy().findNode(address, true);
        if (node != null) {
            this.focusOnNode(node);
            return true;
        }
        return false;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        ICodeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        ICodeItem item = node.getObject();
        if (item == null) {
            return null;
        }
        if (item instanceof INativeMethodItem && precision == AddressConversionPrecision.COARSE) {
            Long address = ((INativeMethodItem)item).getMemoryAddress();
            if (address == null) {
                return null;
            }
            return Strings.ff("%Xh", address);
        }
        return item.getAddress();
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(TreeUtil.buildXml(this.getTree(), 2));
    }

    @Override
    public String exportAsText(boolean formatAsHtml) {
        return formatAsHtml ? HtmlSwtTreeFormatter.buildHtml(this.getTree(), 2, ((ICodeUnit)this.unit).getName()) : TreeUtil.buildXml(this.getTree(), 2);
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TREE;
    }

    public boolean focusOnNode(ICodeNode node) {
        new StructuredSelection(node);
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(((ICodeUnit)this.unit).getHierarchy().getRoot());
        path.add(node);
        TreeSelection selection = new TreeSelection(new TreePath(path.toArray()));
        this.ftv.getViewer().reveal(node);
        this.ftv.setSelection(selection);
        if (this.getSelectedElement() == null) {
            boolean focused;
            path = new ArrayList();
            boolean autoExpand = true;
            if (autoExpand) {
                ArrayList<ICodeNode> pathNode = new ArrayList<ICodeNode>();
                this.getPathNode(node, this.contentProvider.getRoot(), pathNode, true);
                if (this.getUsesExplicitDefaultPackage() && !this.hasExtraDetails() && !(((ICodeNode)pathNode.get(0)).getObject() instanceof ICodePackage) && this.contentProvider.defaultPackage != null) {
                    pathNode.add(0, this.contentProvider.defaultPackage);
                }
                Tree t = this.getTree();
                try {
                    t.setRedraw(false);
                    TreeItem[] items = this.getTree().getItems();
                    for (ICodeNode o : pathNode) {
                        ArrayList<IArrayGroup> arrayPath = new ArrayList<IArrayGroup>();
                        TreeItem item = this.getIntermediateNodes(o, items, arrayPath);
                        for (IArrayGroup a : arrayPath) {
                            this.ftv.setExpandedState(a, true);
                        }
                        this.ftv.setExpandedState(o, true);
                        item = this.updateTreeItem(item, arrayPath, 0);
                        path.addAll(arrayPath);
                        if (arrayPath.isEmpty() || !((IArrayGroup)arrayPath.get(arrayPath.size() - 1)).isSingle()) {
                            path.add(o);
                            item = this.updateTreeItem(item, o);
                        }
                        if (item == null) break;
                        items = item.getItems();
                    }
                    logger.trace("Path to item: %s", Strings.joinList(path));
                    selection = new TreeSelection(new TreePath(path.toArray()));
                    this.ftv.setSelection(selection);
                    if (this.getSelectedElement() == null) {
                        AbstractFilteredFilter filter = this.getAbstractFilter();
                        if (filter != null && filter.isFiltered()) {
                            logger.debug("The item %s cannot be focused. It may be hidden by the current filter.", node.getLabel());
                        } else {
                            String msg = Strings.ff("The item  %s cannot be focused.", node.getLabel());
                            if (this.context != null) {
                                this.context.getErrorHandler().processThrowableSilent(new JebRuntimeException(msg));
                            }
                            UI.error(msg);
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    t.setRedraw(true);
                }
                return true;
            }
            this.getPath(node, this.getTree().getItems(), (List<Object>)path);
            path.add(0, ((ICodeUnit)this.unit).getHierarchy().getRoot());
            int pathSize = path.size();
            while (this.getSelectedElement() == null && !path.isEmpty()) {
                selection = new TreeSelection(new TreePath(path.toArray()));
                this.ftv.setSelection(selection);
                path.remove(path.size() - 1);
            }
            boolean bl = focused = this.getSelectedElement() != null && path.size() + 1 == pathSize;
            if (!focused) {
                String msg = "For performance reason, the node can not be automatically expanded.";
                logger.warn(msg, new Object[0]);
                this.infoOptional(msg, "dlgCodeHierNoExpand");
            }
        }
        return true;
    }

    private TreeItem updateTreeItem(TreeItem item, ICodeNode match) {
        if (item == null) {
            return null;
        }
        if (item.getData() == match) {
            return item;
        }
        for (TreeItem t : item.getItems()) {
            if (t.getData() != match) continue;
            return t;
        }
        return null;
    }

    private TreeItem updateTreeItem(TreeItem item, List<IArrayGroup> arrayPath, int i) {
        if (arrayPath.isEmpty()) {
            return item;
        }
        IArrayGroup match = arrayPath.get(i);
        if (arrayPath.size() == 1 && item.getData() == match) {
            return item;
        }
        for (TreeItem t : item.getItems()) {
            if (t.getData() != match) continue;
            if (i >= arrayPath.size() - 1) {
                return t;
            }
            return this.updateTreeItem(t, arrayPath, i + 1);
        }
        return null;
    }

    private TreeItem getIntermediateNodes(ICodeNode node, TreeItem[] items, List<IArrayGroup> arrayPath) {
        if (items != null) {
            for (TreeItem t : items) {
                if (t.getData() == node) {
                    return t;
                }
                if (!(t.getData() instanceof IArrayGroup) || !this.getIntermediatePathArrayGroup(node, (IArrayGroup)t.getData(), arrayPath)) continue;
                arrayPath.add(0, (IArrayGroup)t.getData());
                return t;
            }
        }
        return null;
    }

    private boolean getIntermediatePathArrayGroup(ICodeNode node, IArrayGroup ag, List<IArrayGroup> arrayPath) {
        if (ag.isSingle()) {
            if (ag.getFirstElement() == node) {
                return true;
            }
        } else {
            for (Object o : ag) {
                if (o == node) {
                    return true;
                }
                if (!(o instanceof IArrayGroup) || !this.getIntermediatePathArrayGroup(node, (IArrayGroup)o, arrayPath)) continue;
                arrayPath.add(0, (IArrayGroup)o);
                return true;
            }
        }
        return false;
    }

    private boolean getPath(ICodeNode node, TreeItem[] items, List<Object> path) {
        if (items != null) {
            for (TreeItem t : items) {
                if (this.getPath(node, t.getData(), path)) {
                    return true;
                }
                if (!this.getPath(node, t.getItems(), path)) continue;
                path.add(0, t.getData());
                return true;
            }
        }
        return false;
    }

    private boolean getPath(ICodeNode node, Object o, List<Object> path) {
        if (o instanceof ICodeNode) {
            if (this.getPathNodeObj(node, (ICodeNode)o, path)) {
                path.add(0, o);
                return true;
            }
        } else if (o instanceof IArrayGroup && this.getPathArrayGroup(node, (IArrayGroup)o, path)) {
            path.add(0, o);
            return true;
        }
        return false;
    }

    private boolean getPathArrayGroup(ICodeNode node, IArrayGroup ag, List<Object> path) {
        if (ag.isSingle()) {
            if (ag.getFirstElement() == node) {
                return true;
            }
        } else {
            for (Object o : ag) {
                if (!this.getPath(node, o, path)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getPathNodeObj(ICodeNode node, ICodeNode search, List<Object> path) {
        if (search == node) {
            return true;
        }
        for (ICodeNode iCodeNode : search.getChildren()) {
            if (!this.getPathNodeObj(node, iCodeNode, path)) continue;
            path.add(0, iCodeNode);
            return true;
        }
        return false;
    }

    private boolean getPathNode(ICodeNode node, ICodeNode search, List<ICodeNode> path, boolean first) {
        if (search == node) {
            if (first) {
                path.add(search);
            }
            return true;
        }
        for (ICodeNode iCodeNode : search.getChildren()) {
            if (!this.getPathNode(node, iCodeNode, path, false)) continue;
            path.add(0, iCodeNode);
            return true;
        }
        return false;
    }

    private void infoOptional(String msg, String widgetName) {
        UI.infoOptional(this.ftv.getFilteredTreeWidget().getShell(), null, msg, widgetName);
    }

    private Tree getTree() {
        return this.ftv.getFilteredTreeWidget().getTree();
    }

    class ContentProvider
    extends CodeHierarchyArrayGroupProvider {
        private ICodeNode root;
        private int includedFlags;
        private int excludedFlags;
        private SimpleCodeNode defaultPackage;

        public ContentProvider() {
            super(new IArrayGroupProperties(){

                @Override
                public int getLimit() {
                    return CodeHierarchyFragment.this.getBucketLimit();
                }

                @Override
                public int getGroupLimit() {
                    return CodeHierarchyFragment.this.getBucketMaxElements();
                }

                @Override
                public int getMinLogicalGroupSize() {
                    return CodeHierarchyFragment.this.getMinimumSmartBucketSize();
                }

                @Override
                public List<SeparatorRule> getSeparatorRules() {
                    return CodeHierarchyFragment.this.getBucketSeparatorRules();
                }

                @Override
                public boolean isForceLogicalGroups() {
                    return CodeHierarchyFragment.this.shouldForceLogicalGroups();
                }
            }, 20, CodeHierarchyFragment.this.nativeUnit != null ? CodeHierarchyArrayGroupProvider.Naming.Cpp : CodeHierarchyArrayGroupProvider.Naming.Generic);
        }

        @Override
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.root = null;
                return;
            }
            this.root = ((ICodeNode[])newInput)[0];
        }

        public ICodeNode getRoot() {
            return this.root;
        }

        public void setFlags(int includedFlags, int excludedFlags) {
            if (includedFlags >= 0) {
                this.includedFlags = includedFlags;
            }
            if (excludedFlags >= 0) {
                this.excludedFlags = excludedFlags;
            }
        }

        public int[] getFlags() {
            return new int[]{this.includedFlags, this.excludedFlags};
        }

        @Override
        public Object[] getElements(Object input) {
            if (((ICodeUnit)CodeHierarchyFragment.this.getUnit()).isDisposed()) {
                return new ICodeNode[0];
            }
            if (this.root == null) {
                return new ICodeNode[0];
            }
            if (this.root.getLabel() != null && !this.root.getLabel().isEmpty()) {
                return new ICodeNode[]{this.root};
            }
            return this.getChildren(this.root);
        }

        @Override
        public List<?> getChildren2(Object element) {
            AbstractFilteredFilter filter;
            List<ICodeNode> li;
            if (!(element instanceof ICodeNode)) {
                return new ArrayList(0);
            }
            ICodeNode node = (ICodeNode)element;
            if (CodeHierarchyFragment.this.cacheCommand.get() == 1 && (li = CodeHierarchyFragment.this.cacheMap.get(node)) != null) {
                return li;
            }
            if (CodeHierarchyFragment.this.getUsesExplicitDefaultPackage() && !CodeHierarchyFragment.this.hasExtraDetails() && element == this.root) {
                List<? extends ICodeNode> dpChildren0;
                li = CodeNodeUtil.getChildren(node, 32768, this.excludedFlags);
                List<ICodeNode> dpChildren = CodeNodeUtil.getChildren(node, this.includedFlags, 32768);
                if (this.defaultPackage != null && !dpChildren.equals(dpChildren0 = this.defaultPackage.getChildren())) {
                    this.defaultPackage = null;
                }
                if (this.defaultPackage == null) {
                    this.defaultPackage = new SimpleCodeNode(new SimpleCodePackage("(default package)", ""), this.root, dpChildren, true);
                }
                li.add(this.defaultPackage);
            } else {
                li = CodeNodeUtil.getChildren(node, this.includedFlags, this.excludedFlags);
            }
            li = this.filterOutEmptyPackages(li);
            List<CodeNodeWrapper> liw = CodeNodeWrapper.wrapNodes(li, !(CodeHierarchyFragment.this.unit instanceof INativeCodeUnit));
            Collections.sort(liw);
            li = CodeNodeWrapper.unwrapNodes(liw);
            if (li.size() > this.getLimit() && (filter = CodeHierarchyFragment.this.getAbstractFilter()) != null && filter.isFiltered()) {
                ArrayList<ICodeNode> li2 = new ArrayList<ICodeNode>();
                for (ICodeNode o : li) {
                    if (!filter.isElementMatch(o) && !this.isChildMatch(filter, o)) continue;
                    li2.add(o);
                }
                li = li2;
            }
            CodeHierarchyFragment.this.cacheMap.put(node, li);
            return li;
        }

        @Override
        protected String getLabel(Object rx) {
            return rx instanceof ICodeNode ? ((ICodeNode)rx).getLabel() : null;
        }

        private boolean isChildMatch(AbstractFilteredFilter filter, ICodeNode o) {
            List<? extends ICodeNode> children = o.getChildren();
            if (children == null || children.size() == 0) {
                return false;
            }
            for (ICodeNode iCodeNode : children) {
                if (filter.isElementMatch(iCodeNode)) {
                    return true;
                }
                boolean match = this.isChildMatch(filter, iCodeNode);
                if (!match) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getParent(Object element) {
            if (element instanceof ICodeNode) {
                return ((ICodeNode)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren2(Object element) {
            if (element instanceof ICodeNode) {
                return CodeNodeUtil.hasChildren((ICodeNode)element, this.includedFlags, this.excludedFlags);
            }
            return false;
        }

        @Override
        public void sort(Object[] elements) {
            CodeHierarchyFragment.this.ftv.getComparator().sort(CodeHierarchyFragment.this.ftv.getViewer(), elements);
        }

        List<ICodeNode> filterOutEmptyPackages(List<? extends ICodeNode> list) {
            ArrayList<ICodeNode> list2 = new ArrayList<ICodeNode>();
            for (ICodeNode iCodeNode : list) {
                if (iCodeNode.getObject() instanceof ICodePackage && !this.isNonEmptyPackageNode(iCodeNode) && CodeNodeUtil.cannotBe(iCodeNode, 16)) continue;
                list2.add(iCodeNode);
            }
            return list2;
        }

        boolean isNonEmptyPackageNode(ICodeNode parent) {
            for (ICodeNode node : CodeNodeUtil.getChildren(parent, this.includedFlags, this.excludedFlags)) {
                if (!(node.getObject() instanceof ICodePackage)) {
                    return true;
                }
                if (!this.isNonEmptyPackageNode(node)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void onFirstOptimization(List<?> r) {
            super.onFirstOptimization(r);
            String msg = "Your artifact has too many children. They were divided into group nodes.";
            logger.debug(msg, new Object[0]);
            CodeHierarchyFragment.this.infoOptional(msg, "dlgCodeHierFirstGroup");
        }
    }

    class LabelProvider
    extends DefaultStyledCellTreeLabelProvider {
        private int tooltipDecompShowCount;
        private static final int labelMaxLength = 300;
        private static final String labelTruncatedSfx = "[...]";

        LabelProvider() {
            super(CodeHierarchyFragment.this.contentProvider);
        }

        @Override
        public int getColumns(Object row) {
            return CodeHierarchyFragment.this.hasExtraDetails() ? CodeHierarchyFragment.this.extraDetails.getColumnSize() : 1;
        }

        @Override
        public void update(ViewerCell cell) {
            int index = cell.getColumnIndex();
            String iconRelPath = null;
            Image img = null;
            AssetManagerOverlay overlay = null;
            Object o = cell.getElement();
            if (o instanceof IArrayGroup && ((IArrayGroup)o).isSingle()) {
                o = ((IArrayGroup)o).getFirstElement();
            }
            cell.setForeground(null);
            cell.setBackground(null);
            if (index == 0 && o instanceof ICodeNode) {
                Couple<String, AssetManagerOverlay> r = CodeFragmentUtil.getCodeNodeIcon(((ICodeNode)o).getObject(), (ICodeUnit)CodeHierarchyFragment.this.unit);
                iconRelPath = r.getFirst();
                overlay = r.getSecond();
                Couple<Color, Color> cols = CodeFragmentUtil.getCodeNodeTextColors(((ICodeNode)o).getObject(), (ICodeUnit)CodeHierarchyFragment.this.unit);
                if (cols != null) {
                    Color bg;
                    Color fg = cols.getFirst();
                    if (fg != null) {
                        cell.setForeground(fg);
                    }
                    if ((bg = cols.getSecond()) != null) {
                        cell.setBackground(bg);
                    }
                }
            } else if (index == 0 && o instanceof ArrayLogicalGroup && ((ArrayLogicalGroup)o).isPackaged()) {
                iconRelPath = "eclipse/package_obj.png";
            }
            if (img == null && iconRelPath != null) {
                img = UIAssetManager.getInstance().getImage(iconRelPath, overlay);
            }
            if (img != null) {
                cell.setImage(img);
            }
            super.update(cell);
        }

        @Override
        public String getToolTipText(Object element) {
            ICodeItem item;
            if (this.tooltipDecompShowCount < 3 && element instanceof ICodeNode && ((item = ((ICodeNode)element).getObject()) instanceof ICodeClass || item instanceof ICodeMethod || item instanceof ICodeField) && DecompilerHelper.hasDecompilerFor((ICodeUnit)CodeHierarchyFragment.this.unit)) {
                ++this.tooltipDecompShowCount;
                return "Select and press TAB to Decompile";
            }
            return super.getToolTipText(element);
        }

        @Override
        public String getStringAt(Object element, int key) {
            if (element instanceof IArrayGroup) {
                return this.getArrayGroupStringAt((IArrayGroup)element, key);
            }
            if (element instanceof ICodeNode) {
                return this.getCodeNodeStringAt((ICodeNode)element, key);
            }
            return key == 0 ? "Hierarchy" : null;
        }

        public String getArrayGroupStringAt(IArrayGroup element, int key) {
            if (element instanceof ArrayLogicalGroup) {
                if (key == 0) {
                    return ((ArrayLogicalGroup)element).getGroupName();
                }
                if (((ArrayLogicalGroup)element).isPackaged()) {
                    return null;
                }
            }
            if (element.isSingle()) {
                if (key == 0 && element.getGroupName() != null) {
                    return element.getGroupName();
                }
                return this.getStringAt(element.getFirstElement(), key);
            }
            if (key > 1) {
                return null;
            }
            if (key == 1 && CodeHierarchyFragment.this.getTree().getSortColumn() != null && !CodeHierarchyFragment.this.getTree().getSortColumn().getText().equals("Address")) {
                return null;
            }
            Object[] o = this.getStartEndArrayGroupStringAt(element, key);
            return Strings.safe(o[0]) + " .. " + Strings.safe(o[1]);
        }

        private Object[] getStartEndArrayGroupStringAt(IArrayGroup row, int key) {
            Object first = row.getFirstElement();
            Object last = row.getLastElement();
            String firstNode = this.getStringAt(first, key);
            String lastNode = this.getStringAt(last, key);
            return new Object[]{firstNode, lastNode};
        }

        private String getCodeNodeStringAt(ICodeNode node, int key) {
            Object label = null;
            if (key == 0) {
                label = node.getLabel();
            } else if (CodeHierarchyFragment.this.hasExtraDetails()) {
                ICodeItem item = node.getObject();
                label = CodeHierarchyFragment.this.extraDetails.getStringAt(item, key);
            }
            if (label != null && ((String)label).length() > 300) {
                label = ((String)label).substring(0, 300 - labelTruncatedSfx.length()) + labelTruncatedSfx;
            }
            return label;
        }

        @Override
        public Object[] getRowElements(Object o) {
            Object[] res = super.getRowElements(o);
            if (o instanceof ICodeNode) {
                String nameOnly;
                ICodeItem item = ((ICodeNode)o).getObject();
                if (CodeHierarchyFragment.this.nativeUnit != null) {
                    Object parent = CodeHierarchyFragment.this.contentProvider.getParent(o);
                    if (parent != null) {
                        List<Object> fullPath = this.buildParentPath(parent);
                        if (fullPath.isEmpty()) {
                            return res;
                        }
                        fullPath.add(this.getStringAt(o, 0));
                        String column0 = Strings.join("::", fullPath);
                        Object[] newRes = new Object[res.length + 1];
                        newRes[res.length] = column0;
                        System.arraycopy(res, 0, newRes, 0, res.length);
                        return newRes;
                    }
                } else if ((item instanceof ICodeField || item instanceof ICodeMethod) && !(nameOnly = item.getName(true)).equals(res[0])) {
                    Object[] newRes = new Object[res.length + 1];
                    newRes[res.length] = nameOnly;
                    System.arraycopy(res, 0, newRes, 0, res.length);
                    return newRes;
                }
            }
            return res;
        }
    }

    class DndProvider
    implements IDndProvider {
        DndProvider() {
        }

        @Override
        public boolean canDrag(Object data) {
            if (data instanceof IArrayGroup && ((IArrayGroup)data).isSingle()) {
                data = ((IArrayGroup)data).getFirstElement();
            }
            if (data instanceof ICodeNode) {
                ICodeItem item = ((ICodeNode)data).getObject();
                if (item instanceof ICodePackage) {
                    return true;
                }
                if (item instanceof ICodeType) {
                    return true;
                }
                if (item instanceof ICodeClass) {
                    return true;
                }
                if (item instanceof ICodeMethod) {
                    return CodeHierarchyFragment.this.nativeUnit != null;
                }
                if (item instanceof ICodeField) {
                    return false;
                }
                (new Object[1])[0] = item;
            }
            return false;
        }

        @Override
        public boolean canDrop(String rawSource, Object target, int location) {
            CodeHierarchyDragData source = CodeHierarchyDragData.buildDragData(rawSource);
            if (source == null) {
                return false;
            }
            if (source.isPackage()) {
                return target instanceof ICodeNode && ((ICodeNode)target).getObject() instanceof ICodePackage && !source.isParentOf(target);
            }
            if (target instanceof ICodeNode) {
                ICodeItem item = ((ICodeNode)target).getObject();
                if (item instanceof ICodePackage) {
                    return true;
                }
                if (item instanceof ICodeType) {
                    return true;
                }
                if (item instanceof ICodeClass) {
                    return true;
                }
                if (item instanceof ICodeMethod) {
                    return false;
                }
                if (item instanceof ICodeField) {
                    return false;
                }
                (new Object[1])[0] = item;
            }
            return true;
        }

        private ICodePackage getPackageFor(Object target) {
            if (target instanceof ICodeNode) {
                ICodeItem item = ((ICodeNode)target).getObject();
                if (!(item instanceof ICodePackage)) {
                    if (item instanceof ICodeType) {
                        item = ((ICodeNode)target).getParent().getObject();
                    } else if (item instanceof ICodeClass) {
                        item = ((ICodeNode)target).getParent().getObject();
                    } else if (item instanceof ICodeMethod) {
                        item = ((ICodeNode)target).getParent().getObject();
                    }
                    if (!(item instanceof ICodePackage)) {
                        return null;
                    }
                }
                return (ICodePackage)item;
            }
            return null;
        }

        @Override
        public boolean performDrop(String rawSource, Object target, int location) {
            if (target instanceof ICodeNode) {
                ActionContext actionContext;
                ActionUIContext uictx;
                ICodeItem item;
                CodeHierarchyDragData source = CodeHierarchyDragData.buildDragData(rawSource);
                if (source == null) {
                    return false;
                }
                String dest = null;
                if (target instanceof ICodeNode && (item = ((ICodeNode)target).getObject()) != null) {
                    dest = item.getAddress();
                }
                if (dest == null) {
                    return false;
                }
                GraphicalActionExecutor exec = new GraphicalActionExecutor(CodeHierarchyFragment.this.getShell(), CodeHierarchyFragment.this.getContext());
                if (!exec.execute(uictx = new ActionUIContext(actionContext = new ActionContext((IInteractiveUnit)CodeHierarchyFragment.this.unit, 16, source.getId(), dest, AddressConversionPrecision.DEFAULT), CodeHierarchyFragment.this), dest)) {
                    logger.error("Cannot move item to %s", dest);
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public Object getSelectedElements() {
            return CodeHierarchyFragment.this.getSelectedElement();
        }

        @Override
        public String getDragData() {
            Object elt = CodeHierarchyFragment.this.getSelectedElement();
            if (elt instanceof IArrayGroup && ((IArrayGroup)elt).isSingle()) {
                elt = ((IArrayGroup)elt).getFirstElement();
            }
            if (elt instanceof ICodeNode) {
                CodeHierarchyDragData source = new CodeHierarchyDragData((ICodeNode)elt);
                return source.getSerializedObject();
            }
            return null;
        }

        @Override
        public boolean shouldExpand(String source, Object target) {
            return target instanceof ICodeNode && ((ICodeNode)target).getObject() instanceof ICodePackage;
        }

        static class CodeHierarchyDragData {
            private long itemId;
            private String serObject;

            public CodeHierarchyDragData(ICodeNode elt) {
                this.itemId = elt.getItemId();
                this.serObject = this.serialize(elt);
            }

            private CodeHierarchyDragData(String elt) {
                this.serObject = elt;
                this.itemId = Long.parseLong(elt.substring(2));
            }

            public static CodeHierarchyDragData buildDragData(String elt) {
                try {
                    return new CodeHierarchyDragData(elt);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }

            public long getId() {
                return this.itemId;
            }

            public boolean isPackage() {
                return this.serObject.startsWith("p;");
            }

            public boolean isParentOf(Object target) {
                if (target instanceof ICodeNode) {
                    if (((ICodeNode)target).getItemId() == this.itemId) {
                        return true;
                    }
                    return this.isParentOf(((ICodeNode)target).getParent());
                }
                return false;
            }

            public String getSerializedObject() {
                return this.serObject;
            }

            private String serialize(ICodeNode elt) {
                ICodeItem item = elt.getObject();
                String prefix = "g;";
                if (item instanceof ICodePackage) {
                    prefix = "p;";
                } else if (item instanceof ICodeType) {
                    prefix = "t;";
                } else if (item instanceof ICodeClass) {
                    prefix = "c;";
                } else if (item instanceof ICodeMethod) {
                    prefix = "m;";
                } else if (item instanceof ICodeField) {
                    prefix = "f;";
                }
                return prefix + Long.toString(elt.getItemId());
            }
        }
    }
}

