/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.AssetManagerOverlay;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.StyleManager;
import com.pnfsoftware.jeb.util.base.Couple;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CodeFragmentUtil {
    public static Couple<String, AssetManagerOverlay> getCodeNodeIcon(ICodeItem item, ICodeUnit unit) {
        Object iconRelPath = null;
        AssetManagerOverlay overlay = null;
        String visi = "default";
        int flags = item.getGenericFlags();
        if ((flags & 1) != 0) {
            visi = "public";
        } else if ((flags & 2) != 0) {
            visi = "private";
        } else if ((flags & 4) != 0) {
            visi = "protected";
        }
        if (item instanceof ICodePackage) {
            iconRelPath = "eclipse/package_obj.png";
        } else if (item instanceof ICodeType) {
            iconRelPath = "eclipse/types.png";
        } else if (item instanceof ICodeClass) {
            iconRelPath = (flags & 0x2000) != 0 ? "eclipse/annotation_obj.png" : ((flags & 0x200) != 0 ? "eclipse/int_obj.png" : ((flags & 0x4000) != 0 ? "eclipse/enum_obj.png" : "eclipse/class_obj.png"));
        } else if (item instanceof ICodeField) {
            iconRelPath = "eclipse/field_" + visi + "_obj.png";
        } else if (item instanceof ICodeMethod) {
            iconRelPath = "eclipse/method_" + visi + "_obj.png";
        }
        if (iconRelPath != null && (item instanceof ICodeField || item instanceof ICodeMethod)) {
            if ((flags & 8) != 0) {
                if (overlay == null) {
                    overlay = new AssetManagerOverlay();
                }
                overlay.addLayer("eclipse/static_co.png", new Point(0, 0));
            }
            if ((flags & 0x10) != 0) {
                if (overlay == null) {
                    overlay = new AssetManagerOverlay();
                }
                overlay.addLayer("eclipse/final_co.png", new Point(9, 0));
            }
            if ((flags & 0x10000) != 0) {
                if (overlay == null) {
                    overlay = new AssetManagerOverlay();
                }
                overlay.addLayer("eclipse/constr_ovr.png", new Point(0, 0));
            }
            if (!(unit instanceof INativeCodeUnit) && (flags & 0x100) != 0) {
                if (overlay == null) {
                    overlay = new AssetManagerOverlay();
                }
                overlay.addLayer("eclipse/native_co.png", new Point(0, 0));
            }
            if ((flags & 0x20) != 0) {
                if (overlay == null) {
                    overlay = new AssetManagerOverlay();
                }
                overlay.addLayer("eclipse/synch_co.png", new Point(9, 0));
            }
            if ((flags & 0x400) != 0) {
                if (overlay == null) {
                    overlay = new AssetManagerOverlay();
                }
                overlay.addLayer("eclipse/abstract_co.png", new Point(0, 0));
            }
        }
        return new Couple<String, Object>((String)iconRelPath, overlay);
    }

    public static Image getCodeNodeIcon2(ICodeItem item, ICodeUnit unit) {
        Image img = null;
        Couple<String, AssetManagerOverlay> r = CodeFragmentUtil.getCodeNodeIcon(item, unit);
        String iconRelPath = r.getFirst();
        AssetManagerOverlay overlay = r.getSecond();
        if (iconRelPath != null) {
            img = UIAssetManager.getInstance().getImage(iconRelPath, overlay);
        }
        return img;
    }

    public static Couple<Color, Color> getCodeNodeTextColors(ICodeItem item, ICodeUnit unit) {
        StyleManager styleman;
        Style s;
        INativeMethodItem m;
        boolean detected;
        if (item instanceof INativeMethodItem && (detected = (m = (INativeMethodItem)item).isDetectedAsLibraryCode()) && (s = (styleman = RcpClientContext.getInstance().getStyleManager()).getStyle(ItemClassIdentifiers.CODE_LIBRARY, false)) != null) {
            Color fg = null;
            if (s.getColor() != null) {
                fg = s.getColor();
            }
            Color bg = null;
            if (s.getBackgroungColor() != null) {
                bg = s.getBackgroungColor();
            }
            return new Couple<Color, Color>(fg, bg);
        }
        return null;
    }
}

