/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConventionManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.CallingConventionEditorDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CallingConventionManagerView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(CallingConventionManagerView.class);
    private INativeCodeUnit<?> unit;
    private ITypeManager typeman;
    private ICallingConventionManager ccman;
    private Combo comboSelectedCC;
    private Text widgetText;
    private Button btnRenderInternal;
    private boolean renderInternal;

    public CallingConventionManagerView(Composite parent, int style, final IEnginesContext engctx, final INativeCodeUnit<?> unit) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        this.typeman = unit.getTypeManager();
        this.ccman = this.typeman.getCallingConventionManager();
        ToolBar bar = new ToolBar((Composite)this, 320);
        bar.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        ToolItem item = new ToolItem(bar, 0);
        item.setText("Convention: ");
        item = new ToolItem(bar, 2);
        this.comboSelectedCC = new Combo((Composite)bar, 8);
        this.refreshCCList();
        this.comboSelectedCC.pack();
        item.setWidth(this.comboSelectedCC.getSize().x);
        item.setControl((Control)this.comboSelectedCC);
        this.comboSelectedCC.forceFocus();
        item = new ToolItem(bar, 2);
        this.btnRenderInternal = new Button((Composite)bar, 32);
        this.btnRenderInternal.setText("Internal   ");
        this.btnRenderInternal.setToolTipText("Format calling convention definitions using the internal parsable representation");
        this.btnRenderInternal.pack();
        item.setWidth(this.btnRenderInternal.getSize().x);
        item.setControl((Control)this.btnRenderInternal);
        this.btnRenderInternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CallingConventionManagerView.this.renderInternal = CallingConventionManagerView.this.btnRenderInternal.getSelection();
                CallingConventionManagerView.this.renderCCText(CallingConventionManagerView.this.getSelectedCC());
            }
        });
        item = new ToolItem(bar, 2);
        Button btnCreate = UIUtil.createPushbox((Composite)bar, "Copy and Customize...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICallingConvention ccTmpl = CallingConventionManagerView.this.getSelectedCC();
                CallingConventionEditorDialog editor = new CallingConventionEditorDialog(CallingConventionManagerView.this.getShell(), engctx, unit, ccTmpl);
                ICallingConvention cc = editor.open();
                if (cc != null) {
                    CallingConventionManagerView.this.ccman.addConvention(cc);
                    CallingConventionManagerView.this.refreshCCList();
                    CallingConventionManagerView.this.setSelectedCC(cc);
                }
            }
        });
        btnCreate.pack();
        item.setWidth(btnCreate.getSize().x);
        item.setControl((Control)btnCreate);
        bar.pack();
        this.comboSelectedCC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CallingConventionManagerView.this.comboSelectedCC.getSelectionIndex();
                if (index >= 0) {
                    ICallingConvention cc = (ICallingConvention)CallingConventionManagerView.this.comboSelectedCC.getData("index:" + index);
                    CallingConventionManagerView.this.onCCSelectionChange(cc);
                }
            }
        });
        this.widgetText = UIUtil.createTextboxInGrid(this, 2826, null, null, true, true);
        this.widgetText.setFont(UIUtil.getCodeFont());
    }

    public INativeCodeUnit<?> getInputUnit() {
        return this.unit;
    }

    private void refreshCCList() {
        this.comboSelectedCC.removeAll();
        int i = 0;
        for (ICallingConvention cc : this.ccman.getConventions()) {
            this.comboSelectedCC.add(cc.getName());
            this.comboSelectedCC.setData("index:" + i, (Object)cc);
            ++i;
        }
    }

    private void onCCSelectionChange(ICallingConvention cc) {
        if (cc == null) {
            return;
        }
        this.setSelectedCC(cc, true);
    }

    public ICallingConvention getSelectedCC() {
        int index = this.comboSelectedCC.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this.getCC(index);
    }

    private ICallingConvention getCC(int index) {
        return (ICallingConvention)this.comboSelectedCC.getData("index:" + index);
    }

    public void setSelectedCC(ICallingConvention cc) {
        this.setSelectedCC(cc, true);
    }

    private void setSelectedCC(ICallingConvention cc, boolean refresh) {
        if (cc != null) {
            for (int i = 0; i < this.comboSelectedCC.getItemCount(); ++i) {
                ICallingConvention cc0 = this.getCC(i);
                if (cc0 != cc) continue;
                this.comboSelectedCC.select(i);
            }
        }
        if (refresh) {
            this.renderCCText(cc);
        }
    }

    private void renderCCText(ICallingConvention cc) {
        String text = cc == null ? "" : cc.format(this.renderInternal ? 2 : 1);
        this.widgetText.setText(text);
    }
}

