/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionBuilder;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConventionManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.ProcessorManagerDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Collections;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CallingConventionEditorView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(CallingConventionEditorView.class);
    private INativeCodeUnit<?> unit;
    private ICallingConventionManager ccman;
    private Text widgetDef;
    private Text widgetError;
    static String helpmsg = "Calling conventions are written in YAML, using the following format (example):\n\n# a calling convention primary name is mandatory\nname: __cdecl\n# an aternative is to specify multiple names (the first entry is the primary name), e.g.:\n#names: [__cdecl, alt_name1, alt_name2]\n\n# optional list of processors (refer to ProcessorType)\n# at least one is recommended\nprocessors: [x86]\n\n# optional list of subsytems (refer to SubsystemType)\nsubsystems: []\n\n# optional list of compilers (refer to CompilerType)\n#compilers: []\n\n# optional list of flags (refer to ICallingConvention for a complete list of flags)\n# currently supported: STACK_CLEANED_BY_CALLEE, SUPPORT_FLOAT, OUTPUT_AFTER_INPUT, COMPLEX_VALUE_RETURNED_VIA_IMPLICIT_FIRST_PARAMETER_POINTER\nflags: [SUPPORT_FLOAT]\n\n# the entries below are optional; they are used to specify routine I/O slots (storage):\n# - registers (by name, refer to the appropriate register bank)\n# - stack slots, by index\n\nspoiled_registers: [eax,ecx,edx]\nreturn_address_location: stack@0\n\ninputs: [stack@1]\noutputs: [eax]\n\ninput_pairs: []\noutput_pairs: [eax+edx]\n\ninput_floats: [stack@1]\noutput_float: st(0)\n\nnotes: \"the description string is optional\"\n";

    public CallingConventionEditorView(Composite parent, int style, final IEnginesContext engctx, final INativeCodeUnit<?> unit, ICallingConvention ccTmpl) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        this.ccman = unit.getTypeManager().getCallingConventionManager();
        UIUtil.createLabelInGridLayout(this, 0, "Define your own calling convention. A unique name is preferable.", 1);
        Composite c = UIUtil.createCompositeGrid(this, 0, 1, 4, 0);
        UIUtil.createPushbox(c, "Help", e -> UI.info(this.getShell(), "Help", helpmsg));
        UIUtil.createPushbox(c, "Processor Registers", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessorManagerDialog dlg = new ProcessorManagerDialog(CallingConventionEditorView.this.getShell(), engctx, unit.getProcessor().getType());
                dlg.open();
            }
        });
        this.widgetDef = UIUtil.createTextboxInGrid(this, 2562, null, null, true, true);
        this.widgetDef.setFont(UIUtil.getCodeFont());
        UIUtil.disableTabOutput((Control)this.widgetDef);
        this.widgetDef.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = CallingConventionEditorView.this.widgetDef.getText();
                CallingConventionEditorView.this.verifyCC(text);
            }
        });
        this.widgetDef.setFocus();
        new Label((Composite)this, 0).setText("Parsing results:");
        this.widgetError = new Text((Composite)this, 2826);
        this.widgetError.setFont(UIUtil.getCodeFont());
        GridData griddata = UIUtil.createGridDataForText((Control)this.widgetError, 50, 2, false);
        griddata.horizontalSpan = 1;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        this.widgetError.setLayoutData((Object)griddata);
        if (ccTmpl != null) {
            CallingConventionBuilder b = CallingConventionUtil.parse(ccTmpl.format(2));
            Object notes = Strings.ff("\"forked from %s\"", ccTmpl.getName());
            if (!Strings.isBlank(ccTmpl.getNotes())) {
                notes = (String)notes + " / " + ccTmpl.getNotes();
            }
            b.setNotes((String)notes);
            b.setName("__usercallXxx");
            b.setAlternateNames(Collections.emptyList());
            String text = b.build().format(2);
            this.setDefinition(text);
            int pos = this.widgetDef.getText().indexOf("__usercallXxx");
            if (pos >= 0) {
                this.widgetDef.setSelection(pos, pos + "__usercallXxx".length());
            }
        }
    }

    public void setDefinition(String ccdef) {
        this.widgetDef.setText(ccdef);
    }

    private void verifyCC(String text) {
        try {
            CallingConventionUtil.parse(text);
            this.widgetError.setText("OK");
        }
        catch (Exception e) {
            this.widgetError.setText(Strings.safe(e.getMessage(), "An unknown parsing error occurred"));
        }
    }

    public boolean isValid() {
        return this.build() != null;
    }

    public ICallingConvention build() {
        String text = this.widgetDef.getText();
        if (!text.isEmpty()) {
            try {
                return CallingConventionUtil.parse(text).build();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public INativeCodeUnit<?> getInputUnit() {
        return this.unit;
    }
}

