/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.IWebBrowserSource;
import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.WebBrowserSource;
import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.WebBrowserViewer;
import com.pnfsoftware.jeb.rcpclient.parts.ILazyView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractNotAddressableUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WebBrowserFragment
extends AbstractNotAddressableUnitFragment<IBinaryUnit>
implements ILazyView {
    private static final ILogger logger = GlobalLog.getLogger(WebBrowserFragment.class);
    private WebBrowserViewer viewer;
    private IWebBrowserSource doc;

    public WebBrowserFragment(Composite parent, int flags, IRcpClientContext context, IBinaryUnit unit) {
        super(parent, flags, unit, null, context);
        this.setLayout((Layout)new FillLayout());
    }

    @Override
    public void lazyInitialization() {
        try {
            this.doc = new WebBrowserSource(((IBinaryUnit)this.unit).getName(), this.export());
            this.viewer = new WebBrowserViewer(this);
            this.viewer.setInput(this.doc);
            this.setPrimaryWidget((Control)this.viewer.getControl());
        }
        catch (IOException e) {
            logger.catching(e);
        }
    }

    @Override
    public byte[] export() {
        byte[] byArray;
        block8: {
            IInput input = ((IBinaryUnit)this.getUnit()).getInput();
            InputStream in = input.getStream();
            try {
                byte[] data;
                byArray = data = IO.readInputStream(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.catching(e);
                    return null;
                }
            }
            in.close();
        }
        return byArray;
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TEXT;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        return null;
    }
}

