/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.anno.AnnotationService;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.anno.TextAnnotation;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.CharSequences;
import java.util.ArrayList;
import java.util.List;

public class UnitTextAnnotator
implements IEventListener {
    UIState uiState;
    ITextDocumentViewer viewer;

    public UnitTextAnnotator(UIState uiState, ITextDocumentViewer viewer) {
        this.uiState = uiState;
        this.viewer = viewer;
        uiState.addListener(this);
    }

    public void dispose() {
        this.uiState.removeListener(this);
    }

    @Override
    public void onEvent(IEvent e) {
        this.viewer.unregisterAnnotations();
        for (String address : this.uiState.getBreakpoints().keySet()) {
            ICoordinates coord = this.viewer.getDocument().addressToCoordinates(address, CoordinatesConversionPrecision.BEST);
            if (coord == null) continue;
            String annoType = this.uiState.isBreakpointEnabled(address) ? "com.pnfsoftware.jeb.rcpclient.textAnno.dbgBP" : "com.pnfsoftware.jeb.rcpclient.textAnno.dbgBPDisabled";
            TextAnnotation anno = AnnotationService.getInstance().getFactory(annoType).create(coord);
            this.viewer.registerAnnotation(anno);
        }
        String pcAddress = this.uiState.getProgramCounter();
        if (pcAddress != null) {
            for (ICoordinates coord : this.getCoordsForAddress(pcAddress)) {
                this.viewer.registerAnnotation(AnnotationService.getInstance().getFactory("com.pnfsoftware.jeb.rcpclient.textAnno.dbgPC").create(coord));
            }
        }
    }

    List<ICoordinates> getCoordsForAddress(String address, int maxcnt) {
        ArrayList<ICoordinates> r = new ArrayList<ICoordinates>();
        ICoordinates coordFirst = this.viewer.getDocument().addressToCoordinates(address, CoordinatesConversionPrecision.FIRST);
        ICoordinates coordBest = this.viewer.getDocument().addressToCoordinates(address, CoordinatesConversionPrecision.BEST);
        ICoordinates coordLast = this.viewer.getDocument().addressToCoordinates(address, CoordinatesConversionPrecision.LAST);
        if (coordFirst == null || coordLast == null || coordLast.equals(coordFirst)) {
            if (coordBest != null) {
                r.add(coordBest);
            }
            return r;
        }
        if (coordBest != null && coordFirst.getAnchorId() == coordLast.getAnchorId()) {
            ArrayList<ICoordinates> rComments = new ArrayList<ICoordinates>();
            for (int i = Math.max(coordFirst.getLineDelta(), coordBest.getLineDelta() - maxcnt / 2); i <= coordLast.getLineDelta(); ++i) {
                Coordinates currentCoords = new Coordinates(coordFirst.getAnchorId(), i);
                ILine line = TextPartUtil.getLineAt(this.viewer.getCurrentDocumentPart(), currentCoords);
                if (line == null || line.getText().isEmpty() || CharSequences.startsWith(line.getText(), ";", true) || CharSequences.startsWith(line.getText(), "//", true)) {
                    rComments.add(currentCoords);
                    continue;
                }
                r.add(currentCoords);
                if (r.size() + 1 > maxcnt) break;
            }
            if (r.isEmpty()) {
                while (rComments.size() > maxcnt) {
                    rComments.remove(rComments.size() - 1);
                }
                return rComments;
            }
            return r;
        }
        ICoordinates coord = coordBest;
        int cnt = 0;
        while (cnt++ < maxcnt) {
            r.add(coord);
            coord = new Coordinates(coord.getAnchorId(), coord.getLineDelta() + 1, coord.getColumnOffset());
            String a2 = this.viewer.getDocument().coordinatesToAddress(coord);
            if (address.equals(a2)) continue;
            break;
        }
        return r;
    }

    List<ICoordinates> getCoordsForAddress(String address) {
        return this.getCoordsForAddress(address, 20);
    }

    ICoordinates getFirstCoordForAddress(String address) {
        return this.viewer.getDocument().addressToCoordinates(address);
    }
}

