/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.input.IInputLocation;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.INodeCoordinates;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.core.output.tree.impl.NodeCoordinates;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JumpToDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.InteractiveTreeViewer;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IDocumentBasedFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.ItemStyleProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TreeFragment
extends AbstractUnitFragment<IUnit>
implements IDocumentBasedFragment {
    private static final ILogger logger = GlobalLog.getLogger(TreeFragment.class);
    private ITreeDocument idoc;
    private InteractiveTreeViewer iviewer;
    private AddressNavigator navigator;

    public TreeFragment(Composite parent, int flags, IRcpClientContext context, IUnit unit, ITreeDocument idoc, IRcpUnitView unitView) {
        super(parent, flags, unit, unitView, context);
        this.setLayout((Layout)new FillLayout());
        this.idoc = idoc;
        this.iviewer = new InteractiveTreeViewer(this, 0, idoc, context.getPropertyManager());
        this.iviewer.setStyleAdapter(new ItemStyleProvider(context.getStyleManager()));
        this.iviewer.initialize();
        this.addDisposeListener(e -> this.iviewer.dispose());
        this.setPrimaryWidget((Control)this.iviewer.getTreeWidget());
        this.iviewer.getViewer().addSelectionChangedListener(e -> {
            if (!this.isFocusControl()) {
                return;
            }
            context.refreshHandlersStates();
            NodeCoordinates coord = this.iviewer.getPosition();
            String address = null;
            IInputLocation location = null;
            if (coord != null && (address = this.getAddressAt(coord)) != null && unit instanceof IInteractiveUnit) {
                IInteractiveUnit iunit = (IInteractiveUnit)unit;
                location = iunit.addressToLocation(address);
            }
            String statusText = Strings.ff("coord: %s | addr: %s | loc: %s", Strings.safe(coord, "?"), Strings.safe(address, "?"), Strings.safe(location, "?"));
            context.getStatusIndicator().setText(statusText);
            context.recordLastUnitFragmentPosition(unit, this, idoc, address, this.getActiveItem());
        });
        this.iviewer.getViewer().addDoubleClickListener(e -> {
            String target = this.getTargetAddress();
            if (target != null && !this.setActiveAddress(target) && this.navigator != null) {
                this.navigator.navigate(target);
            }
        });
    }

    public void setFilterVisibility(boolean visible, boolean focus) {
        this.iviewer.getFilteredTreeViewer().getControl().setFilterVisibility(visible, focus);
    }

    @Override
    public ITreeDocument getDocument() {
        return this.idoc;
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return item != null && this.getActiveItem() == item;
    }

    @Override
    public INode getActiveItem() {
        return this.iviewer.getSelectedNode();
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        NodeCoordinates coord = this.iviewer.getPosition();
        return this.getAddressAt(coord);
    }

    public String getAddressAt(INodeCoordinates coord) {
        if (coord == null) {
            return null;
        }
        if (this.iviewer.getFilteredTreeViewer().isFiltered() || this.iviewer.getTreeWidget().getSortColumn() != null) {
            return null;
        }
        return this.idoc.coordinatesToAddress(coord);
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        try {
            INodeCoordinates coord = this.idoc.addressToCoordinates(address);
            return coord != null;
        }
        catch (Exception e) {
            logger.catching(e);
            return false;
        }
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record, boolean allowComplexNavigation) {
        boolean success;
        INodeCoordinates coord;
        try {
            coord = this.idoc.addressToCoordinates(address);
        }
        catch (Exception e) {
            logger.catching(e);
            return false;
        }
        if (coord == null) {
            return false;
        }
        GlobalPosition pos0 = null;
        IViewManager viewManager = this.getViewManager();
        if (viewManager != null && record) {
            pos0 = viewManager.getCurrentGlobalPosition();
        }
        if ((success = this.iviewer.setPosition(coord, true)) && pos0 != null) {
            viewManager.recordGlobalPosition(pos0);
        }
        return true;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        if (!this.iviewer.getTreeWidget().isFocusControl()) {
            return false;
        }
        if (this.iviewer.verifyOperation(req)) {
            return false;
        }
        switch (req.getOperation()) {
            case JUMP_TO: {
                return true;
            }
            case ITEM_FOLLOW: {
                return this.getActiveItem() instanceof IActionableItem && !this.isMaster((IActionableItem)((Object)this.getActiveItem()));
            }
        }
        return false;
    }

    public String getTargetAddress() {
        INode item = this.getActiveItem();
        if (item == null) {
            return null;
        }
        return this.idoc.getReferencedAddress(item);
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        if (this.iviewer.doOperation(req)) {
            return true;
        }
        if (!req.proceed()) {
            return false;
        }
        switch (req.getOperation()) {
            case JUMP_TO: {
                JumpToDialog dlg = new JumpToDialog(this.getShell(), RcpClientContext.getStandardAddressHistory(this.getContext()), (IUnit)this.getUnit());
                String address = dlg.open();
                if (address != null) {
                    return this.setActiveAddress(address);
                }
                return false;
            }
            case ITEM_FOLLOW: {
                INode item = this.getActiveItem();
                if (!(item instanceof IActionableItem)) {
                    return false;
                }
                logger.trace("Following item: %s", item);
                return this.followItem((IActionableItem)((Object)item));
            }
        }
        return false;
    }

    private boolean followItem(IActionableItem item) {
        logger.trace("Following item: %s", item);
        if (item == null) {
            return false;
        }
        List<? extends INode> roots = this.iviewer.getInfiniDocument().getRoots();
        return this.followItem(item.getItemId(), roots, new ArrayList<Integer>());
    }

    private boolean followItem(long itemId, List<? extends INode> nodes, List<Integer> coordinates) {
        int index = 0;
        for (INode iNode : nodes) {
            IActionableItem actionableRoot;
            if (iNode instanceof IActionableItem && (actionableRoot = (IActionableItem)((Object)iNode)).getItemId() == itemId && this.isMaster(actionableRoot)) {
                return this.iviewer.setPosition(new NodeCoordinates(Arrays.asList(index)), true);
            }
            ArrayList<Integer> children = new ArrayList<Integer>(coordinates);
            children.add(index);
            boolean followChild = this.followItem(itemId, iNode.getChildren(), children);
            if (followChild) {
                return followChild;
            }
            ++index;
        }
        return false;
    }

    private boolean isMaster(IActionableItem item) {
        return (item.getItemFlags() & 1) != 0;
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.iviewer.exportToXml());
    }

    @Override
    public String exportAsText(boolean formatAsHtml) {
        return formatAsHtml ? this.iviewer.exportToHtml(this.unit.getName()) : this.iviewer.exportToXml();
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TREE;
    }

    public void setAddressNavigator(AddressNavigator navigator) {
        this.navigator = navigator;
    }

    public FilteredTreeViewer getFilteredTreeViewer() {
        return this.iviewer.getFilteredTreeViewer();
    }
}

