/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.client.api.UnitFragmentPosition;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.text.HtmlTextDocumentFormatter;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IMetadataManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.FindTextDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.QuickSearchDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FindTextOptions;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FinderManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.BufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.IAssistantRequestListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.IPositionListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextFindResult;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.TextDocumentLocationGenerator;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.BinaryCodeFinder;
import com.pnfsoftware.jeb.rcpclient.parts.units.ILocationListener;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.ItemStyleProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.Position;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextHoverableProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.UnitTextAnnotator;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class TextFragment
extends AbstractTextFragment {
    private static final ILogger logger = GlobalLog.getLogger(TextFragment.class);
    private List<ILocationListener> locationListeners = new ArrayList<ILocationListener>();
    private UnitTextAnnotator textAnnotator;
    private ItemStyleProvider tsa;
    private FinderManager<InteractiveTextFindResult> findman;
    private ITextDocumentPart lastKnownPart = null;
    private ICoordinates lastKnownCoordinates = null;
    private Map<AddressConversionPrecision, JebAddress> lastKnownAddress = new HashMap<AddressConversionPrecision, JebAddress>();

    public TextFragment(Composite parent, int style, IRcpClientContext context, IUnit unit, IRcpUnitView unitView, ITextDocument idoc) {
        this(parent, style, context, unit, unitView, idoc, false);
    }

    public TextFragment(Composite parent, int style, final IRcpClientContext context, IUnit unit, IRcpUnitView unitView, ITextDocument idoc, boolean simpleRendering) {
        super(parent, style, unit, unitView, context, idoc);
        this.setLayout((Layout)new FillLayout());
        boolean mayShowAssistantButton = context.getAssistant().checkLimitations(unit);
        this.iviewer = new InteractiveTextViewer(this, this.getFlags(unit), idoc, context.getPropertyManager(), this.getMetadataManager(unit), simpleRendering, mayShowAssistantButton);
        IAssistantRequestListener reqListener = new IAssistantRequestListener(){

            @Override
            public void onAssistantRequested() {
                ((RcpClientContext)context).getAssistant().request((IUnit)TextFragment.this.getUnit(), TextFragment.this, TextFragment.this.getActiveItem(), TextFragment.this.getActiveAddress());
            }
        };
        this.iviewer.addAssistantRequestListener(reqListener);
        context.getFontManager().registerWidget((Control)this.iviewer.getTextWidget());
        context.getThemeManager().registerWidget((Control)this.iviewer.getTextWidget());
        IEventListener styleListener = e -> this.iviewer.refresh();
        context.getStyleManager().addListener(styleListener);
        this.tsa = new ItemStyleProvider(context.getStyleManager());
        this.tsa.registerTextViewer(this.iviewer);
        this.iviewer.setStyleAdapter(this.tsa);
        this.findman = new FinderManager<InteractiveTextFindResult>(this.iviewer, context);
        if (idoc.hasBinaryRepresentation()) {
            BinaryCodeFinder binaryFinder = new BinaryCodeFinder(this.iviewer);
            this.findman.setBinaryFinder(binaryFinder);
        }
        if (!simpleRendering) {
            UIState uiState = context.getUIState(unit);
            this.textAnnotator = new UnitTextAnnotator(uiState, this.iviewer);
        }
        this.iviewer.initialize(true);
        this.iviewer.getTextWidget().setDoubleClickEnabled(false);
        this.iviewer.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TextFragment.this.requestOperation(new OperationRequest(Operation.ITEM_FOLLOW));
            }
        });
        this.setPrimaryWidget((Control)this.iviewer.getTextWidget());
        IPositionListener posListener = new IPositionListener(){

            @Override
            public void positionChanged(ITextDocumentViewer viewer, ICoordinates coordinates, int focusChange) {
                Assert.a(viewer == TextFragment.this.iviewer);
                TextFragment.this.onPositionChanged(coordinates, focusChange);
            }

            @Override
            public void positionUnchangedAttemptBreakout(ITextDocumentViewer viewer, int direction) {
            }
        };
        this.iviewer.addPositionListener(posListener);
        this.iviewer.refreshStyles();
        if (!context.getPropertyManager().getBoolean(".ui.GloballyDisablePopupsOnMouseHover")) {
            this.iviewer.setHoverText(new TextHoverableProvider(context, unit, this.iviewer));
        }
        this.addStandardContextMenu(new int[0]);
        this.addDisposeListener(e -> {
            context.getStyleManager().removeListener(styleListener);
            UnitFragmentPosition pos = context.getLastUnitFragmentPosition();
            if (pos != null && pos.getFragment() == this) {
                context.resetLastUnitFragmentPosition();
            }
            this.iviewer.dispose();
            if (this.textAnnotator != null) {
                this.textAnnotator.dispose();
            }
        });
    }

    private int getFlags(IUnit unit) {
        int flags = 0;
        if (!Licensing.isDebugBuild() && !this.context.isDevelopmentMode()) {
            flags |= 2;
        }
        if (unit instanceof ISourceUnit) {
            flags |= 8;
        }
        return flags;
    }

    private IMetadataManager getMetadataManager(IUnit unit) {
        IMetadataManager mm = null;
        if (unit instanceof IInteractiveUnit) {
            if (unit instanceof ISourceUnit) {
                return null;
            }
            mm = ((IInteractiveUnit)unit).getMetadataManager();
        }
        return mm;
    }

    private void onPositionChanged(ICoordinates coord, int focusChange) {
        TextDocumentLocationGenerator locationGenerator = new TextDocumentLocationGenerator(this.unit, this.iviewer);
        String address = locationGenerator.getAddress(coord);
        for (ILocationListener listener : this.locationListeners) {
            listener.locationChanged(address);
        }
        if (!this.isFocusControl()) {
            return;
        }
        if (OSType.determine().isWindows() || focusChange == 0) {
            this.context.refreshHandlersStates();
        }
        String status = locationGenerator.generateStatus(coord);
        this.setStatusIndicator(status);
        this.context.recordLastUnitFragmentPosition(this.unit, this, this.idoc, address, this.getActiveItem());
        this.highlightPotentialAddress();
    }

    public void addLocationListener(ILocationListener listener) {
        this.locationListeners.add(listener);
    }

    public void removeLocationListener(ILocationListener listener) {
        this.locationListeners.remove(listener);
    }

    @Override
    public ITextDocument getDocument() {
        return this.idoc;
    }

    public ICoordinates getCurrentCoordinates() {
        return this.iviewer.getCaretCoordinates();
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return this.tsa.isActiveItem(item);
    }

    @Override
    public IItem getActiveItem() {
        return this.tsa.getActiveItem();
    }

    @Override
    public String getActiveAddress() {
        return this.getActiveAddress(AddressConversionPrecision.FINE);
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        ICoordinates coord = this.iviewer.getCaretCoordinates();
        return this.getAddressAt(precision, coord);
    }

    @Override
    public String getActiveItemAsText() {
        ITextItem item;
        ILine line;
        ICoordinates coords = this.getCurrentCoordinates();
        if (this.getActiveItem() != null && coords != null && (line = TextPartUtil.getLineAt(this.iviewer.getCurrentDocumentPart(), coords)) != null && (item = TextPartUtil.getItemAt(line, coords.getColumnOffset())) != null) {
            return line.getText().subSequence(item.getOffset(), item.getOffsetEnd()).toString();
        }
        return null;
    }

    public String getAddressAt(AddressConversionPrecision precision, ICoordinates coord) {
        JebAddress lastJebAddress;
        if (coord == null) {
            return null;
        }
        if (this.lastKnownPart != this.iviewer.getCurrentDocumentPart() || !coord.equals(this.lastKnownCoordinates)) {
            this.lastKnownPart = this.iviewer.getCurrentDocumentPart();
            this.lastKnownCoordinates = coord;
            this.lastKnownAddress.clear();
        }
        if ((lastJebAddress = this.lastKnownAddress.get((Object)precision)) == null) {
            String lastAddress = this.idoc.coordinatesToAddress(coord, precision);
            lastJebAddress = new JebAddress(lastAddress, precision);
            this.lastKnownAddress.put(precision, lastJebAddress);
        }
        return lastJebAddress.getAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Position getActivePosition() {
        String address = this.getActiveAddress();
        if (address == null) {
            IAnchor anchor = TextPartUtil.getLastAnchor(this.iviewer.getCurrentDocumentPart());
            if (this.iviewer.getTextWidget().getCaretOffset() != this.iviewer.getTextWidget().getCharCount()) return null;
            if (this.isLastAnchorDisplayed(anchor)) {
                List<? extends ILine> lines = TextPartUtil.getLinesOfAnchor(this.iviewer.getCurrentDocumentPart(), anchor.getIdentifier());
                address = this.idoc.coordinatesToAddress(new Coordinates(anchor.getIdentifier(), lines.size() - 1));
            } else {
                logger.catchingSilent(new RuntimeException("Can not determine last position for " + this.idoc));
                return null;
            }
        }
        BufferPoint vp = this.iviewer.getCaretViewportPoint();
        return new Position(address, vp);
    }

    private boolean isLastAnchorDisplayed(IAnchor anchor) {
        if (anchor.getIdentifier() == this.idoc.getFirstAnchor() + this.idoc.getAnchorCount() - 1L) {
            return true;
        }
        try {
            ITextDocumentPart tempPart = this.idoc.getDocumentPart(this.idoc.getFirstAnchor() + this.idoc.getAnchorCount() - 1L, 1);
            IAnchor anchorEnd = TextPartUtil.getLastAnchor(tempPart);
            return anchorEnd.getIdentifier() == anchor.getIdentifier();
        }
        catch (Exception e) {
            logger.catchingSilent(e);
            return false;
        }
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        try {
            ICoordinates coord = this.idoc.addressToCoordinates(address);
            if (coord != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.catching(e);
        }
        if (this.viewNavigatorHelper != null) {
            return this.viewNavigatorHelper.canHandleAddress(this, address);
        }
        return false;
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record, boolean allowComplexNavigation) {
        ICoordinates coord = null;
        try {
            coord = this.idoc.addressToCoordinates(address);
        }
        catch (Exception e) {
            logger.catching(e);
        }
        GlobalPosition pos0 = null;
        IViewManager viewManager = this.getViewManager();
        if (viewManager != null && record) {
            pos0 = viewManager.getCurrentGlobalPosition();
        }
        boolean success = false;
        if (coord == null) {
            if (allowComplexNavigation) {
                success = this.viewNavigatorHelper != null && this.viewNavigatorHelper.navigateTo(this, address, viewManager, false);
            }
        } else {
            BufferPoint vp = null;
            if (extra instanceof BufferPoint) {
                vp = (BufferPoint)extra;
            }
            success = this.iviewer.setCaretCoordinates(coord, vp, true);
        }
        if (success && pos0 != null) {
            viewManager.recordGlobalPosition(pos0);
            this.context.refreshHandlersStates();
        }
        return success;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        if (this.iviewer.verifyOperation(req)) {
            return true;
        }
        switch (req.getOperation()) {
            case FIND: {
                return true;
            }
            case FIND_NEXT: {
                return this.findman != null;
            }
            case JUMP_TO: {
                return true;
            }
            case ITEM_FOLLOW: 
            case ITEM_PREVIOUS: 
            case ITEM_NEXT: {
                return this.getActiveItem() instanceof IActionableItem;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        if (this.iviewer.doOperation(req)) {
            return true;
        }
        if (!req.proceed()) {
            return false;
        }
        switch (req.getOperation()) {
            case FIND: {
                JebDialog dlg;
                boolean useQuickSearchFirst;
                boolean preferLegacyFind = this.context.getPropertyManager().getBoolean(".ui.text.PreferLegacyFindDialog");
                boolean bl = useQuickSearchFirst = !preferLegacyFind;
                if (useQuickSearchFirst) {
                    dlg = JebDialog.getInstance(QuickSearchDialog.class);
                    if (dlg != null) {
                        dlg.setFocus();
                        return true;
                    }
                    ICoordinates coord = this.iviewer.getCaretCoordinates();
                    String selection = this.iviewer.getSelectionText();
                    if ((selection = this.getFirstNonEmptyLineFromSelection(selection)) != null && selection.isEmpty()) {
                        selection = null;
                    }
                    dlg = new QuickSearchDialog(this.getShell(), (RcpClientContext)this.getContext());
                    ((QuickSearchDialog)dlg).setSource(this.context.getOpenedProject());
                    ((QuickSearchDialog)dlg).setSource((IUnit)this.getUnit());
                    ((QuickSearchDialog)dlg).setSource(this.getDocument(), coord);
                    ((QuickSearchDialog)dlg).setSearchString(selection);
                    int retcode = ((QuickSearchDialog)dlg).open();
                    if (retcode != 1) {
                        return true;
                    }
                }
                if ((dlg = FindTextDialog.getInstance(this)) != null) {
                    if (dlg.getShell().isDisposed()) {
                        String details = FindTextDialog.debugPrint();
                        RuntimeException ex = new RuntimeException("A dangling reference to a Find dialog was found");
                        this.context.getErrorHandler().processThrowable(ex, false, false, true, details, null, null);
                    } else {
                        dlg.setFocus();
                        return true;
                    }
                }
                FindTextOptions opt = this.iviewer.getFindTextOptions(true);
                String selection = this.iviewer.getSelectionText();
                boolean retrieveSelection = false;
                if (!Strings.isBlank(selection)) {
                    retrieveSelection = true;
                }
                if (retrieveSelection && !Strings.isBlank(selection) && (selection = this.getFirstNonEmptyLineFromSelection(selection)) != null) {
                    opt.setSearchString(selection);
                }
                TextHistory history = RcpClientContext.getStandardFindTextHistory(this.context);
                dlg = new FindTextDialog(this.getShell(), this.findman, history, false, (Control)this, this.getUnit().getName());
                ((FindTextDialog)dlg).setShowTickboxForLegacyFindDialog(true);
                ((FindTextDialog)dlg).setPreferLegacyFindDialog(preferLegacyFind);
                ((FindTextDialog)dlg).open(this);
                preferLegacyFind = ((FindTextDialog)dlg).isPreferLegacyFindDialog();
                this.context.getPropertyManager().setBoolean(".ui.text.PreferLegacyFindDialog", preferLegacyFind);
                return true;
            }
            case FIND_NEXT: {
                this.findman.search(null);
                return true;
            }
            case JUMP_TO: {
                return this.doJumpTo();
            }
            case ITEM_FOLLOW: {
                return this.doItemFollow();
            }
            case ITEM_NEXT: {
                IItem item = this.getActiveItem();
                if (!(item instanceof IActionableItem)) {
                    return false;
                }
                return this.nextItem((IActionableItem)((Object)item));
            }
            case ITEM_PREVIOUS: {
                IItem item = this.getActiveItem();
                if (!(item instanceof IActionableItem)) {
                    return false;
                }
                return this.previousItem((IActionableItem)((Object)item));
            }
        }
        return false;
    }

    String getFirstNonEmptyLineFromSelection(String selection) {
        int endline = selection.indexOf("\n");
        if (endline == 0) {
            int firstIndex = 0;
            while (firstIndex == endline && firstIndex + 1 < selection.length()) {
                endline = selection.indexOf("\n", ++firstIndex);
            }
            selection = firstIndex + 1 == selection.length() ? null : (endline >= 0 ? selection.substring(firstIndex, endline) : selection.substring(firstIndex));
        } else if (endline > 0) {
            selection = selection.substring(0, endline);
        }
        return selection;
    }

    private boolean nextItem(IActionableItem _item) {
        if (_item == null || _item.getItemId() == 0L) {
            return false;
        }
        long _id = _item.getItemId();
        logger.trace("Searching for next item in current part: %s", _item);
        GlobalPosition pos0 = this.getViewManager() == null ? null : this.getViewManager().getCurrentGlobalPosition();
        ITextDocumentPart part = this.iviewer.getCurrentDocumentPart();
        long anchorId = TextPartUtil.getFirstAnchorId(part);
        if (anchorId < 0L) {
            return false;
        }
        ICoordinates _coord = this.iviewer.getCaretCoordinates();
        int _line = TextPartUtil.coordinatesToLineIndex(part, _coord);
        int _column = _coord.getColumnOffset();
        List<? extends ILine> lines = part.getLines();
        for (int lineIndex = _line; lineIndex < lines.size(); ++lineIndex) {
            ILine line = lines.get(lineIndex);
            for (ITextItem iTextItem : line.getItems()) {
                if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != _id || lineIndex == _line && iTextItem.getOffset() <= _column) continue;
                if (pos0 != null) {
                    this.getViewManager().recordGlobalPosition(pos0);
                }
                Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                return this.iviewer.setCaretCoordinates(coord, null, true);
            }
        }
        logger.debug("Next item in current part was not found", new Object[0]);
        return false;
    }

    private boolean previousItem(IActionableItem _item) {
        if (_item == null || _item.getItemId() == 0L) {
            return false;
        }
        long _id = _item.getItemId();
        logger.trace("Searching for previous item in current part: %s", _item);
        GlobalPosition pos0 = this.getViewManager() == null ? null : this.getViewManager().getCurrentGlobalPosition();
        ITextDocumentPart part = this.iviewer.getCurrentDocumentPart();
        long anchorId = TextPartUtil.getFirstAnchorId(part);
        if (anchorId < 0L) {
            return false;
        }
        ICoordinates _coord = this.iviewer.getCaretCoordinates();
        int _line = TextPartUtil.coordinatesToLineIndex(part, _coord);
        int _column = _coord.getColumnOffset();
        List<? extends ILine> lines = part.getLines();
        for (int lineIndex = _line; lineIndex >= 0; --lineIndex) {
            ILine line = lines.get(lineIndex);
            for (ITextItem iTextItem : line.getItems()) {
                if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != _id || lineIndex == _line && iTextItem.getOffset() + iTextItem.getLength() > _column) continue;
                if (pos0 != null) {
                    this.getViewManager().recordGlobalPosition(pos0);
                }
                Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                return this.iviewer.setCaretCoordinates(coord, null, true);
            }
        }
        logger.debug("Previous item in current part was not found", new Object[0]);
        return false;
    }

    public List<ICoordinates> collectItemCoordinates(long itemId) {
        ArrayList<ICoordinates> r = new ArrayList<ICoordinates>();
        long anchorId = TextPartUtil.getFirstAnchorId(this.iviewer.getCurrentDocumentPart());
        if (anchorId >= 0L) {
            int lineIndex = 0;
            for (ILine iLine : this.iviewer.getCurrentDocumentPart().getLines()) {
                for (ITextItem iTextItem : iLine.getItems()) {
                    if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != itemId) continue;
                    Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                    r.add(coord);
                }
                ++lineIndex;
            }
        }
        return r;
    }

    public void setCaretCoordinates(ICoordinates coord) {
        this.iviewer.setCaretCoordinates(coord, null, true);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.iviewer.getTextWidget().setMenu(menu);
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.exportAsText(false));
    }

    @Override
    public String exportAsText(boolean formatAsHtml) {
        if (formatAsHtml) {
            HtmlTextDocumentFormatter formatter = new HtmlTextDocumentFormatter(this.context.getStyleManager(), this.unit.getName(), true);
            return formatter.generate(this.idoc);
        }
        ITextDocumentPart wholePart = this.idoc.getDocumentPart(this.idoc.getFirstAnchor(), Integer.MAX_VALUE);
        return TextPartUtil.buildRawTextFromPart(wholePart);
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TEXT;
    }
}

