/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.AsciiDocument;
import com.pnfsoftware.jeb.core.output.text.impl.StaticTextDocument;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.tab.TabFolderView;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.ISwitchableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.SwitchableBinaryDataFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SwitchableTextFragment
extends TextFragment
implements ISwitchableFragment {
    private static final ILogger logger = GlobalLog.getLogger(SwitchableTextFragment.class);
    static final String[] actions = new String[]{"Switch to " + S.s(769), "Switch to %s"};
    private final String initialEncoding;
    private final String encoding;

    public SwitchableTextFragment(Composite parent, int style, IRcpClientContext context, IUnit unit, IRcpUnitView unitView, ITextDocument idoc, String encoding) {
        this(parent, style, context, unit, unitView, idoc, encoding, encoding);
    }

    SwitchableTextFragment(Composite parent, int style, IRcpClientContext context, IUnit unit, IRcpUnitView unitView, ITextDocument idoc, String encoding, String initialEncoding) {
        super(parent, style, context, unit, unitView, idoc);
        this.encoding = encoding;
        this.initialEncoding = initialEncoding == null ? "UTF-8" : initialEncoding;
    }

    static String getInitEncodingAction(String initialEncoding) {
        return Strings.f(actions[1], initialEncoding);
    }

    @Override
    public String[] getSwitchActions() {
        String[] stringArray;
        if (this.encoding == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = SwitchableBinaryDataFragment.actions[0];
            stringArray = stringArray2;
            stringArray2[1] = SwitchableTextFragment.getInitEncodingAction(this.initialEncoding);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = SwitchableBinaryDataFragment.actions[0];
            stringArray = stringArray3;
            stringArray3[1] = actions[0];
        }
        return stringArray;
    }

    @Override
    public void switchTo(String currentName, String action, TabFolderView tabman, IRcpUnitView unintView) {
        if (action.equals(SwitchableBinaryDataFragment.actions[0])) {
            SwitchableBinaryDataFragment.switchToBinaryFragment((IBinaryUnit)this.unit, this.context, currentName, action, tabman, unintView, this.initialEncoding);
        } else if (action.equals(actions[0])) {
            SwitchableTextFragment.switchToTextFragment((IBinaryUnit)this.unit, this.context, currentName, action, tabman, unintView, null, this.initialEncoding);
        } else if (action.equals(SwitchableTextFragment.getInitEncodingAction(this.initialEncoding))) {
            SwitchableTextFragment.switchToTextFragment((IBinaryUnit)this.unit, this.context, currentName, action, tabman, unintView, this.initialEncoding, this.initialEncoding);
        }
    }

    static void switchToTextFragment(IBinaryUnit unit, IRcpClientContext context, String currentName, String action, TabFolderView tabman, IRcpUnitView unintView, String encoding, String initialEncoding) {
        IInput input = unit.getInput();
        ITextDocument newDoc = SwitchableTextFragment.buildDocument(input, encoding);
        if (newDoc == null) {
            return;
        }
        CTabFolder folder = tabman.getContainer();
        SwitchableTextFragment textdump = new SwitchableTextFragment((Composite)folder, 0, context, unit, unintView, newDoc, encoding, initialEncoding);
        tabman.replaceEntry(currentName, S.s(769), (Control)textdump, true);
    }

    public static ITextDocument buildDocument(IInput input, String encoding) {
        String text;
        if (encoding == null) {
            return new AsciiDocument(input);
        }
        try (InputStream is = input.getStream();){
            byte[] b = IO.readInputStream(is);
            text = new String(b, 0, b.length, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Invalid " + encoding + " data", new Object[0]);
            return null;
        }
        catch (IOException iOException) {
            logger.error("Can not read input stream", new Object[0]);
            return null;
        }
        return new StaticTextDocument(text);
    }

    public static String determineInitialEncoding(IInput input) {
        ByteBuffer buffer = input.getHeader();
        byte[] headerBytes = new byte[buffer.remaining() < 4 ? buffer.remaining() : 4];
        buffer.get(headerBytes);
        String encoding = Strings.readBOM(headerBytes);
        if (encoding == null) {
            buffer.rewind();
            headerBytes = new byte[buffer.remaining()];
            buffer.get(headerBytes);
            if (Strings.isPrintableUTF8Header(headerBytes)) {
                encoding = "UTF-8";
            }
        }
        return encoding;
    }
}

