/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.text.impl.HexDumpDocument;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.tab.TabFolderView;
import com.pnfsoftware.jeb.rcpclient.parts.units.BinaryDataFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.ISwitchableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.SwitchableTextFragment;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SwitchableBinaryDataFragment
extends BinaryDataFragment
implements ISwitchableFragment {
    static final String[] actions = new String[]{"Switch to " + S.s(366)};
    private String initialEncoding;

    public SwitchableBinaryDataFragment(Composite parent, int flags, IRcpClientContext context, IUnit unit, IRcpUnitView unintView, HexDumpDocument idoc) {
        this(parent, flags, context, unit, unintView, idoc, null);
    }

    SwitchableBinaryDataFragment(Composite parent, int flags, IRcpClientContext context, IUnit unit, IRcpUnitView unintView, HexDumpDocument idoc, String initialEncoding) {
        super(parent, flags, context, unit, unintView, idoc);
        this.initialEncoding = initialEncoding;
    }

    private String getInitialEncoding() {
        if (this.initialEncoding == null) {
            this.initialEncoding = SwitchableTextFragment.determineInitialEncoding(((IBinaryUnit)this.unit).getInput());
            if (this.initialEncoding == null) {
                this.initialEncoding = "UTF-8";
            }
        }
        return this.initialEncoding;
    }

    @Override
    public String[] getSwitchActions() {
        return new String[]{SwitchableTextFragment.actions[0], SwitchableTextFragment.getInitEncodingAction(this.getInitialEncoding())};
    }

    @Override
    public void switchTo(String currentName, String action, TabFolderView tabman, IRcpUnitView unintView) {
        if (action.equals(SwitchableTextFragment.actions[0])) {
            SwitchableTextFragment.switchToTextFragment((IBinaryUnit)this.unit, this.context, currentName, action, tabman, unintView, null, this.getInitialEncoding());
        } else if (action.equals(SwitchableTextFragment.getInitEncodingAction(this.initialEncoding))) {
            SwitchableTextFragment.switchToTextFragment((IBinaryUnit)this.unit, this.context, currentName, action, tabman, unintView, this.getInitialEncoding(), this.getInitialEncoding());
        }
    }

    static void switchToBinaryFragment(IBinaryUnit unit, IRcpClientContext context, String currentName, String action, TabFolderView tabman, IRcpUnitView unintView, String initialEncoding) {
        IInput input = unit.getInput();
        HexDumpDocument newDoc = new HexDumpDocument(input, unit);
        CTabFolder folder = tabman.getContainer();
        SwitchableBinaryDataFragment hexdump = new SwitchableBinaryDataFragment((Composite)folder, 0, context, unit, unintView, newDoc, initialEncoding);
        tabman.replaceEntry(currentName, S.s(366), (Control)hexdump, true);
        hexdump.setFocusPriority(0);
    }
}

