/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.IVisualItem;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IActionableTextItem;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.rcpclient.iviewers.IStyleProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.StyleManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.IItemListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.IPositionListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ItemEvent;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;

public class ItemStyleProvider
implements IStyleProvider {
    private static final ILogger logger = GlobalLog.getLogger(ItemStyleProvider.class);
    private StyleManager styleman;
    private IItem activeItem;
    private Set<IActionableItem> relatedItems = new HashSet<IActionableItem>();

    public ItemStyleProvider(StyleManager styleman) {
        this.styleman = styleman;
    }

    @Override
    public Style getStyle(ItemClassIdentifiers classId, boolean active) {
        return this.styleman.getStyle(classId, active);
    }

    @Override
    public Style getStyle(IItem item) {
        if (!(item instanceof IVisualItem)) {
            return null;
        }
        ItemClassIdentifiers classId = ((IVisualItem)((Object)item)).getClassId();
        return this.getStyle(classId, this.isActiveItem(item));
    }

    @Override
    public Color getOnCaretBackgroundColor() {
        return this.styleman.getOnCaretBackground();
    }

    public void registerTextViewer(final ITextDocumentViewer iviewer) {
        iviewer.addItemListener(new IItemListener(){

            @Override
            public void notifyItemEvent(ITextDocumentViewer viewer, ItemEvent e) {
                if (e.type == 1) {
                    logger.trace("On-caret Item: %s", e.item);
                    ItemStyleProvider.this.activeItem = e.item;
                    if (ItemStyleProvider.this.activeItem instanceof IActionableTextItem) {
                        Set<IActionableItem> similarItems = ItemStyleProvider.this.findSimilarActionableItems(iviewer, (IActionableTextItem)ItemStyleProvider.this.activeItem);
                        ItemStyleProvider.this.relatedItems.addAll(similarItems);
                    }
                } else if (e.type == 0) {
                    ItemStyleProvider.this.activeItem = null;
                    ItemStyleProvider.this.relatedItems.clear();
                }
                iviewer.refreshStyles();
            }
        });
        iviewer.addPositionListener(new IPositionListener(){

            @Override
            public void positionUnchangedAttemptBreakout(ITextDocumentViewer viewer, int direction) {
            }

            @Override
            public void positionChanged(ITextDocumentViewer viewer, ICoordinates coordinates, int focusChange) {
                if (focusChange < 0) {
                    return;
                }
                viewer.activateCurrentLine(true);
            }
        });
    }

    private Set<IActionableItem> findSimilarActionableItems(ITextDocumentViewer iviewer, IActionableItem target) {
        HashSet<IActionableItem> r = new HashSet<IActionableItem>();
        long targetId = target.getItemId();
        if (targetId != 0L) {
            for (ILine iLine : iviewer.getCurrentDocumentPart().getLines()) {
                for (IItem iItem : iLine.getItems()) {
                    if (!(iItem instanceof IActionableItem) || ((IActionableItem)((Object)iItem)).getItemId() != targetId) continue;
                    r.add((IActionableItem)((Object)iItem));
                }
            }
        }
        return r;
    }

    public boolean isActiveItem(IItem item) {
        return this.activeItem == item || this.relatedItems.contains(item);
    }

    public IItem getActiveItem() {
        return this.activeItem;
    }
}

