/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.IImageSource;
import com.pnfsoftware.jeb.rcpclient.extensions.ImageViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.StaticImageDocument;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.WebImageViewer;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractNotAddressableUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ImageFragment
extends AbstractNotAddressableUnitFragment<IBinaryUnit> {
    private static final ILogger logger = GlobalLog.getLogger(ImageFragment.class);
    private ImageViewer viewer;

    public ImageFragment(Composite parent, int flags, IRcpClientContext context, IBinaryUnit unit) {
        super(parent, flags, unit, null, context);
        EventSource doc;
        this.setLayout((Layout)new FillLayout());
        if (unit.getMimeType().equals("image/webp")) {
            try {
                _doc = new WebImageViewer.WebpDocument(context, (IBinaryUnit)this.getUnit());
                this.addDisposeListener(arg_0 -> ImageFragment.lambda$new$0((WebImageViewer.WebpDocument)_doc, arg_0));
                doc = _doc;
            }
            catch (IOException e2) {
                logger.catching(e2);
                return;
            }
        } else {
            _doc = ImageFragment.buildStaticImageDocument(this.getDisplay(), unit);
            this.addDisposeListener(arg_0 -> ImageFragment.lambda$new$1((IImageSource)((Object)_doc), arg_0));
            doc = _doc;
        }
        this.viewer = new ImageViewer(this);
        IContextMenu contextMenu = menuMgr -> {
            menuMgr.add(new SquareBgHandler("Chess Background"));
            menuMgr.add(new ResetBgHandler("Transparent Background"));
            menuMgr.add(new BgHandler("Red Background", new RGB(255, 0, 0), 200));
            menuMgr.add(new BgHandler("Green Background", new RGB(0, 255, 0), 200));
            menuMgr.add(new BgHandler("Blue Background", new RGB(0, 0, 255), 200));
        };
        this.viewer.addWidgetChangeListener(e -> {
            new ContextMenu((Control)this.viewer.getControl()).addContextMenu(contextMenu);
            this.setPrimaryWidget((Control)this.viewer.getControl());
        });
        this.viewer.setInput(doc);
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    private static StaticImageDocument buildStaticImageDocument(Display display, IBinaryUnit unit) {
        Image image;
        try (InputStream stream = unit.getInput().getStream();){
            image = new Image((Device)display, stream);
        }
        catch (Exception e) {
            logger.error("Cannot render image for unit %s, using a dummy 1x1 pixel image instead: %s", unit, e);
            image = new Image((Device)display, new Rectangle(0, 0, 1, 1));
        }
        UIUtil.dbgImageResTrack(image);
        return new StaticImageDocument(image);
    }

    @Override
    public byte[] export() {
        byte[] byArray;
        block8: {
            IInput input = ((IBinaryUnit)this.getUnit()).getInput();
            InputStream in = input.getStream();
            try {
                byte[] data;
                byArray = data = IO.readInputStream(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.catching(e);
                    return null;
                }
            }
            in.close();
        }
        return byArray;
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.IMAGE;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        return null;
    }

    private static /* synthetic */ void lambda$new$1(IImageSource _doc, DisposeEvent l) {
        _doc.dispose();
    }

    private static /* synthetic */ void lambda$new$0(WebImageViewer.WebpDocument _doc, DisposeEvent l) {
    }

    private class SquareBgHandler
    extends AbstractBgHandler {
        public SquareBgHandler(String text) {
            super(text);
        }

        @Override
        public void updateDoc(StaticImageDocument doc) {
            doc.setBackgroundDefaultChessboard();
        }
    }

    private class ResetBgHandler
    extends AbstractBgHandler {
        public ResetBgHandler(String text) {
            super(text);
        }

        @Override
        public void updateDoc(StaticImageDocument doc) {
            doc.setBackgroundColor(null, 0);
        }
    }

    private class BgHandler
    extends AbstractBgHandler {
        private RGB rgb;
        private int alpha;

        public BgHandler(String text, RGB rgb, int alpha) {
            super(text);
            this.rgb = null;
            this.alpha = 255;
            this.rgb = rgb;
            this.alpha = alpha;
        }

        @Override
        public void updateDoc(StaticImageDocument doc) {
            doc.setBackgroundColor(this.rgb, this.alpha);
        }
    }

    private abstract class AbstractBgHandler
    extends Action {
        public AbstractBgHandler(String text) {
            super(text);
        }

        @Override
        public boolean isEnabled() {
            return ImageFragment.this.viewer.getInput() instanceof StaticImageDocument && ((StaticImageDocument)ImageFragment.this.viewer.getInput()).isTransparent();
        }

        @Override
        public void run() {
            StaticImageDocument doc = (StaticImageDocument)ImageFragment.this.viewer.getInput();
            this.updateDoc(doc);
            ImageFragment.this.viewer.refresh();
        }

        protected abstract void updateDoc(StaticImageDocument var1);
    }
}

