/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractStaticTextFragment;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DescriptionFragment
extends AbstractStaticTextFragment<IUnit>
implements IContextMenu {
    private ViewerRefresher refresher;
    private IEventListener unitListener;

    public DescriptionFragment(Composite parent, int flags, IRcpClientContext context, IUnit unit) {
        super(parent, flags, context, unit);
        this.setLayout((Layout)new FillLayout());
        final Document doc = new Document(this.getSafeDescription());
        TextViewer viewer = this.buildSimple(this, 768);
        this.refresher = new ViewerRefresher(parent.getDisplay(), viewer){

            @Override
            protected void performRefresh() {
                doc.set(DescriptionFragment.this.getSafeDescription());
            }
        };
        this.unitListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (J.isUnitEvent(e)) {
                    DescriptionFragment.this.refresher.request();
                }
            }
        };
        unit.addListener(this.unitListener);
        this.addDisposeListener(e -> unit.removeListener(this.unitListener));
        viewer.setDocument(doc);
        StyledText ctl = viewer.getTextWidget();
        context.getFontManager().registerWidget((Control)ctl);
        new ContextMenu((Control)viewer.getTextWidget()).addContextMenu(this);
    }

    private String getSafeDescription() {
        if (!this.unit.isProcessed()) {
            return "This unit is not processed!";
        }
        if (this.unit.isDisposed()) {
            return "This unit is disposed!";
        }
        return this.unit.getDescription();
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        this.addOperationsToContextMenu(menuMgr);
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case REFRESH: {
                return true;
            }
        }
        return super.verifyOperation(req);
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case REFRESH: {
                this.refresher.request();
                return true;
            }
        }
        return super.doOperation(req);
    }
}

