/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.input.InputHelper;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.HexDumpDocument;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.PrimitiveDisplayView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IDocumentBasedFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.ILocationListener;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BinaryDataFragment
extends AbstractUnitFragment<IUnit>
implements IDocumentBasedFragment {
    private static final ILogger logger = GlobalLog.getLogger(BinaryDataFragment.class);
    private TextFragment text;
    private PrimitiveDisplayView helper;
    private ILocationListener locationListener;

    public BinaryDataFragment(Composite parent, int flags, IRcpClientContext context, IUnit unit, IRcpUnitView unintView, final HexDumpDocument idoc) {
        super(parent, flags, unit, unintView, context);
        this.setLayout((Layout)new FillLayout());
        SashForm container = new SashForm((Composite)this, 256);
        this.text = new TextFragment((Composite)container, 0, context, unit, this.unitView, (ITextDocument)idoc);
        this.helper = new PrimitiveDisplayView((Composite)container, 0);
        container.setWeights(new int[]{65, 35});
        this.locationListener = new ILocationListener(){

            @Override
            public void locationChanged(String address) {
                if (address == null || address.isEmpty() || address.charAt(0) != '@') {
                    BinaryDataFragment.this.helper.setBytes(null);
                    return;
                }
                long offset = Conversion.stringToLong(address.substring(1), -1L);
                if (offset < 0L) {
                    BinaryDataFragment.this.helper.setBytes(null);
                    return;
                }
                byte[] data = new byte[32];
                try {
                    int len = InputHelper.readBytes(idoc.getInput(), offset, data, 0, data.length);
                    BinaryDataFragment.this.helper.setBytes(data, 0, len);
                }
                catch (IOException iOException) {}
            }
        };
        this.text.addLocationListener(this.locationListener);
        this.addDisposeListener(e -> this.text.removeLocationListener(this.locationListener));
    }

    @Override
    public ITextDocument getDocument() {
        return this.text.getDocument();
    }

    public TextFragment getInteractiveText() {
        return this.text;
    }

    public PrimitiveDisplayView getHelper() {
        return this.helper;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        return this.text.verifyOperation(req);
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        return this.text.doOperation(req);
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return this.text.isActiveItem(item);
    }

    @Override
    public IItem getActiveItem() {
        return this.text.getActiveItem();
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        return this.text.getActiveAddress();
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        return this.text.isValidActiveAddress(address, object);
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record, boolean allowComplexNavigation) {
        return this.text.setActiveAddress(address, extra, record, allowComplexNavigation);
    }

    @Override
    public byte[] export() {
        return this.text.export();
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return this.text.getFragmentType();
    }

    @Override
    public String getExportExtension() {
        return this.text.getExportExtension();
    }
}

