/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.output.text.IBinaryRepresentation;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FindTextOptions;
import com.pnfsoftware.jeb.rcpclient.extensions.search.IFinder;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextFindResult;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Charsets;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.charset.Charset;
import java.text.ParseException;

public class BinaryCodeFinder
implements IFinder<InteractiveTextFindResult> {
    private static final ILogger logger = GlobalLog.getLogger(BinaryCodeFinder.class);
    private ITextDocumentViewer viewer;
    private FindTextOptions lastFindOptions;
    private ICoordinates lastCoord;
    private Long lastSuccessAddress;
    private ICoordinates lastSuccessSetActualCoord;

    public BinaryCodeFinder(ITextDocumentViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public boolean supportCaseInsensitive() {
        return false;
    }

    @Override
    public boolean supportRegex() {
        return false;
    }

    @Override
    public boolean supportReverseSearch() {
        return true;
    }

    @Override
    public boolean supportWrapAround() {
        return false;
    }

    @Override
    public void resetFindTextOptions() {
        this.lastFindOptions = null;
        this.lastCoord = null;
    }

    @Override
    public void setFindTextOptions(FindTextOptions options) {
        this.lastFindOptions = options;
    }

    @Override
    public FindTextOptions getFindTextOptions(boolean update) {
        if (this.lastFindOptions == null) {
            this.lastFindOptions = new FindTextOptions();
        }
        if (update) {
            this.lastCoord = this.viewer.getCaretCoordinates();
        }
        return this.lastFindOptions;
    }

    @Override
    public InteractiveTextFindResult findText(FindTextOptions options) {
        byte[] mask;
        byte[] bin;
        long a;
        IBinaryRepresentation bindoc = this.viewer.getDocument().getBinaryRepresentation();
        if (bindoc == null) {
            return InteractiveTextFindResult.EOS;
        }
        if (options == null) {
            options = this.lastFindOptions;
            if (options == null) {
                return InteractiveTextFindResult.EOS;
            }
            Object[] cfr_ignored_0 = new Object[0];
        }
        boolean reverse = options.isReverseSearch();
        ICoordinates coord = this.lastCoord;
        if (coord == null) {
            return InteractiveTextFindResult.EOS;
        }
        if (this.lastSuccessSetActualCoord != null && this.lastSuccessSetActualCoord.equals(coord)) {
            a = this.lastSuccessAddress;
            a += reverse ? -1L : 1L;
        } else {
            a = bindoc.convertCoordinatesToOffset(coord);
            if (a == -1L) {
                return InteractiveTextFindResult.EOS;
            }
        }
        Object[] objectArray = new Object[]{options.getSearchString(), a};
        Couple<byte[], byte[]> r = this.parseBinstring(options.getSearchString());
        if (r == null) {
            return InteractiveTextFindResult.EOS;
        }
        long last = reverse ? 0L : -1L;
        long a1 = bindoc.find(a, last, bin = r.getFirst(), mask = r.getSecond());
        if (a1 == -1L) {
            return InteractiveTextFindResult.EOS;
        }
        (new Object[1])[0] = a1;
        ICoordinates coord1 = bindoc.convertOffsetToCoordinates(a1);
        if (coord1 == null) {
            return InteractiveTextFindResult.EOS;
        }
        this.lastSuccessAddress = a1;
        return new InteractiveTextFindResult(coord1, coord1, false, reverse);
    }

    @Override
    public void processFindResult(InteractiveTextFindResult r) {
        if (!r.isEndOfSearch() && this.viewer.setCaretCoordinates(r.getBegin(), null, false)) {
            this.lastSuccessSetActualCoord = this.viewer.getCaretCoordinates();
        }
    }

    @Override
    public void clearFindResult() {
    }

    private Couple<byte[], byte[]> parseBinstring(String str0) {
        byte[] bin = null;
        byte[] mask = null;
        int pos = str0.lastIndexOf(47);
        if (pos >= 0) {
            String charsetName = str0.substring(pos + 1);
            String str = str0.substring(0, pos);
            Charset charset = Strings.isBlank(charsetName) ? Charset.defaultCharset() : Charsets.findCharset(charsetName);
            if (charset == null) {
                return null;
            }
            bin = str.getBytes(charset);
            return new Couple<byte[], Object>(bin, mask);
        }
        String str = str0.trim().replaceAll("\\s", "").toUpperCase();
        if (str.indexOf(46) >= 0 || str.indexOf(63) >= 0) {
            StringBuilder strbin = new StringBuilder();
            StringBuilder strmask = new StringBuilder();
            boolean good = true;
            for (char c : str.toCharArray()) {
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                    strbin.append(c);
                    strmask.append('F');
                    continue;
                }
                if (c == '.' || c == '?') {
                    strbin.append('0');
                    strmask.append('0');
                    continue;
                }
                good = false;
                break;
            }
            if (good) {
                bin = Formatter.hexStringToByteArray(strbin.toString());
                mask = Formatter.hexStringToByteArray(strmask.toString());
            }
        } else {
            bin = Formatter.hexStringToByteArray(str.toString());
            mask = null;
        }
        if (bin == null) {
            try {
                bin = Strings.encodeBinary(Formatter.unescapeString(str));
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return new Couple<byte[], Object>(bin, mask);
    }
}

