/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.IStatusIndicator;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.StatusIndicatorData;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.IViewNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.Position;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.function.Predicate;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractUnitFragment<T extends IUnit>
extends Composite
implements IRcpUnitFragment {
    private static final ILogger logger = GlobalLog.getLogger(AbstractUnitFragment.class);
    protected T unit;
    protected IRcpClientContext context;
    protected IRcpUnitView unitView;
    protected IViewNavigator viewNavigatorHelper;
    protected IOperable master;
    private Control primaryWidget;
    private FocusListener focusListener;
    private StatusIndicatorData statusData;
    private boolean defaultFragment;
    private int priority = 5;

    public AbstractUnitFragment(Composite parent, int style, T unit, IRcpUnitView unitView, IRcpClientContext context) {
        super(parent, style);
        this.unit = unit;
        this.unitView = unitView;
        this.context = context;
    }

    protected Control getPrimaryWidget() {
        return this.primaryWidget;
    }

    protected void setPrimaryWidget(Control widget) {
        if (this.primaryWidget != null) {
            if (this.focusListener != null && !this.primaryWidget.isDisposed()) {
                this.primaryWidget.removeFocusListener(this.focusListener);
                this.focusListener = null;
            }
            this.primaryWidget = null;
        }
        if (widget == null) {
            return;
        }
        this.primaryWidget = widget;
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                AbstractUnitFragment.this.onFocusLost(e);
            }

            public void focusGained(FocusEvent e) {
                AbstractUnitFragment.this.onFocusGained(e);
            }
        };
        this.primaryWidget.addFocusListener(this.focusListener);
        this.primaryWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Operation op = null;
                if (e.button == 4) {
                    op = Operation.NAVIGATE_BACKWARD;
                } else if (e.button == 5) {
                    op = Operation.NAVIGATE_FORWARD;
                }
                if (op != null) {
                    OperationRequest req = new OperationRequest(op);
                    if (AbstractUnitFragment.this.unitView != null) {
                        if (AbstractUnitFragment.this.unitView.verifyOperation(req)) {
                            AbstractUnitFragment.this.unitView.doOperation(req);
                        }
                    } else if (AbstractUnitFragment.this.verifyOperation(req)) {
                        AbstractUnitFragment.this.doOperation(req);
                    }
                }
            }
        });
        this.addDisposeListener(e -> {
            if (this.focusListener != null) {
                this.primaryWidget.removeFocusListener(this.focusListener);
            }
        });
    }

    protected void onFocusLost(FocusEvent e) {
        if (this.getStatusIndicator() != null) {
            this.statusData = this.getStatusIndicator().save();
            this.getStatusIndicator().clear();
        }
    }

    protected void onFocusGained(FocusEvent e) {
        if (this.getStatusIndicator() != null && this.statusData != null) {
            this.getStatusIndicator().restore(this.statusData);
        }
    }

    public IRcpClientContext getContext() {
        return this.context;
    }

    @Override
    public Control getFragmentControl() {
        return this;
    }

    @Override
    public IStatusIndicator getStatusIndicator() {
        return this.context == null ? null : this.context.getStatusIndicator();
    }

    public void setStatusIndicator(String text) {
        if (this.getStatusIndicator() != null) {
            this.context.getStatusIndicator().setText(text);
            this.updateUnfocusStatusIndicator();
        }
    }

    private void updateUnfocusStatusIndicator() {
        if (this.getStatusIndicator() != null) {
            this.statusData = this.getStatusIndicator().save();
        }
    }

    @Override
    public IViewManager getViewManager() {
        return this.context == null ? null : this.context.getPartManager();
    }

    @Override
    public void setViewNavigatorHelper(IViewNavigator viewNavigatorHelper) {
        this.viewNavigatorHelper = viewNavigatorHelper;
    }

    @Override
    public IViewNavigator getViewNavigatorHelper() {
        return this.viewNavigatorHelper;
    }

    public T getUnit() {
        return this.unit;
    }

    public IRcpUnitView getUnitView() {
        return this.unitView;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        return false;
    }

    protected void addOperationsToContextMenu(IMenuManager menuMgr) {
        menuMgr.add(new Separator());
        for (final Operation op : Operation.values()) {
            OperationRequest req = new OperationRequest(op);
            if (!this.verifyOperation(req)) continue;
            menuMgr.add(new Action(op.toString()){

                @Override
                public void run() {
                    AbstractUnitFragment.this.doOperation(new OperationRequest(op));
                }
            });
        }
    }

    public boolean isFocusControl() {
        if (this.primaryWidget == null || this.primaryWidget.isDisposed()) {
            return super.isFocusControl();
        }
        return this.primaryWidget.isFocusControl();
    }

    public boolean forceFocus() {
        if (this.primaryWidget == null || this.primaryWidget.isDisposed()) {
            return super.forceFocus();
        }
        return this.primaryWidget.forceFocus();
    }

    public boolean setFocus() {
        if (this.primaryWidget == null || this.primaryWidget.isDisposed()) {
            return super.setFocus();
        }
        return this.primaryWidget.setFocus();
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return false;
    }

    @Override
    public IItem getActiveItem() {
        return null;
    }

    @Override
    public String getActiveItemAsText() {
        return null;
    }

    @Override
    public String getActiveAddress() {
        return this.getActiveAddress(AddressConversionPrecision.DEFAULT);
    }

    @Override
    public Position getActivePosition() {
        return new Position(this.getActiveAddress(), null);
    }

    @Override
    public final boolean setActiveAddress(String address) {
        return this.setActiveAddress(address, null, true, true);
    }

    @Override
    public Object getExtraAddressDetails(String address) {
        return null;
    }

    @Override
    public String getComment() {
        return null;
    }

    public void setDefaultFragment(boolean defaultFragment) {
        this.defaultFragment = defaultFragment;
    }

    @Override
    public boolean isDefaultFragment() {
        return this.defaultFragment;
    }

    public boolean navigateTo(String address) {
        return this.navigateTo(address, null);
    }

    public boolean navigateTo(String address, IUnit unitOverride) {
        if (address != null) {
            (new Object[1])[0] = address;
            return new AddressNavigator(this.context, unitOverride != null ? unitOverride : this.unit, this).navigate(address);
        }
        return false;
    }

    public byte[] export() {
        return null;
    }

    public String exportAsText(boolean formatAsHtml) {
        byte[] data = this.export();
        if (data == null) {
            return null;
        }
        return Strings.decodeLocal(data);
    }

    public String getExportExtension() {
        switch (this.getFragmentType()) {
            case TEXT: {
                return ".txt";
            }
            case TABLE: {
                return ".csv";
            }
            case TREE: {
                return ".xml";
            }
            case IMAGE: {
                return ".bmp";
            }
            case BINARY: {
                return ".bin";
            }
        }
        return null;
    }

    public FragmentType getFragmentType() {
        return FragmentType.UNKNOWN;
    }

    public void setFocusPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getFocusPriority() {
        return this.priority;
    }

    protected boolean requestOperation(OperationRequest req) {
        if (this.unitView != null) {
            if (this.unitView.verifyOperation(req)) {
                return this.unitView.doOperation(req);
            }
            return false;
        }
        if (this.master != null && this.master != this) {
            if (this.master.verifyOperation(req)) {
                return this.master.doOperation(req);
            }
            return false;
        }
        if (this.verifyOperation(req)) {
            return this.doOperation(req);
        }
        return false;
    }

    protected ViewerRefresher setRefreshListener(Viewer viewer, Predicate<IEvent> predicate) {
        return this.setRefreshListener(viewer, predicate, null, null);
    }

    protected ViewerRefresher setRefreshListener(Viewer viewer, Predicate<IEvent> predicate, Runnable runBefore) {
        return this.setRefreshListener(viewer, predicate, runBefore, null);
    }

    protected ViewerRefresher setRefreshListener(Viewer viewer, final Predicate<IEvent> predicate, final Runnable runBefore, final Runnable runAfter) {
        Control ctl = viewer.getControl();
        final ViewerRefresher refresher = new ViewerRefresher(ctl.getDisplay(), viewer){

            @Override
            protected void performRefresh() {
                if (runBefore != null) {
                    runBefore.run();
                }
                super.performRefresh();
                if (runAfter != null) {
                    runAfter.run();
                }
            }
        };
        IEventListener refreshListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (predicate.test(e)) {
                    refresher.request();
                }
            }
        };
        this.unit.addListener(refreshListener);
        ctl.addDisposeListener(e -> this.unit.removeListener(refreshListener));
        return refresher;
    }

    public static enum FragmentType {
        TEXT,
        TABLE,
        TREE,
        IMAGE,
        BINARY,
        UNKNOWN;

    }
}

