/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.api.IUnitTextFragment;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.IVisualTextItem;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.render.INativeDisassemblyDocument;
import com.pnfsoftware.jeb.core.units.code.java.IJavaSourceUnit;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JumpToDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ReferencesDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.TextFragmentRenderingOptionsHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditCopyHandler;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.wrapped.WrappedLine;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IDocumentBasedFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.util.asm.NativeTokenExtractor;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TokenExtractor;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractTextFragment
extends AbstractUnitFragment<IUnit>
implements IUnitTextFragment,
IDocumentBasedFragment {
    private static final ILogger logger = GlobalLog.getLogger(AbstractTextFragment.class);
    protected ITextDocument idoc;
    protected ITextDocumentViewer iviewer;

    public AbstractTextFragment(Composite parent, int style, IUnit unit, IRcpUnitView unitView, IRcpClientContext context, ITextDocument idoc) {
        super(parent, style, unit, unitView, context);
        this.idoc = idoc;
    }

    @Override
    public ITextDocument getDocument() {
        return this.idoc;
    }

    public ITextDocumentViewer getViewer() {
        return this.iviewer;
    }

    protected void addStandardContextMenu(final int ... additionalGroups) {
        new ContextMenu((Control)this).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                if (AbstractTextFragment.this.getContext() == null) {
                    return;
                }
                AllHandlers.getInstance().fillManager(menuMgr, 32);
                if (AbstractTextFragment.this.unit instanceof IDexUnit) {
                    AllHandlers.getInstance().fillManager(menuMgr, 256);
                } else if (AbstractTextFragment.this.unit instanceof IJavaSourceUnit) {
                    AllHandlers.getInstance().fillManager(menuMgr, 512);
                } else if (AbstractTextFragment.this.unit instanceof INativeCodeUnit) {
                    AllHandlers.getInstance().fillManager(menuMgr, 64);
                } else if (AbstractTextFragment.this.unit instanceof INativeSourceUnit) {
                    AllHandlers.getInstance().fillManager(menuMgr, 64);
                }
                for (int grp : additionalGroups) {
                    AllHandlers.getInstance().fillManager(menuMgr, grp);
                }
                menuMgr.add(new Separator());
                menuMgr.add(new EditCopyHandler());
                menuMgr.add(new Separator());
                menuMgr.add(new TextFragmentRenderingOptionsHandler());
            }
        });
    }

    private List<TokenExtractor> geTokenList() {
        if (this.idoc instanceof INativeDisassemblyDocument) {
            return NativeTokenExtractor.getTokenList();
        }
        return TokenExtractor.getGenericTokenList();
    }

    protected void highlightPotentialAddress() {
        IItem item = this.getActiveItem();
        if (!(item instanceof IVisualTextItem)) {
            return;
        }
        Style s = this.iviewer.getStyleAdapter().getStyle(item);
        if (s == null || s.getBackgroungColor() != null) {
            return;
        }
        Color fg = s.getColor();
        int fontsize = 0 | (s.isBold() ? 1 : 0) | (s.isItalic() ? 2 : 0);
        WrappedLine line = this.iviewer.getCurrentLine();
        if (item instanceof IVisualTextItem) {
            StyleRange[] styles;
            int start = line.getOffsetAtLine() + ((IVisualTextItem)item).getOffset();
            int length = ((IVisualTextItem)item).getLength();
            for (StyleRange sr : styles = this.iviewer.getTextWidget().getStyleRanges(start, length)) {
                if (sr.background == null) continue;
                this.iviewer.getTextWidget().setStyleRanges(sr.start, sr.length, new int[]{sr.start, sr.length}, new StyleRange[]{new StyleRange(sr.start, sr.length, sr.foreground, null, sr.fontStyle)});
            }
        }
        List<TokenExtractor> tes = this.geTokenList();
        for (TokenExtractor te : tes) {
            String token;
            int[] tokenC = te.extractCoordinates(line.getLine(), line.getRelativeOffset());
            if (tokenC == null || !this.isValidActiveAddress(token = line.getLine().substring(tokenC[0], tokenC[1]), null)) continue;
            int start = line.getOffsetAtLine() + tokenC[0];
            int length = tokenC[1] - tokenC[0];
            Color defaultBg = this.iviewer.getStyleAdapter().getStyle(ItemClassIdentifiers.DEFAULT, true).getBackgroungColor();
            StyleRange sr = new StyleRange(start, length, fg, defaultBg, fontsize);
            this.iviewer.getTextWidget().setStyleRange(sr);
            return;
        }
    }

    protected boolean doJumpTo() {
        String address;
        if (this.context == null) {
            return false;
        }
        JumpToDialog dlg = new JumpToDialog(this.getShell(), RcpClientContext.getStandardAddressHistory(this.context), (IUnit)this.getUnit(), this.getDocument(), this.context.getPropertyManager());
        String selection = this.getSelectedText();
        if (selection != null) {
            if (selection.length() > 20) {
                selection = selection.substring(0, 20);
            }
            dlg.setInitialValue(selection);
        }
        if ((address = dlg.open()) == null) {
            return false;
        }
        return this.setActiveAddress(address);
    }

    protected boolean doItemFollow() {
        IItem item = this.getActiveItem();
        if (item instanceof IActionableItem && this.followItem((IActionableItem)((Object)item))) {
            return true;
        }
        if (this.iviewer.isDisposed()) {
            RuntimeException ex = new RuntimeException("failed follow due to disposed widget");
            RcpClientContext.getInstance().getErrorHandler().processThrowableSilent(ex);
            return false;
        }
        WrappedLine line = this.iviewer.getCurrentLine();
        List<TokenExtractor> tes = this.geTokenList();
        for (TokenExtractor te : tes) {
            String token = te.extract(line.getLine(), line.getRelativeOffset());
            if (token == null || !this.setActiveAddress(token, null, true, true)) continue;
            return true;
        }
        return false;
    }

    protected boolean followItem(IActionableItem targetItem) {
        String address;
        ITextDocumentPart part;
        ICoordinates coord;
        List<Long> relatedItemIds;
        if (targetItem == null || targetItem.getItemId() == 0L) {
            return false;
        }
        long targetItemId = targetItem.getItemId();
        logger.trace("Following item: %s", targetItem);
        IAddressableUnit aunit = null;
        if (this.getUnit() instanceof IAddressableUnit) {
            aunit = (IAddressableUnit)this.getUnit();
        }
        if (aunit != null && (targetItem.getItemFlags() & 2) != 0 && !(relatedItemIds = aunit.getRelatedItems(targetItemId)).isEmpty()) {
            ArrayList<Long> allItemIds = new ArrayList<Long>(1 + relatedItemIds.size());
            allItemIds.add(targetItemId);
            allItemIds.addAll(relatedItemIds);
            ArrayList<String> addresses = new ArrayList<String>(allItemIds.size());
            Iterator iterator = allItemIds.iterator();
            while (iterator.hasNext()) {
                long itemId = (Long)iterator.next();
                String addr = aunit.getAddressOfItem(itemId);
                addresses.add(Strings.safe(addr, "???"));
            }
            ReferencesDialog dlg = new ReferencesDialog(this.getShell(), "Candidates", addresses, null, this.unit);
            int index = dlg.open();
            if (index < 0) {
                return false;
            }
            targetItemId = (Long)allItemIds.get(index);
        }
        GlobalPosition pos0 = null;
        IViewManager viewManager = this.getViewManager();
        if (viewManager != null) {
            pos0 = viewManager.getCurrentGlobalPosition();
        }
        if ((coord = AbstractTextFragment.findRootItem(part = this.iviewer.getCurrentDocumentPart(), targetItemId)) != null) {
            if (pos0 != null) {
                viewManager.recordGlobalPosition(pos0);
            }
            return this.iviewer.setCaretCoordinates(coord, null, true);
        }
        logger.trace("No master item found in the current part, checking if the part is addressable", new Object[0]);
        if (aunit != null && (address = aunit.getAddressOfItem(targetItemId)) != null && !address.equals(this.getActiveAddress()) && this.setActiveAddress(address, null, true, true)) {
            logger.trace("Item to address conversion was successful, jumping to %s", address);
            return true;
        }
        if (this.viewNavigatorHelper != null && viewManager != null && this.viewNavigatorHelper.navigateTo(this, targetItem, viewManager, false)) {
            logger.trace("Jump was successful using the view navigator", new Object[0]);
            if (pos0 != null) {
                viewManager.recordGlobalPosition(pos0);
            }
            return true;
        }
        logger.debug("The jump failed!", new Object[0]);
        return false;
    }

    public static ICoordinates findRootItem(ITextDocumentPart part, long itemId) {
        long anchorId = TextPartUtil.getFirstAnchorId(part);
        if (anchorId >= 0L) {
            int lineIndex = 0;
            for (ILine iLine : part.getLines()) {
                for (ITextItem iTextItem : iLine.getItems()) {
                    int flags;
                    if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != itemId || ((flags = ((IActionableItem)((Object)iTextItem)).getItemFlags()) & 1) == 0) continue;
                    Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                    return coord;
                }
                ++lineIndex;
            }
        }
        return null;
    }

    @Override
    public String getSelectedText() {
        return this.iviewer.getSelectionText();
    }

    @Override
    public ICoordinates getCaretCoordinates() {
        return this.iviewer.getCaretCoordinates();
    }

    @Override
    public void setCaretCoordinates(ICoordinates coord, boolean record) {
        this.iviewer.setCaretCoordinates(coord, null, record);
    }

    @Override
    public List<Object> getDocumentObjectsAtCaret() {
        return this.iviewer.getDocumentObjectsAtCaret();
    }
}

