/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.export.ExportUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredStructuredViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractNotAddressableTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.util.regex.PatternFilter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractFilteredTableFragment<T extends IUnit, V>
extends AbstractNotAddressableTableFragment<T, V> {
    private static final ILogger logger = GlobalLog.getLogger(AbstractFilteredTableFragment.class);
    private FilteredTableView filteredView;
    private FilteredTableViewer filteredViewer;
    private List<ContextMenu> menus;
    private IFilteredTableContentProvider provider;
    private IFilteredLabelProvider labelProvider;

    public AbstractFilteredTableFragment(Composite parent, int style, T unit, IRcpUnitView unitView, IRcpClientContext context, IFilteredTableContentProvider provider, IFilteredLabelProvider labelProvider) {
        super(parent, style, unit, unitView, context);
        this.provider = provider;
        this.labelProvider = labelProvider;
    }

    public IFilteredTableContentProvider getProvider() {
        return this.provider;
    }

    protected void setLabelProvider(IFilteredLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public IFilteredLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected FilteredTableViewer buildFilteredViewer(Composite parent, String[] columnNames, int style, boolean defaultMenu) {
        long time0 = System.currentTimeMillis();
        this.buildSimpleInner(parent, 0x382 | style, columnNames);
        this.filteredViewer.setFilterPatternFactory(new PatternFilter("", columnNames));
        if (defaultMenu) {
            this.menus = this.filteredViewer.addContextMenu(this.getLabelProvider(), columnNames, null, null);
        }
        this.filteredViewer.setInput(this.unit, true);
        this.filteredViewer.setDisplayFilteredRowCount(true);
        long time1 = System.currentTimeMillis();
        Object[] objectArray = new Object[]{this, time1 - time0};
        return this.filteredViewer;
    }

    protected FilteredTableViewer buildSimple(Composite parent, int style, String[] columnNames) {
        this.buildSimpleInner(parent, style, columnNames);
        this.filteredViewer.setInput(this.unit, true);
        return this.filteredViewer;
    }

    private FilteredTableViewer buildSimpleInner(Composite parent, int style, String[] columnNames) {
        this.filteredView = new FilteredTableView(parent, style, columnNames);
        this.initFilteredView(this.filteredView);
        this.filteredViewer = new FilteredTableViewer(this.filteredView);
        this.filteredViewer.setContentProvider(this.provider);
        this.filteredViewer.setLabelProvider(this.getLabelProvider());
        return this.filteredViewer;
    }

    protected void addContextMenu(IContextMenu menuItem) {
        if (this.menus == null) {
            throw new IllegalStateException("No menu exist for this fragment");
        }
        for (ContextMenu menu : this.menus) {
            menu.addContextMenu(menuItem);
        }
    }

    public IFilteredStructuredViewer getViewer() {
        return this.filteredViewer;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.filteredViewer.addDoubleClickListener(listener);
    }

    public void refresh() {
        this.filteredViewer.refresh();
    }

    @Override
    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.filteredViewer.getSelection();
    }

    public Object getSelectedRawRow() {
        IStructuredSelection sel = this.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return sel.getFirstElement();
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        return null;
    }

    protected abstract boolean isCorrectRow(Object var1);

    @Override
    public String exportElementToString(Object obj) {
        if (this.isCorrectRow(obj)) {
            return this.exportRowToStringV(obj);
        }
        return null;
    }

    protected String exportRowToStringV(V obj) {
        Object[] row = this.labelProvider.getRowElements(obj);
        return ExportUtil.buildCsvLine(this.getLabelProvider(), obj, row.length);
    }

    protected void initFilteredView(FilteredTableView view) {
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.filteredView.exportToString());
    }
}

