/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.WindowExplorerView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.WindowExplorerViewer;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractNotAddressableUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class WindowExplorerFragment
extends AbstractNotAddressableUnitFragment<ContainerUnit> {
    private WindowExplorerViewer viewer;
    private Action actionZoom;
    private Action[] actionsLayout;
    private Action[] actionsPreview;
    private Action actionNav;
    private FilterText search;

    public WindowExplorerFragment(Composite parent, int flags, IRcpClientContext context, ContainerUnit unit) {
        super(parent, flags, unit, null, context);
        UIUtil.setStandardLayout(this, 1, 0, 0);
        Composite parentBar = new Composite((Composite)this, 0);
        parentBar.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        UIUtil.setStandardLayout(parentBar, 4, 0, 0);
        this.actionNav = UIUtil.createToolBarActionIcon("eclipse/jeb_up_nav.png", () -> this.gotToParent());
        this.actionNav.setEnabled(unit.getParent() instanceof IUnit);
        this.actionNav.setToolTipText("Go up");
        UIUtil.createHorizontalToolBar(0, parentBar, this.actionNav);
        Text path = new Text(parentBar, 0);
        path.setEnabled(false);
        path.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.updatePath(path, unit);
        this.search = new FilterText(parentBar);
        this.search.addApplyFilterListener(e -> this.applyFilter((String)e.data));
        this.createZoomButton(parentBar);
        this.createPreviewButtons(parentBar);
        this.createWindowLayoutButtons(parentBar);
        ToolBarManager tbm = UIUtil.createHorizontalToolBar(0, parentBar, this.actionZoom);
        tbm.add(new Separator());
        UIUtil.addToolbarActions(tbm, this.actionsPreview);
        tbm.add(new Separator());
        UIUtil.addToolbarActions(tbm, this.actionsLayout);
        tbm.update(true);
        GridData data = UIUtil.createGridDataFillHorizontalRightAligned();
        data.grabExcessHorizontalSpace = false;
        tbm.getControl().setLayoutData((Object)data);
        UIUtil.createSeparator(this, true);
        this.viewer = new WindowExplorerViewer(this, context);
        this.viewer.setInput(unit);
        this.actionZoom.setChecked(this.viewer.getControl().isZoom());
        this.setWindowLayoutButton(this.viewer.getControl().getWindowLayout());
        this.setPreviewButton(this.viewer.getControl().getPreviewType());
        UnitPartManager partManager = context.getPartManager().getPartManagersForUnit(unit).get(0);
        this.viewer.getControl().addUnitModifiedListener(e -> {
            IUnit newUnit = (IUnit)e.data;
            partManager.setPartNameUnit(newUnit);
            this.actionNav.setEnabled(this.viewer.getInput().getParent() instanceof IUnit);
            this.updatePath(path, newUnit);
        });
        this.setPrimaryWidget((Control)this.viewer.getControl());
    }

    private void updatePath(Text path, IUnit unit) {
        String pathStr = UnitUtil.buildFullyQualifiedUnitPath(unit);
        path.setText(pathStr);
        path.setToolTipText(pathStr);
    }

    private void applyFilter(String filterString) {
        if (this.viewer.getControl().setFilterText(filterString)) {
            this.viewer.refresh();
        } else {
            this.search.setStatus(Boolean.FALSE);
        }
    }

    private void createZoomButton(Composite parentBar) {
        this.actionZoom = UIUtil.createToolBarRadioActionIcon("eclipse/zoom.gif", () -> this.changeForceZoom());
        this.actionZoom.setToolTipText("Zoom images");
    }

    private void createPreviewButtons(Composite parentBar) {
        Action actionAll = UIUtil.createToolBarRadioActionIcon("eclipse/file_obj.png", () -> this.changePreview(WindowExplorerView.PreviewType.All));
        actionAll.setToolTipText("Preview all");
        Action actionImage = UIUtil.createToolBarRadioActionIcon("eclipse/image_application.png", () -> this.changePreview(WindowExplorerView.PreviewType.Image));
        actionImage.setToolTipText("Preview images");
        this.actionsPreview = new Action[]{actionAll, actionImage};
    }

    private void createWindowLayoutButtons(Composite parentBar) {
        Action actionList = UIUtil.createToolBarRadioActionIcon("eclipse/jeb_list.png", () -> this.changeLayout(WindowExplorerView.WindowLayout.LIST));
        actionList.setToolTipText("Display as list");
        Action actionSmallGrid = UIUtil.createToolBarRadioActionIcon("eclipse/jeb_small_grid.png", () -> this.changeLayout(WindowExplorerView.WindowLayout.SMALL_GRID));
        actionSmallGrid.setToolTipText("Display as small grid");
        Action actionLargeGrid = UIUtil.createToolBarRadioActionIcon("eclipse/jeb_large_grid.png", () -> this.changeLayout(WindowExplorerView.WindowLayout.LARGE_GRID));
        actionLargeGrid.setToolTipText("Display as large grid");
        this.actionsLayout = new Action[]{actionList, actionSmallGrid, actionLargeGrid};
    }

    private void gotToParent() {
        if (this.viewer.getInput().getParent() instanceof IUnit) {
            this.viewer.setInput(this.viewer.getInput().getParent());
        }
    }

    private void changeForceZoom() {
        this.viewer.getControl().setZoom(this.actionZoom.isChecked());
        this.viewer.refresh();
    }

    private void setWindowLayoutButton(WindowExplorerView.WindowLayout layout) {
        switch (layout) {
            case LARGE_GRID: {
                this.actionsLayout[0].setChecked(false);
                this.actionsLayout[1].setChecked(false);
                this.actionsLayout[2].setChecked(true);
                break;
            }
            case SMALL_GRID: {
                this.actionsLayout[0].setChecked(false);
                this.actionsLayout[2].setChecked(false);
                this.actionsLayout[1].setChecked(true);
                break;
            }
            case LIST: {
                this.actionsLayout[1].setChecked(false);
                this.actionsLayout[2].setChecked(false);
                this.actionsLayout[0].setChecked(true);
            }
        }
    }

    private void changeLayout(WindowExplorerView.WindowLayout layout) {
        if (layout == this.viewer.getControl().getWindowLayout()) {
            this.setWindowLayoutButton(layout);
            return;
        }
        this.setWindowLayoutButton(layout);
        this.viewer.getControl().setWindowLayout(layout);
        this.viewer.refresh();
    }

    private void setPreviewButton(WindowExplorerView.PreviewType preview) {
        switch (preview) {
            case All: {
                this.actionsPreview[0].setChecked(true);
                this.actionsPreview[1].setChecked(false);
                break;
            }
            case Image: {
                this.actionsPreview[0].setChecked(false);
                this.actionsPreview[1].setChecked(true);
            }
        }
    }

    private void changePreview(WindowExplorerView.PreviewType preview) {
        if (preview == this.viewer.getControl().getPreviewType()) {
            this.setPreviewButton(preview);
            return;
        }
        this.setPreviewButton(preview);
        this.viewer.getControl().setPreviewType(preview);
        this.viewer.refresh();
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.UNKNOWN;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        return null;
    }
}

