/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.client.api.IUnitFragmentPositionChangeListener;
import com.pnfsoftware.jeb.client.api.UnitFragmentPosition;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.TypeHierarchyView;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractPartManager;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TypeHierarchyPartManager
extends AbstractPartManager {
    private static final ILogger logger = GlobalLog.getLogger(TypeHierarchyPartManager.class);
    private TypeHierarchyView v;

    public TypeHierarchyPartManager(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean createView(Composite parent, final IMPart part) {
        this.part = part;
        parent.setLayout((Layout)new FillLayout());
        this.v = new TypeHierarchyView(parent, this.context);
        this.context.getEnginesContext().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                Object t = e.getType();
                if (t == J.ProjectClosing || t == J.ProjectUnloaded) {
                    TypeHierarchyPartManager.this.v.resetSource();
                }
            }
        });
        this.context.registerUnitFragmentPositionChangeListener(new IUnitFragmentPositionChangeListener(){

            @Override
            public void onUpdate(UnitFragmentPosition e) {
                if (e == null || !part.isShown()) {
                    return;
                }
                IInteractiveUnit unit = e.getUnit() instanceof IInteractiveUnit ? (IInteractiveUnit)e.getUnit() : null;
                ITextDocument doc = e.getDoc() instanceof ITextDocument ? (ITextDocument)e.getDoc() : null;
                long itemId = e.getItem() instanceof IActionableItem ? ((IActionableItem)((Object)e.getItem())).getItemId() : 0L;
                String addr = e.getAddress();
                TypeHierarchyPartManager.this.v.setSource(unit, doc, itemId, addr);
            }
        });
        this.context.wrapWidget((Control)this.v, "typeHierarchyWidgetPart");
        return true;
    }

    @Override
    public void onFocus() {
        this.context.getPartManager().onFocus(this.part);
        this.v.setFocus();
    }

    @Override
    public void deleteView() {
    }
}

