/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.util.DebuggerHelper;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.ConsoleViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditClearHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditFindHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditFindnextHandler;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.MultiInterpreter;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TerminalPartManager
extends AbstractPartManager
implements IOperable,
IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(TerminalPartManager.class, Integer.MAX_VALUE);
    private ConsoleViewer cv;
    private Listener focusInFilter;

    public TerminalPartManager(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean createView(Composite parent, IMPart part) {
        this.part = part;
        parent.setLayout((Layout)new FillLayout());
        this.cv = new ConsoleViewer(parent, 0);
        final MultiInterpreter mi = this.context.getMasterInterpreter();
        this.cv.setInterpreter(mi);
        mi.addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (((com.pnfsoftware.jeb.util.events.Event)e).getType() == 0) {
                    Object[] cfr_ignored_0 = new Object[0];
                    TerminalPartManager.this.cv.updatePromptAfterCommand(mi.getName() + "> ");
                } else if (((com.pnfsoftware.jeb.util.events.Event)e).getType() == 1) {
                    Object[] cfr_ignored_1 = new Object[0];
                    TerminalPartManager.this.cv.updatePrompt(mi.getName() + "> ");
                }
            }
        });
        Control ctl = this.cv.getControl();
        this.context.getFontManager().registerWidget(ctl);
        this.focusInFilter = new Listener(){

            public void handleEvent(Event event) {
                IUnit unit;
                PartManager pman = TerminalPartManager.this.context.getPartManager();
                IMPart part = pman.getActivePart();
                if (part != null && TerminalPartManager.this.focusChanged(unit = pman.getUnitForPart(part))) {
                    mi.notifyListeners(new com.pnfsoftware.jeb.util.events.Event(1));
                }
            }
        };
        this.context.getDisplay().addFilter(15, this.focusInFilter);
        new ContextMenu(this.cv.getControl()).addContextMenu(this);
        return true;
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        AllHandlers.getInstance().fillManager(menuMgr, 1);
        menuMgr.add(new Separator());
        menuMgr.add(new EditFindHandler());
        menuMgr.add(new EditFindnextHandler());
        menuMgr.add(new Separator());
        menuMgr.add(new EditClearHandler());
    }

    private boolean focusChanged(IUnit unit) {
        IDebuggerUnit dbgUnit;
        if (unit == null || unit.isDisposed()) {
            return false;
        }
        if (unit instanceof ICodeUnit && (dbgUnit = DebuggerHelper.getDebugger((ICodeUnit)unit, false)) != null) {
            unit = dbgUnit;
        }
        if (this.cv.getInterpreter() instanceof MultiInterpreter) {
            return ((MultiInterpreter)this.cv.getInterpreter()).onFocusChanged(unit);
        }
        return false;
    }

    @Override
    public void deleteView() {
        if (this.focusInFilter != null) {
            this.context.getDisplay().removeFilter(15, this.focusInFilter);
        }
    }

    public ConsoleViewer getConsoleViewer() {
        return this.cv;
    }

    @Override
    public void onFocus() {
        this.context.getPartManager().onFocus(this.part);
        this.cv.getControl().setFocus();
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        return this.cv.verifyOperation(req);
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        return this.cv.doOperation(req);
    }
}

