/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.QuickSearchView;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractPartManager;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class QuickSearchPartManager
extends AbstractPartManager {
    private static final ILogger logger = GlobalLog.getLogger(QuickSearchPartManager.class);
    private QuickSearchView v;

    public QuickSearchPartManager(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean createView(Composite parent, IMPart part) {
        this.part = part;
        parent.setLayout((Layout)new FillLayout());
        this.v = new QuickSearchView(parent, this.context, false);
        this.context.getEnginesContext().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                Object t = e.getType();
                if (t == J.ProjectClosing || t == J.ProjectUnloaded) {
                    QuickSearchPartManager.this.v.resetSource();
                } else if (t == J.ProjectLoaded) {
                    QuickSearchPartManager.this.v.setSource(QuickSearchPartManager.this.context.getOpenedProject());
                }
            }
        });
        this.context.wrapWidget((Control)this.v, "quickSearchWidgetPart");
        return true;
    }

    @Override
    public void onFocus() {
        this.context.getPartManager().onFocus(this.part);
        this.v.setSource(this.context.getOpenedProject());
        this.v.setFocus();
    }

    @Override
    public void deleteView() {
    }
}

