/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.IDuplicatedUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import java.util.List;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

class ProjectTreeLabelProvider
extends DefaultStyledCellLabelProvider {
    public static final int FGCOLOR_TRANSIENT = 160;
    public static final int BGCOLOR_DEBUGGER_ATTACHED = 10223003;
    public static final int BGCOLOR_UNPACKED_CONTAINER = 10223003;

    ProjectTreeLabelProvider() {
    }

    @Override
    public void update(ViewerCell cell) {
        Color fgcolor = null;
        Color bgcolor = null;
        Image img = null;
        Object element = cell.getElement();
        if (element instanceof IRuntimeProject) {
            img = UIAssetManager.getInstance().getImage("eclipse/prj_obj.png");
        } else if (element instanceof ILiveArtifact) {
            img = UIAssetManager.getInstance().getImage("eclipse/generic_element.png");
        } else if (element instanceof IUnit) {
            IUnit unit = (IUnit)element;
            fgcolor = ProjectTreeLabelProvider.determineLabelFgcolor(unit);
            bgcolor = ProjectTreeLabelProvider.determineLabelBgcolor(unit);
            if (element instanceof IDuplicatedUnit) {
                cell.setFont(UIAssetManager.getInstance().getFont(cell.getFont(), null, (Integer)2));
            }
            img = UnitPartManager.getIconForUnit(unit);
        } else if (element instanceof String && ((String)element).startsWith("<i>")) {
            cell.setFont(UIAssetManager.getInstance().getFont(cell.getFont(), null, (Integer)2));
        }
        cell.setForeground(fgcolor);
        cell.setBackground(bgcolor);
        if (img != null) {
            cell.setImage(img);
        }
        super.update(cell);
    }

    private CharSequence getDupName(IUnit element, IUnit target) {
        int j;
        int i;
        List<String> buildPath = UnitUtil.buildFullyQualifiedUnitPathList(element, true);
        List<String> buildPathTarget = UnitUtil.buildFullyQualifiedUnitPathList(target, true);
        for (i = 0; i < buildPath.size() && i < buildPathTarget.size() && buildPath.get(i).equals(buildPathTarget.get(i)); ++i) {
        }
        StringBuilder name = new StringBuilder();
        if (i == 0) {
            name.append("/ ");
        } else {
            for (j = i + 1; j < buildPath.size(); ++j) {
                name.append(".. > ");
            }
        }
        if (i == buildPathTarget.size()) {
            name.append("/ ");
            i = 0;
        }
        name.append(buildPathTarget.get(i));
        for (j = ++i; j < buildPathTarget.size(); ++j) {
            name.append(" > ").append(buildPathTarget.get(j));
        }
        return name;
    }

    private static boolean isTransientUnit(IUnit unit) {
        IUnitCreator parent = unit.getParent();
        if (parent instanceof IUnit) {
            return ((IUnit)parent).isTransientChild(unit);
        }
        return false;
    }

    private static Color determineLabelFgcolor(IUnit unit) {
        if (ProjectTreeLabelProvider.isTransientUnit(unit)) {
            return UIAssetManager.getInstance().getColor(160);
        }
        return null;
    }

    private static Color determineLabelBgcolor(IUnit unit) {
        if (!unit.isProcessed()) {
            return null;
        }
        if (unit instanceof IDebuggerUnit && ((IDebuggerUnit)unit).isAttached()) {
            return UIAssetManager.getInstance().getColor(10223003);
        }
        if (unit instanceof ContainerUnit && "unpacked".equals(unit.getName())) {
            return UIAssetManager.getInstance().getColor(10223003);
        }
        return null;
    }

    @Override
    public String getStringAt(Object element, int key) {
        if (element instanceof IRuntimeProject) {
            return ((IRuntimeProject)element).getName();
        }
        if (element instanceof ILiveArtifact) {
            return ((ILiveArtifact)element).getArtifact().getName();
        }
        if (element instanceof IUnit) {
            IUnit unit = (IUnit)element;
            Object text = unit.getName();
            if (element instanceof IDuplicatedUnit) {
                unit = ((IDuplicatedUnit)element).getOriginal();
                text = (String)text + " (duplicate of " + this.getDupName((IUnit)element, unit) + ")";
            }
            return text;
        }
        if (element instanceof String) {
            String text = (String)element;
            if (text.startsWith("<i>")) {
                text = text.substring(3);
            }
            return text;
        }
        return "?";
    }
}

