/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnknownBinaryUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.RcpClientProperties;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.parts.ArtifactManager;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.AggregatorDispatcher;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

class ProjectTreeContentProvider
implements IFilteredTreeContentProvider {
    private static final ILogger logger = GlobalLog.getLogger(ProjectTreeContentProvider.class);
    private IEnginesContext engctx;
    private IEventListener listener;
    private RcpClientContext context;
    private PartManager pman;
    private RcpClientProperties contextProperties;
    private List<Supplier<Boolean>> pendingTasks = new ArrayList<Supplier<Boolean>>();

    public ProjectTreeContentProvider(RcpClientContext context, PartManager pman) {
        this.context = context;
        this.pman = pman;
        this.contextProperties = context.getUiProperties();
    }

    @Override
    public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput == newInput) {
            return;
        }
        Object[] objectArray = new Object[]{oldInput, newInput};
        if (this.listener != null) {
            if (newInput != null && oldInput != this.engctx) {
                throw new RuntimeException();
            }
            this.engctx.removeListener(this.listener);
            this.listener = null;
        }
        if (newInput == null) {
            this.engctx = null;
            return;
        }
        if (!(newInput instanceof IEnginesContext)) {
            throw new RuntimeException();
        }
        this.engctx = (IEnginesContext)newInput;
        final Display display = viewer.getControl().getDisplay();
        this.listener = new AggregatorDispatcher(10000, 500L){

            @Override
            public void onMultipleEvents(final List<IEvent> events) {
                (new Object[1])[0] = events;
                if (!display.isDisposed()) {
                    UIExecutor.async(display, new UIRunnable(){

                        @Override
                        public void runi() {
                            if (display.isDisposed() || viewer.getControl().isDisposed()) {
                                return;
                            }
                            TreeViewer treeViewer = (TreeViewer)viewer;
                            viewer.refresh();
                            for (IEvent e : events) {
                                Object object = e.getData();
                                if (!(object instanceof ILiveArtifact)) continue;
                                boolean useAManager = ProjectTreeContentProvider.this.contextProperties != null && ProjectTreeContentProvider.this.contextProperties.shouldAutoOpenDefaultUnit();
                                ArtifactManager amanager = ArtifactManager.getInstance();
                                ArrayList<Object> expanded = new ArrayList<Object>();
                                expanded.add(((ILiveArtifact)object).getRuntimeProject());
                                expanded.add(object);
                                if (useAManager) {
                                    expanded.addAll(amanager.getExpandedUnits((ILiveArtifact)object));
                                }
                                Object[] objectArray = new Object[]{expanded.size(), expanded};
                                expanded.addAll(0, Arrays.asList(treeViewer.getExpandedElements()));
                                treeViewer.setExpandedElements(expanded.toArray());
                                if (!useAManager) continue;
                                amanager.processLiveArtifact(ProjectTreeContentProvider.this.context, ProjectTreeContentProvider.this.pman, (ILiveArtifact)object, treeViewer);
                            }
                            for (int i = 0; i < ProjectTreeContentProvider.this.pendingTasks.size(); ++i) {
                                if (ProjectTreeContentProvider.this.pendingTasks.get(i).get() != Boolean.TRUE) continue;
                                ProjectTreeContentProvider.this.pendingTasks.remove(i);
                                --i;
                            }
                        }
                    });
                }
            }
        };
        this.engctx.addListener(this.listener);
    }

    public void onOpening(IUnit unit, TreeViewer treeViewer) {
        ArtifactManager amanager;
        Supplier<Boolean> task;
        boolean useAManager;
        boolean bl = useAManager = this.contextProperties != null && this.contextProperties.shouldAutoOpenDefaultUnit();
        if (useAManager && (task = (amanager = ArtifactManager.getInstance()).processUnit(this.context, this.pman, unit, treeViewer)) != null && task.get() == Boolean.FALSE) {
            this.pendingTasks.add(task);
        }
    }

    @Override
    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    @Override
    public Object getParent(Object element) {
        return null;
    }

    @Override
    public Object[] getChildren(Object element) {
        Object[] r = ArrayUtil.NO_OBJECT;
        if (element instanceof IEnginesContext) {
            IEnginesContext input = (IEnginesContext)element;
            r = input.getProjects().toArray();
        } else if (element instanceof IRuntimeProject) {
            IRuntimeProject input = (IRuntimeProject)element;
            r = input.getLiveArtifacts().toArray();
        } else if (element instanceof ILiveArtifact) {
            ILiveArtifact input = (ILiveArtifact)element;
            r = input.getUnits().toArray();
        } else if (element instanceof IUnit) {
            IUnit input = (IUnit)element;
            List<? extends IUnit> children = input.getChildren();
            r = children != null && !children.isEmpty() ? input.getChildren().toArray() : (!input.isProcessed() && !(input instanceof UnknownBinaryUnit) ? new Object[]{"<i>process unit first"} : ArrayUtil.NO_OBJECT);
        }
        return r;
    }

    @Override
    public boolean hasChildren(Object element) {
        boolean r = false;
        if (element instanceof IEnginesContext) {
            IEnginesContext input = (IEnginesContext)element;
            r = !input.getProjects().isEmpty();
        } else if (element instanceof IRuntimeProject) {
            IRuntimeProject input = (IRuntimeProject)element;
            r = !input.getLiveArtifacts().isEmpty();
        } else if (element instanceof ILiveArtifact) {
            ILiveArtifact input = (ILiveArtifact)element;
            r = !input.getUnits().isEmpty();
        } else if (element instanceof IUnit) {
            IUnit input = (IUnit)element;
            boolean bl = r = input.getChildren() != null && !input.getChildren().isEmpty();
            if (!(r || input.isProcessed() || input instanceof UnknownBinaryUnit)) {
                return true;
            }
        }
        return r;
    }
}

