/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.client.events.JC;
import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.SubInput;
import com.pnfsoftware.jeb.core.units.IArchiveUnit;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IDuplicatedUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.UnknownBinaryUnit;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.core.units.impl.FileContainerUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.AdaptivePopupDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ArtifactPropertiesDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ParserSelectionInformation;
import com.pnfsoftware.jeb.rcpclient.dialogs.ProjectPropertiesDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ReparseDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.UnitPropertiesDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.PatternTreeViewer;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.actions.ActionExtractToHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.actions.ActionParseAtHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.FileDeleteHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.FilePropertiesHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.windows.WindowExploreView;
import com.pnfsoftware.jeb.rcpclient.handlers.windows.WindowOpenNewView;
import com.pnfsoftware.jeb.rcpclient.handlers.windows.WindowOpenView;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.NativeImageParserOptionsDialog;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.ProjectTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.parts.ProjectTreeLabelProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class ProjectExplorerPartManager
extends AbstractPartManager
implements IOperable {
    private static final ILogger logger = GlobalLog.getLogger(ProjectExplorerPartManager.class);
    private static final int ACTION_SELECTION = 0;
    private static final int ACTION_DOUBLE_CLICK = 1;
    private static final int ACTION_DOUBLE_CLICK_DUP = -1;
    private Composite parent;
    private FilteredTreeViewer ftv;
    private PartManager pman;
    private ProjectTreeContentProvider contentProvider;

    public ProjectExplorerPartManager(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean createView(Composite parent, IMPart part) {
        this.part = part;
        parent.setLayout((Layout)new FillLayout());
        this.parent = parent;
        this.pman = this.context.getPartManager();
        ProjectTreeLabelProvider labelProvider = new ProjectTreeLabelProvider();
        boolean expandAfterFilter = this.context.getPropertyManager().getBoolean(".ui.ExpandTreeNodesOnFiltering");
        this.ftv = new PatternTreeViewer(parent, 0, null, null, expandAfterFilter);
        this.ftv.addSelectionChangedListener(e -> {
            if (this.context.getUiProperties().getProjectUnitSync()) {
                this.handleSelectionChangedEvent(e);
            }
        });
        this.ftv.addDoubleClickListener(e -> this.handleDoubleClickEvent(e));
        this.contentProvider = new ProjectTreeContentProvider(this.context, this.pman);
        this.ftv.setContentProvider(this.contentProvider);
        this.ftv.setLabelProvider(labelProvider);
        this.ftv.setInput(this.context.getEnginesContext());
        this.context.addListener(e -> {
            if (e.getType() == JC.InitializationComplete && !this.ftv.getViewer().getControl().isDisposed()) {
                this.ftv.setInput(this.context.getEnginesContext());
            }
        });
        Display display = this.ftv.getControl().getDisplay();
        this.context.getEnginesContext().addListener(e -> {
            if (e.getType() == J.ProjectUnloaded) {
                if (!display.isDisposed()) {
                    UIExecutor.sync(display, () -> this.ftv.setInput(null));
                }
            } else if (e.getType() == J.ProjectLoaded && !display.isDisposed()) {
                UIExecutor.sync(display, () -> this.ftv.setInput(this.context.getEnginesContext()));
            }
        });
        new ContextMenu(this.ftv.getViewer().getControl()).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                if (!ProjectExplorerPartManager.this.context.hasOpenedProject()) {
                    return;
                }
                Object selNode = ProjectExplorerPartManager.this.getSelectedNode();
                if (selNode instanceof ContainerUnit) {
                    menuMgr.add(new WindowExploreView());
                } else {
                    menuMgr.add(new WindowOpenView());
                    menuMgr.add(new WindowOpenNewView());
                }
                menuMgr.add(new Separator());
                menuMgr.add(new ActionExtractToHandler());
                menuMgr.add(new ActionParseAtHandler());
                menuMgr.add(new Separator());
                menuMgr.add(new FileDeleteHandler());
                menuMgr.add(new Separator());
                menuMgr.add(new FilePropertiesHandler());
            }
        });
        return true;
    }

    public Object getSelectedNode() {
        ITreeSelection treesel = (ITreeSelection)this.ftv.getSelection();
        if (treesel.isEmpty()) {
            return null;
        }
        return treesel.getFirstElement();
    }

    public boolean focusOnNode(Object node) {
        if (!(node instanceof IRuntimeProject || node instanceof ILiveArtifact || node instanceof IUnit)) {
            return false;
        }
        TreeViewer v = this.ftv.getViewer();
        StructuredSelection selection = new StructuredSelection(node);
        IRuntimeProject project = this.context.getOpenedProject();
        if (node instanceof IRuntimeProject) {
            if (node != project) {
                return false;
            }
            selection = new StructuredSelection(project);
        } else if (node instanceof ILiveArtifact) {
            ILiveArtifact artifact = null;
            for (ILiveArtifact a : project.getLiveArtifacts()) {
                if (a != node) continue;
                artifact = a;
                break;
            }
            if (artifact == null) {
                return false;
            }
            selection = new TreeSelection(new TreePath(new Object[]{project, artifact}));
        } else if (node instanceof IUnit) {
            IUnit unit = (IUnit)node;
            ArrayList<Object> path = new ArrayList<Object>();
            while (true) {
                path.add(0, unit);
                if (!(unit.getParent() instanceof IUnit)) break;
                unit = (IUnit)unit.getParent();
            }
            IArtifact artifact0 = (IArtifact)unit.getParent();
            ILiveArtifact artifact = null;
            for (ILiveArtifact a : project.getLiveArtifacts()) {
                if (a.getArtifact() != artifact0) continue;
                artifact = a;
            }
            if (artifact == null) {
                return false;
            }
            path.add(0, artifact);
            path.add(0, project);
            selection = new TreeSelection(new TreePath(path.toArray()));
        }
        v.reveal(node);
        v.setSelection(selection);
        return true;
    }

    @Override
    public void onFocus() {
        this.context.getPartManager().onFocus(this.part);
        this.ftv.getFilteredTreeWidget().setFocus();
    }

    public static void setupDragAndDrop(final Control parent, final RcpClientContext context) {
        DropTarget dt = new DropTarget(parent, 7);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof String[]) {
                    String[] paths = (String[])event.data;
                    int i = 0;
                    for (String path : paths) {
                        if (i == 0) {
                            if (context.hasOpenedProject()) {
                                MessageBox mb = new MessageBox(context.getActiveShell(), 456);
                                mb.setText(S.s(207));
                                mb.setMessage(S.s(659) + ".\n\nWould you like to create a new project?");
                                int r = mb.open();
                                if (r == 64) {
                                    if (!context.loadInputAsProject(parent.getShell(), path)) {
                                        break;
                                    }
                                } else if (r == 128) {
                                    context.loadInputAsAdditionalArtifact(parent.getShell(), path);
                                } else if (r == 256) {
                                    break;
                                }
                            } else if (!context.loadInputAsProject(parent.getShell(), path)) {
                                break;
                            }
                        } else {
                            context.loadInputAsAdditionalArtifact(parent.getShell(), path);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent e) {
        this.handleSelectionEvent(e.getSelection(), 0);
    }

    private void handleDoubleClickEvent(DoubleClickEvent e) {
        this.handleSelectionEvent(e.getSelection(), 1);
    }

    private void handleSelectionEvent(ISelection selection, int action) {
        if (!(selection instanceof TreeSelection)) {
            return;
        }
        TreeSelection treesel = (TreeSelection)selection;
        Object elt = treesel.getFirstElement();
        if (elt == null) {
            return;
        }
        this.handleNodeAction(elt, action);
    }

    private void handleNodeAction(Object elt, int action) {
        if (elt instanceof IUnit) {
            IUnit unit = (IUnit)elt;
            this.context.getTelemetry().record("handlerOpenUnit", "unitType", unit.getFormatType());
            if (action == 1 && unit instanceof IDuplicatedUnit) {
                unit = ((IDuplicatedUnit)unit).getOriginal();
                elt = unit;
                action = -1;
            }
            if (!HandlerUtil.processUnit(this.parent.getShell(), this.context, unit, true)) {
                return;
            }
            if (unit.isDisposed()) {
                if (unit instanceof UnknownBinaryUnit) {
                    elt = ((UnknownBinaryUnit)unit).getKnownUnit();
                    if (elt == null) {
                        return;
                    }
                    this.ftv.refresh();
                    this.focusOnNode(elt);
                } else {
                    return;
                }
            }
        }
        if (elt instanceof IUnit && !(elt instanceof ContainerUnit) && !(elt instanceof IArchiveUnit)) {
            this.pman.create((IUnit)elt, true);
            if (action == 0) {
                this.requestFocus();
            }
        } else if (action == 1) {
            if (this.isResourceNode(elt)) {
                this.pman.create((IUnit)elt, true);
            } else {
                this.ftv.getViewer().setExpandedState(elt, !this.ftv.getViewer().getExpandedState(elt));
            }
            if (elt instanceof IUnit) {
                this.contentProvider.onOpening((IUnit)elt, this.ftv.getViewer());
            }
        } else if (action == -1) {
            this.focusOnNode(elt);
        }
    }

    private boolean isResourceNode(Object elt) {
        if (!(elt instanceof ContainerUnit)) {
            return false;
        }
        ContainerUnit res = (ContainerUnit)elt;
        if (!(res.getParent() instanceof IApkUnit)) {
            return false;
        }
        return ((IApkUnit)res.getParent()).getResources() == res;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        Object node = this.getSelectedNode();
        switch (req.getOperation()) {
            case PROPERTIES: {
                return node instanceof IRuntimeProject || node instanceof ILiveArtifact || node instanceof IUnit;
            }
            case EXTRACT_TO: {
                return this.canExtractTo(node);
            }
            case PARSE_AT: 
            case VIEW: 
            case VIEW_NEW: {
                return node instanceof IUnit && !(node instanceof ContainerUnit);
            }
            case DELETE: {
                return node instanceof IUnit || node instanceof ILiveArtifact;
            }
            case FIND: {
                return true;
            }
        }
        return false;
    }

    private boolean canExtractTo(Object node) {
        if (node instanceof ILiveArtifact || node instanceof IBinaryUnit) {
            return true;
        }
        if (node instanceof FileContainerUnit) {
            for (IUnit iUnit : ((FileContainerUnit)node).getChildren()) {
                if (!this.canExtractTo(iUnit)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        Object node = this.getSelectedNode();
        switch (req.getOperation()) {
            case PARSE_AT: {
                IUnitProcessor processor;
                IUnitIdentifier ident;
                if (!(node instanceof IUnit)) {
                    return false;
                }
                IUnit unit = (IUnit)node;
                ReparseDialog dlg = new ReparseDialog(this.parent.getShell(), unit);
                ParserSelectionInformation info = dlg.open();
                if (info == null) {
                    return false;
                }
                (new Object[1])[0] = info;
                SubInput subinput = null;
                if (unit instanceof IBinaryUnit) {
                    long maxsize;
                    long size;
                    IInput input = ((IBinaryUnit)unit).getInput();
                    long offset = info.getOffset();
                    if (offset + (size = info.getSize()) > (maxsize = input.getCurrentSize())) {
                        size = maxsize - offset;
                    }
                    if (offset >= 0L && size > 0L && offset <= maxsize) {
                        try {
                            subinput = new SubInput(input, offset, size);
                        }
                        catch (IOException e) {
                            logger.catching(e);
                            return false;
                        }
                    }
                }
                if ((ident = (processor = unit.getUnitProcessor()).getUnitIdentifier(info.getWantedType())) == null) {
                    return false;
                }
                boolean successfullyIdentified = ident.canIdentify(subinput, unit, null, null);
                if (!successfullyIdentified) {
                    String msg = Strings.ff("%s: \"%s\".\n\n%s", S.s(389), ident.getFormatType(), S.s(662));
                    if (!MessageDialog.openQuestion(this.parent.getShell(), S.s(377), msg)) {
                        return false;
                    }
                }
                IUnit subunit = null;
                try {
                    subunit = ident.prepare(info.getSubUnitName(), subinput, processor, unit, null);
                }
                catch (Exception e) {
                    if (!successfullyIdentified) {
                        logger.catching(e);
                    }
                    throw e;
                }
                if (subunit == null) {
                    String msg = Strings.ff("%s: \"%s\".", S.s(390), ident.getFormatType());
                    MessageDialog.openError(this.parent.getShell(), S.s(629), msg);
                    return false;
                }
                if (subunit instanceof INativeCodeUnit) {
                    NativeImageParserOptionsDialog dlg2 = new NativeImageParserOptionsDialog(this.parent.getShell());
                    dlg2.setSelected(true);
                    String str = dlg2.open();
                    if (str == null) {
                        return false;
                    }
                    INativeCodeUnit pbcu = (INativeCodeUnit)subunit;
                    pbcu.setVirtualImageBase(dlg2.getImageBase());
                    pbcu.getProcessor().setEndianness(dlg2.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN);
                }
                unit.addChild(subunit);
                UI.info("A reparsed sub-unit was created");
                return true;
            }
            case EXTRACT_TO: {
                String name;
                IInput input;
                if (node instanceof ILiveArtifact) {
                    input = ((ILiveArtifact)node).getArtifact().getInput();
                    name = ((ILiveArtifact)node).getArtifact().getName();
                } else if (node instanceof IBinaryUnit) {
                    input = ((IBinaryUnit)node).getInput();
                    name = ((IBinaryUnit)node).getName();
                } else {
                    if (node instanceof FileContainerUnit) {
                        DirectoryDialog dlg = new DirectoryDialog(this.parent.getShell());
                        dlg.setText(S.s(340));
                        String filepath = dlg.open();
                        if (filepath == null) {
                            return false;
                        }
                        return this.extractAll((FileContainerUnit)node, new File(filepath), new AtomicInteger(-1));
                    }
                    return false;
                }
                FileDialog dlg = new FileDialog(this.parent.getShell(), 8192);
                dlg.setText(S.s(339));
                dlg.setOverwrite(true);
                dlg.setFileName(name);
                String filepath = dlg.open();
                if (filepath == null) {
                    return false;
                }
                return this.extractOne(input, filepath);
            }
            case PROPERTIES: {
                JebDialog dlg;
                if (node instanceof IRuntimeProject) {
                    dlg = new ProjectPropertiesDialog(this.parent.getShell(), (IRuntimeProject)node);
                } else if (node instanceof ILiveArtifact) {
                    dlg = new ArtifactPropertiesDialog(this.parent.getShell(), (ILiveArtifact)node);
                } else if (node instanceof IUnit) {
                    dlg = new UnitPropertiesDialog(this.parent.getShell(), (IUnit)node);
                } else {
                    return false;
                }
                ((JebDialog)dlg).open();
                return true;
            }
            case VIEW: 
            case VIEW_NEW: {
                if (!(node instanceof IUnit)) {
                    return false;
                }
                this.pman.create((IUnit)node, req.getOperation() == Operation.VIEW);
                return true;
            }
            case DELETE: {
                if (node instanceof IUnit) {
                    String msg = S.s(791);
                    if (UI.confirm(this.parent.getShell(), S.s(207), msg)) {
                        IUnit unit = (IUnit)node;
                        return this.context.getOpenedProject().destroyUnit(unit);
                    }
                } else if (node instanceof ILiveArtifact && UI.confirm(this.parent.getShell(), S.s(207), "Are you sure you want to delete this artifact and its underlying unit tree?\n\n(No file on the file system will be deleted)")) {
                    return RuntimeProjectUtil.destroyLiveArtifact((ILiveArtifact)node);
                }
                return false;
            }
            case FIND: {
                this.ftv.getFilteredTreeWidget().setFilterVisibility(true, true);
                return true;
            }
        }
        return false;
    }

    private boolean extractAll(FileContainerUnit node, File filepath, AtomicInteger overwrite) {
        boolean extracted = true;
        for (IUnit iUnit : node.getChildren()) {
            IInput input = null;
            String name = null;
            if (iUnit instanceof ILiveArtifact) {
                input = ((ILiveArtifact)((Object)iUnit)).getArtifact().getInput();
                name = ((ILiveArtifact)((Object)iUnit)).getArtifact().getName();
            } else if (iUnit instanceof IBinaryUnit) {
                input = ((IBinaryUnit)iUnit).getInput();
                name = ((IBinaryUnit)iUnit).getName();
            } else if (!(iUnit instanceof FileContainerUnit)) continue;
            if (iUnit instanceof FileContainerUnit) {
                extracted &= this.extractAll((FileContainerUnit)iUnit, new File(filepath, IO.sanitizePath(iUnit.getName(), true, true)), overwrite);
                continue;
            }
            if (filepath.exists() && !filepath.isDirectory() || !filepath.exists() && !filepath.mkdirs()) {
                extracted = false;
                continue;
            }
            File destination = new File(filepath, IO.sanitizePath(name, true, true));
            if (destination.exists()) {
                if (overwrite.get() == 0) continue;
                if (overwrite.get() == -1) {
                    String msg = Strings.f(S.s(416), destination.getName());
                    AdaptivePopupDialog popup = AdaptivePopupDialog.question(UI.getShellTracker().get(), S.s(207), msg);
                    int res = popup.open();
                    if (popup.isDoNotShow()) {
                        overwrite.set(res == 1 ? 1 : 0);
                    }
                    if (res != 1) continue;
                }
            }
            extracted = this.extractOne(input, destination.getAbsolutePath());
        }
        return extracted;
    }

    private boolean extractOne(IInput input, String filepath) {
        Object[] objectArray = new Object[]{S.s(340), filepath};
        try (InputStream in = input.getStream();){
            byte[] data = IO.readInputStream(in);
            IO.writeFile(new File(filepath), data);
        }
        catch (IOException e) {
            logger.catching(e);
            return false;
        }
        return true;
    }
}

