/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.export.ExportUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.export.IExportableData;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.handlers.actions.ActionJumpToHandler;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.LoggerPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.collect.ItemHistory;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class NavigationPartManager
extends AbstractPartManager
implements IOperable,
IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(LoggerPartManager.class);
    private FilteredTableViewer viewer;

    public NavigationPartManager(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean createView(Composite parent, IMPart part) {
        this.part = part;
        parent.setLayout((Layout)new FillLayout());
        FilteredTableView ft = new FilteredTableView(parent, 0, new String[]{S.s(786), S.s(52), "Details", "Part/Fragment"});
        this.viewer = new FilteredTableViewer(ft){

            @Override
            protected TableViewer buildViewer(AbstractFilteredView<Table, TableColumn, TableItem> widget, boolean shadow) {
                return new TableViewer(shadow ? widget.getShadowElement() : widget.getMainElement()){

                    @Override
                    protected Object[] getSortedChildren(Object parent) {
                        Object[] sorted = super.getSortedChildren(parent);
                        if (NavigationPartManager.this.viewer == null || NavigationPartManager.this.viewer.getComparator() == null || NavigationPartManager.this.viewer.getControl().getSortDirection() == 0) {
                            return sorted;
                        }
                        for (int i = 0; i < sorted.length; ++i) {
                            if (!(sorted[i] instanceof CurrentPosition)) continue;
                            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(sorted));
                            list.remove(i);
                            return list.toArray();
                        }
                        return sorted;
                    }
                };
            }
        };
        ContentProviderListener p = new ContentProviderListener();
        this.viewer.setContentProvider(p);
        this.viewer.setLabelProvider(new LabelProvider());
        this.viewer.setInput(this.context);
        IEventListener refreshListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                NavigationPartManager.this.viewer.refresh();
            }
        };
        this.context.getViewManager().getGlobalPositionHistory().addListener(refreshListener);
        this.viewer.getControl().addDisposeListener(e -> this.context.getViewManager().getGlobalPositionHistory().removeListener(refreshListener));
        this.viewer.addDoubleClickListener(e -> {
            OperationRequest op = new OperationRequest(Operation.JUMP_TO);
            if (this.verifyOperation(op)) {
                this.doOperation(op);
            }
        });
        this.viewer.addContextMenu(this.viewer.getLabelProvider(), new String[0], null, this);
        return true;
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        AllHandlers.getInstance().fillManager(menuMgr, 1);
        menuMgr.add(new Separator());
        final OperationRequest op = new OperationRequest(Operation.JUMP_TO);
        menuMgr.add(new ActionJumpToHandler(){

            @Override
            public boolean canExecute() {
                return NavigationPartManager.this.verifyOperation(op);
            }

            @Override
            public void execute() {
                NavigationPartManager.this.doOperation(op);
            }
        });
    }

    @Override
    public void onFocus() {
        this.context.getPartManager().onFocus(this.part);
        this.viewer.getControl().setFocus();
    }

    public GlobalPosition getSelectedPosition() {
        List<?> selList = this.getSelectedRows();
        if (selList == null || selList.isEmpty()) {
            return null;
        }
        GlobalPosition pos = (GlobalPosition)selList.get(0);
        if (pos instanceof CurrentPosition) {
            return null;
        }
        return pos;
    }

    public List<?> getSelectedRows() {
        ISelection sel0 = this.viewer.getSelection();
        if (sel0.isEmpty()) {
            return null;
        }
        if (sel0 instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)sel0;
            return sel.toList();
        }
        return null;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                return !this.viewer.getSelection().isEmpty();
            }
            case JUMP_TO: {
                List<?> rows = this.getSelectedRows();
                return rows != null && rows.size() == 1 && !(rows.get(0) instanceof CurrentPosition);
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                return ExportUtil.copyLinesToClipboard((IExportableData)((Object)this.viewer.getLabelProvider()), this.getSelectedRows());
            }
            case JUMP_TO: {
                GlobalPosition position;
                int selectionIndex = this.viewer.getSelectionIndex();
                ItemHistory<GlobalPosition> history = this.context.getViewManager().getGlobalPositionHistory();
                if (history == null || selectionIndex < 0) {
                    return false;
                }
                boolean updateHistory = false;
                if (!updateHistory && (position = this.getSelectedPosition()) != null) {
                    return UnitPartManager.setActiveAddress(this.context, position);
                }
                return false;
            }
        }
        return false;
    }

    class ContentProviderListener
    implements IFilteredTableContentProvider {
        ContentProviderListener() {
        }

        @Override
        public Object[] getElements(Object elt) {
            ItemHistory<GlobalPosition> history = NavigationPartManager.this.context.getViewManager().getGlobalPositionHistory();
            if (history != null) {
                List<GlobalPosition> hist = history.get();
                hist.add(history.position(), new CurrentPosition());
                return hist.toArray();
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }

    class LabelProvider
    extends DefaultCellLabelProvider
    implements IExportableData {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 2;
        }

        @Override
        public void update(ViewerCell cell) {
            Style style;
            super.update(cell);
            if (cell.getElement() instanceof CurrentPosition && (style = NavigationPartManager.this.context.getStyleManager().getActiveStyle(ItemClassIdentifiers.RESULT_SUCCESS)) != null) {
                cell.setForeground(style.getColor());
                cell.setBackground(style.getBackgroungColor());
            }
        }

        @Override
        public String getStringAt(Object element, int key) {
            if (element instanceof CurrentPosition) {
                return "";
            }
            if (element instanceof GlobalPosition) {
                GlobalPosition e = (GlobalPosition)element;
                if (key == 0) {
                    return e.getUnit().getName();
                }
                if (key == 1) {
                    if (e.getPosition() == null) {
                        return null;
                    }
                    return e.getPosition().getAddress();
                }
                if (key == 2) {
                    if (e.getPosition() == null) {
                        return null;
                    }
                    Object extra = e.getPosition().getExtra();
                    if (extra == null) {
                        return null;
                    }
                    return extra.toString();
                }
                if (key == 3) {
                    IMPart part = NavigationPartManager.this.context.getPartManager().getPartById(e.getPartId());
                    if (part == null) {
                        return null;
                    }
                    return part.getLabel();
                }
            }
            return null;
        }

        @Override
        public String exportElementToString(Object obj) {
            return ExportUtil.buildCsvLine(this, obj, 2);
        }
    }

    private static class CurrentPosition
    extends GlobalPosition {
        public CurrentPosition() {
            super(null, 0, 0L, null);
        }
    }
}

