/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitInterpreter;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.events.Event;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.AutocompletionResult;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.interpreter.ICommandInterpreter;
import com.pnfsoftware.jeb.util.interpreter.InterpreterHistory;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiInterpreter
extends EventSource
implements ICommandInterpreter {
    private static final ILogger logger = GlobalLog.getLogger(MultiInterpreter.class);
    public static final int EVENT_INTERPRETER_CHANGE = 0;
    public static final int EVENT_INTERPRETER_CHANGE_IMMEDIATE = 1;
    private List<Interpreter> interpreters = new ArrayList<Interpreter>();
    private static final int MASTER = -1;
    private int primary = -1;
    private InterpreterHistory masterHistory = new InterpreterHistory();
    private List<String> autocompleteTokens;

    public int registerInterpreter(ICommandInterpreter inter) {
        if (inter == null) {
            throw new IllegalArgumentException("The provided interpreter is null");
        }
        Interpreter e = new Interpreter(inter);
        int index = this.interpreters.indexOf(e);
        if (index >= 0) {
            return index;
        }
        index = this.interpreters.size();
        this.interpreters.add(e);
        return index;
    }

    public void unregisterInterpreter(int index) {
        if (index < 0 || index >= this.interpreters.size()) {
            return;
        }
        this.unregisterInterpreter(this.interpreters.get((int)index).inter);
    }

    private void unregisterInterpreter(ICommandInterpreter inter) {
        Interpreter e = new Interpreter(inter);
        if (!this.interpreters.contains(e)) {
            return;
        }
        int index = this.interpreters.indexOf(e);
        if (index == this.primary) {
            this.setPrimary(-1);
        }
        this.interpreters.set(index, null);
    }

    @Override
    public String getName() {
        ICommandInterpreter interpreter = this.getCurrentInterpreter();
        if (interpreter == this) {
            return "";
        }
        return interpreter.getName();
    }

    @Override
    public String getDescription() {
        ICommandInterpreter interpreter = this.getCurrentInterpreter();
        if (interpreter == this) {
            return null;
        }
        return interpreter.getDescription();
    }

    @Override
    public String getBanner() {
        ICommandInterpreter interpreter = this.getCurrentInterpreter();
        if (interpreter == this) {
            return null;
        }
        return interpreter.getBanner();
    }

    @Override
    public void prepare() {
        ICommandInterpreter interpreter = this.getCurrentInterpreter();
        if (interpreter == this) {
            return;
        }
        interpreter.prepare();
    }

    @Override
    public boolean shouldDisplayRawResults() {
        ICommandInterpreter interpreter = this.getCurrentInterpreter();
        if (interpreter == this) {
            return false;
        }
        return interpreter.shouldDisplayRawResults();
    }

    @Override
    public ExecutionResult executeCommand(String command) {
        if ((command = command.trim()).equals("exit")) {
            this.setPrimary(-1);
            return ExecutionResult.GENERIC_SUCCESS;
        }
        if (this.primary >= 0 && !command.startsWith(".")) {
            ICommandInterpreter inter = this.getCurrentInterpreter();
            if (inter == this) {
                return ExecutionResult.error("Illegal interpreter");
            }
            this.doLazyPreparation(inter);
            return inter.executeCommand(command);
        }
        if (command.startsWith(".")) {
            command = command.substring(1);
        }
        String[] tokens = command.split("\\s+");
        if (command.equals("help")) {
            String msg = "help              : help about the master interpreter\nlist              : display a list of available console ports\nuse <interpreter> : set the active console associated with this display; -1 for master\nexit              : exit the current interpreter and return to the master interpreter";
            return ExecutionResult.success(msg);
        }
        if (command.equals("list")) {
            StringBuilder sb = new StringBuilder();
            int cnt = this.getInterpreterCount();
            if (cnt == 0) {
                sb.append("No interpreter is available at the moment.");
            } else {
                Strings.ff(sb, "%d %s available", cnt, PluralFormatter.countS(cnt, "interpreter"));
                int i = 0;
                for (Interpreter e : this.interpreters) {
                    if (e != null) {
                        Strings.ff(sb, "\n(%d) %s: %s", i, e.inter.getName(), e.inter.getDescription());
                    }
                    ++i;
                }
            }
            return ExecutionResult.success(sb.toString());
        }
        if (tokens.length >= 1 && tokens[0].equals("use")) {
            if (tokens.length != 2) {
                return ExecutionResult.error("Specify a console port");
            }
            int index = Conversion.stringToInt(tokens[1], -1);
            if (index < 0) {
                index = this.findInterpreterIndexByName(tokens[1], false);
            }
            if (index >= this.interpreters.size()) {
                return ExecutionResult.error("Invalid console port");
            }
            this.setPrimary(index);
            if (index >= 0) {
                Interpreter entry = this.interpreters.get(index);
                if (entry == null) {
                    return ExecutionResult.error("Interpreter is no more available (debugger was detached). Use list to see available interpreters.");
                }
                if (!entry.bannerDisplayed) {
                    entry.bannerDisplayed = true;
                    String banner = entry.inter.getBanner();
                    if (banner != null && !banner.isEmpty()) {
                        return ExecutionResult.success(banner);
                    }
                }
            }
        } else if (command.equals("exit")) {
            this.setPrimary(-1);
        } else {
            return ExecutionResult.error("Unknown command");
        }
        return ExecutionResult.GENERIC_SUCCESS;
    }

    int findInterpreterIndexByName(String name, boolean allowAmbiguity) {
        int candidate = -1;
        int i = 0;
        for (Interpreter entry : this.interpreters) {
            if (entry != null && entry.inter.getName().contains(name)) {
                if (allowAmbiguity) {
                    return i;
                }
                if (candidate >= 0) {
                    return -1;
                }
                candidate = i;
            }
            ++i;
        }
        return candidate;
    }

    void setPrimary(int index) {
        this.setPrimary(index, false);
    }

    void setPrimary(int index, boolean immediateChange) {
        if (index < 0 || index >= this.interpreters.size() || this.interpreters.get(index) == null) {
            index = -1;
        }
        this.primary = index;
        this.notifyListeners(new Event(immediateChange ? 1 : 0));
    }

    ICommandInterpreter getCurrentInterpreter() {
        if (this.primary == -1) {
            return this;
        }
        Interpreter entry = this.interpreters.get(this.primary);
        if (entry == null) {
            return null;
        }
        return entry.inter;
    }

    int getInterpreterCount() {
        int i = 0;
        for (Interpreter inter : this.interpreters) {
            if (inter == null) continue;
            ++i;
        }
        return i;
    }

    public Interpreter getInterpreterEntry(int id) {
        if (id < 0 || id >= this.interpreters.size()) {
            return null;
        }
        return this.interpreters.get(id);
    }

    public void setInterpreterHistory(int id, InterpreterHistory history) {
        Interpreter entry = this.getInterpreterEntry(id);
        if (entry == null) {
            return;
        }
        entry.history = history;
    }

    public InterpreterHistory getInterpreterHistory(int id) {
        Interpreter entry = this.getInterpreterEntry(id);
        if (entry == null) {
            return null;
        }
        return entry.history;
    }

    public InterpreterHistory getHistory() {
        if (this.primary == -1) {
            return this.masterHistory;
        }
        Interpreter e = this.interpreters.get(this.primary);
        if (e == null) {
            return null;
        }
        return e.history;
    }

    public boolean onFocusChanged(IUnit unit) {
        for (int i = 0; i < this.interpreters.size(); ++i) {
            Interpreter entry = this.interpreters.get(i);
            if (entry == null || !(entry.inter instanceof IUnitInterpreter) || !((IUnitInterpreter)entry.inter).isTarget(unit)) continue;
            this.setPrimary(i, true);
            return true;
        }
        return false;
    }

    @Override
    public AutocompletionResult autoComplete(String command) {
        if (this.primary >= 0 && !command.startsWith(".")) {
            ICommandInterpreter inter = this.getCurrentInterpreter();
            if (inter == this) {
                return null;
            }
            this.doLazyPreparation(inter);
            return inter.autoComplete(command);
        }
        char lastSeparator = ' ';
        boolean dot = false;
        if (command.startsWith(".")) {
            command = command.substring(1);
            dot = true;
        }
        if (this.autocompleteTokens == null) {
            this.autocompleteTokens = new ArrayList<String>(Arrays.asList("help", "list", "use", "exit"));
        }
        ArrayList<String> coms = new ArrayList<String>(Arrays.asList(command.split(" ")));
        if (command.endsWith(" ")) {
            coms.add("");
        }
        if (dot && coms.size() == 1) {
            lastSeparator = '.';
        }
        if (coms.size() <= 1) {
            return new AutocompletionResult(AutocompletionResult.filterStartsWith(command, this.autocompleteTokens), lastSeparator);
        }
        if (((String)coms.get(0)).equals("use")) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (int i = 0; i < this.interpreters.size(); ++i) {
                tokens.add(String.valueOf(i));
            }
            return new AutocompletionResult(tokens, lastSeparator);
        }
        return null;
    }

    private boolean doLazyPreparation(ICommandInterpreter interpreter) {
        try {
            UI.getTaskManager().create(UI.getShellTracker().get(), "Initializing interpreter...", () -> interpreter.prepare(), 2000L);
            return true;
        }
        catch (InterruptedException interruptedException) {
            logger.error("Interrupted", new Object[0]);
            return false;
        }
        catch (InvocationTargetException e) {
            logger.catching(e, "Unknown error");
            return false;
        }
    }

    public static class Interpreter {
        ICommandInterpreter inter;
        String name;
        boolean bannerDisplayed;
        InterpreterHistory history = new InterpreterHistory();

        Interpreter(ICommandInterpreter inter) {
            if (inter == null) {
                throw new IllegalArgumentException("Provide an interpreter object");
            }
            this.inter = inter;
            this.name = inter.getName();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.inter == null ? 0 : this.inter.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interpreter other = (Interpreter)obj;
            return !(this.inter == null ? other.inter != null : !this.inter.equals(other.inter));
        }
    }
}

