/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.StyleInfo;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.FindTextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.SwtRegistry;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FinderManager;
import com.pnfsoftware.jeb.rcpclient.extensions.search.SimpleTextFindResults;
import com.pnfsoftware.jeb.rcpclient.extensions.search.StyledTextFindImpl;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditClearHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditCopyHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditFindHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditFindnextHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditSelectAllHandler;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractPartManager;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import java.util.function.IntConsumer;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LoggerPartManager
extends AbstractPartManager
implements IOperable,
IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(LoggerPartManager.class);
    private SourceViewer viewer;
    private ToolBar toolbar;
    private StyledTextFindImpl finder;
    private FinderManager<SimpleTextFindResults> findman;
    private FindTextDialog finddlg = null;
    private boolean lockScrolling;
    private boolean colorize = true;

    public LoggerPartManager(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean createView(Composite parent, IMPart part) {
        String name;
        this.part = part;
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.viewer = new SourceViewer(parent, null, UIUtil.determineIdealScrollbarFlags(true, true));
        final StyledText w = this.viewer.getTextWidget();
        UIUtil.addTextScrolledListener(w, new IntConsumer(){

            @Override
            public void accept(int currentTopIndex) {
                LoggerPartManager.this.lockScrolling = LoggerPartManager.this.viewer.getBottomIndex() < w.getLineCount() - 1;
            }
        });
        w.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                char ch;
                int level;
                if (!LoggerPartManager.this.colorize) {
                    return;
                }
                String l = event.lineText;
                if (l.length() >= 3 && l.charAt(0) == '[' && l.charAt(2) == ']' && (level = GlobalLog.getLevelFromPrefixLetter(ch = l.charAt(1))) >= 0) {
                    StyleInfo si;
                    ItemClassIdentifiers cid = null;
                    if (level == 40) {
                        cid = ItemClassIdentifiers.INFO_WARNING;
                    } else if (level == 50) {
                        cid = ItemClassIdentifiers.INFO_ERROR;
                    } else if (level == 60) {
                        cid = ItemClassIdentifiers.INFO_DANGEROUS;
                    } else if (level >= 10 && level <= 20) {
                        cid = ItemClassIdentifiers.INFO_USELESS;
                    }
                    if (cid != null && (si = LoggerPartManager.this.context.getStyleManager().getStyle(cid)) != null) {
                        Color fg = SwtRegistry.getInstance().getColor(si.getBackgroundColor());
                        StyleRange sr = new StyleRange(event.lineOffset, l.length(), fg, null);
                        event.styles = new StyleRange[]{sr};
                    }
                }
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(100, 0);
        w.setLayoutData((Object)formData);
        this.viewer.setDocument(this.context.getLogDocument());
        this.viewer.setTopIndex(w.getLineCount());
        this.viewer.setEditable(false);
        UIUtil.addScrollingSupport(w, true, true);
        this.finder = new StyledTextFindImpl(this.viewer.getTextWidget());
        this.findman = new FinderManager<SimpleTextFindResults>(this.finder, this.context);
        Control ctl = this.viewer.getControl();
        ctl.setBackground(UIAssetManager.getInstance().getSystemColor(38));
        this.context.getFontManager().registerWidget(ctl);
        this.viewer.addTextListener(new ITextListener(){

            @Override
            public void textChanged(TextEvent e) {
                if (!LoggerPartManager.this.lockScrolling && (LoggerPartManager.this.finddlg == null || LoggerPartManager.this.findman.isEndOfSearch())) {
                    LoggerPartManager loggerPartManager = LoggerPartManager.this;
                    synchronized (loggerPartManager) {
                        LoggerPartManager.this.viewer.setTopIndex(w.getLineCount());
                    }
                }
            }
        });
        this.toolbar = new ToolBar(parent, 320);
        this.toolbar.moveAbove(ctl);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, -20);
        this.toolbar.setLayoutData((Object)formData);
        this.colorize = this.context.getPropertyManager().getBoolean(".ui.logger.Colorize");
        ToolItem item = new ToolItem(this.toolbar, 0);
        item.setText("Level:");
        final List<String> levelNames = GlobalLog.LEVEL_NAMES;
        int idx0 = 0;
        int level = this.context.getLogLevel();
        if (level > 0 && (name = GlobalLog.levelToString(level)) != null && (idx0 = levelNames.indexOf(name)) < 0) {
            idx0 = 0;
        }
        final Combo wLevel = UIUtil.addComboboxForToolbar(this.toolbar, levelNames, idx0);
        wLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = wLevel.getSelectionIndex();
                if (idx < 0 || idx >= levelNames.size()) {
                    return;
                }
                String name = (String)levelNames.get(idx);
                int level = GlobalLog.parseLevel(name);
                if (level < 0) {
                    return;
                }
                LoggerPartManager.this.context.getPropertyManager().setInteger(".LogLevel", level);
            }
        });
        new ContextMenu(this.viewer.getControl()).addContextMenu(this);
        return true;
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        menuMgr.add(new EditCopyHandler());
        menuMgr.add(new EditSelectAllHandler());
        menuMgr.add(new Separator());
        menuMgr.add(new EditFindHandler());
        menuMgr.add(new EditFindnextHandler());
        menuMgr.add(new Separator());
        menuMgr.add(new EditClearHandler());
    }

    @Override
    public void onFocus() {
        this.context.getPartManager().onFocus(this.part);
        this.viewer.getControl().setFocus();
    }

    public void clearView() {
        LoggerPartManager loggerPartManager = this;
        synchronized (loggerPartManager) {
            this.viewer.getDocument().set("");
        }
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                return this.viewer.canDoOperation(4);
            }
            case SELECT_ALL: {
                return this.viewer.canDoOperation(7);
            }
            case CLEAR: {
                return true;
            }
            case FIND: {
                return true;
            }
            case FIND_NEXT: {
                return this.findman.isReady();
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                this.viewer.doOperation(4);
                return true;
            }
            case SELECT_ALL: {
                this.viewer.doOperation(7);
                return true;
            }
            case CLEAR: {
                this.clearView();
                return true;
            }
            case FIND: {
                TextHistory history = RcpClientContext.getStandardFindTextHistory(this.context);
                String selectedText = this.viewer.getTextWidget().getSelectionText();
                if (selectedText.length() > 0) {
                    this.finder.getFindTextOptions(false).setSearchString(selectedText);
                }
                this.finddlg = new FindTextDialog(this.viewer.getControl().getShell(), this.findman, history, true, null, S.s(764));
                try {
                    this.finddlg.open();
                }
                finally {
                    this.finddlg = null;
                }
                return true;
            }
            case FIND_NEXT: {
                this.findman.search(null);
                return true;
            }
        }
        return false;
    }
}

