/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.rcpclient.IStatusIndicator;
import com.pnfsoftware.jeb.rcpclient.StatusIndicatorData;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class JebStatusIndicator
implements IStatusIndicator {
    private static final ILogger logger = GlobalLog.getLogger(JebStatusIndicator.class);
    private StatusLineManager statusManager;
    private Display display;
    private String text0;
    private List<StatusLineContributionItem> contribs = new ArrayList<StatusLineContributionItem>();

    public JebStatusIndicator(StatusLineManager statusManager) {
        this.statusManager = statusManager;
        this.display = statusManager.getControl().getDisplay();
        this.contribs.add(new Contrib("area1", 80));
        this.contribs.add(new Contrib("area2", 20));
        this.contribs.add(new Contrib("area3", 15));
        statusManager.setCancelEnabled(true);
        statusManager.update(true);
    }

    @Override
    public StatusLineContributionItem getContribution(String id) {
        for (IContributionItem item : this.statusManager.getItems()) {
            if (!Strings.equals(id, item.getId())) continue;
            return (StatusLineContributionItem)item;
        }
        return null;
    }

    @Override
    public boolean hasContribution(String id) {
        return this.getContribution(id) != null;
    }

    @Override
    public void addContribution(StatusLineContributionItem item) {
        this.statusManager.add(item);
        this.contribs.add(item);
        this.statusManager.update(true);
    }

    @Override
    public boolean removeContribution(StatusLineContributionItem item) {
        if (this.statusManager.remove(item) == null) {
            return false;
        }
        this.contribs.remove(item);
        this.statusManager.update(true);
        return true;
    }

    @Override
    public boolean removeContribution(String id) {
        StatusLineContributionItem contrib = this.getContribution(id);
        if (contrib == null) {
            return false;
        }
        return this.removeContribution(contrib);
    }

    @Override
    public void clearAdditionalContributions() {
        int cnt = 0;
        while (this.contribs.size() > 3) {
            this.statusManager.remove(this.contribs.remove(3));
            ++cnt;
        }
        if (cnt > 0) {
            this.statusManager.update(true);
        }
    }

    @Override
    public StatusIndicatorData save() {
        return new StatusIndicatorData(this.getText());
    }

    @Override
    public boolean restore(StatusIndicatorData data) {
        if (data.getElements().isEmpty()) {
            return false;
        }
        this.setText(data.getElements().get(0));
        return true;
    }

    @Override
    public void clear() {
        this.setText(null);
    }

    @Override
    public void setText(String s) {
        this.setText(0, s);
    }

    @Override
    public String getText() {
        return this.getText(0);
    }

    @Override
    public void setText(final int index, final String s) {
        if (index < 0 || index > this.contribs.size()) {
            return;
        }
        UIExecutor.asyncIfNotOnUIThread(this.display, new UIRunnable(){

            @Override
            public void runi() {
                String s2 = Strings.safe(s, "");
                if (index == 0) {
                    JebStatusIndicator.this.text0 = s2;
                    JebStatusIndicator.this.statusManager.setMessage(s2);
                } else {
                    JebStatusIndicator.this.contribs.get(index - 1).setText(s2);
                }
            }
        });
    }

    @Override
    public String getText(int index) {
        if (index < 0 || index > this.contribs.size()) {
            return null;
        }
        if (index == 0) {
            return this.text0;
        }
        return this.contribs.get(index - 1).getText();
    }

    private class Contrib
    extends StatusLineContributionItem {
        public Contrib(String id, int charWidth) {
            super(id, charWidth);
            this.setText(" ");
            JebStatusIndicator.this.statusManager.add(this);
        }

        @Override
        public void fill(Composite parent) {
            super.fill(parent);
            ThemeManager.getInstance().processControlForcibly((Widget)parent);
        }
    }
}

