/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractViewNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class DecompiledViewNavigator
extends AbstractViewNavigator {
    private static final ILogger logger = GlobalLog.getLogger(DecompiledViewNavigator.class);

    public DecompiledViewNavigator(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean canHandleAddress(AbstractUnitFragment<?> from, String address) {
        IAddressableUnit unit = this.retrieveUnit(from);
        return unit != null && unit.isValidAddress(address);
    }

    @Override
    public boolean navigateTo(AbstractUnitFragment<?> from, IActionableItem item, IViewManager viewManager, boolean record) {
        long itemId = item.getItemId();
        if (itemId == 0L) {
            return false;
        }
        IAddressableUnit unit = this.retrieveUnit(from);
        if (unit == null) {
            return false;
        }
        String address = unit.getAddressOfItem(itemId);
        if (address == null) {
            return false;
        }
        return this.navigateTo(from, address, viewManager, record);
    }

    @Override
    public boolean navigateTo(AbstractUnitFragment<?> from, String address, IViewManager viewManager, boolean record) {
        IMPart targetPart;
        if (address == null || viewManager == null) {
            return false;
        }
        PartManager pman = (PartManager)viewManager;
        IAddressableUnit unit = this.retrieveUnit(from);
        if (unit == null) {
            return false;
        }
        IMPart currentPart = this.retrievePart(from);
        if (currentPart == null) {
            return false;
        }
        IDecompilerUnit decompiler = DecompilerHelper.getRelatedDecompiler(unit);
        if (decompiler == null) {
            return false;
        }
        ICodeUnit code = decompiler.getCodeUnit();
        if (code == null) {
            return false;
        }
        if (!code.isValidAddress(address)) {
            return false;
        }
        IUnit c = decompiler.getDecompiledUnit(address);
        if (c == null) {
            Shell shell = UI.getShellTracker().get();
            List<ISourceUnit> c2 = HandlerUtil.decompileAsync(shell, this.context, decompiler, address);
            if (c2 != null && c2.size() == 1) {
                c = c2.get(0);
            }
            if (c == null) {
                c = code;
            }
        }
        if (c.isDisposed()) {
            if (Licensing.isDebugBuild()) {
                throw new RuntimeException();
            }
            return false;
        }
        List<IMPart> potentialOriginParts = pman.getPartsForUnit(c);
        if (potentialOriginParts.isEmpty()) {
            targetPart = pman.create(c, true).get(0);
            pman.setOriginator(targetPart, currentPart);
        } else {
            targetPart = pman.selectWithOriginatorDeep(potentialOriginParts, currentPart);
            if (targetPart != null) {
                pman.focus(targetPart);
            } else {
                targetPart = this.findFirstPartWithTextFragment(pman, potentialOriginParts);
                if (targetPart != null) {
                    pman.setOriginator(targetPart, currentPart);
                    pman.focus(targetPart);
                } else {
                    targetPart = pman.create(c, false).get(0);
                    pman.setOriginator(targetPart, currentPart);
                }
            }
        }
        if (targetPart == null) {
            return false;
        }
        UnitPartManager p = pman.getUnitPartManager(targetPart);
        if (p != null && p.getUnit() != unit) {
            return p.setActiveAddress(address, null, record, true);
        }
        return true;
    }

    private IMPart findFirstPartWithTextFragment(PartManager pman, List<IMPart> parts) {
        for (IMPart part : parts) {
            UnitPartManager p = pman.getUnitPartManager(part);
            if (Lists.newArrayList(Iterables.filter(p.getFragments(), TextFragment.class)).isEmpty()) continue;
            return part;
        }
        return null;
    }
}

