/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.IXApkUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.parts.IArtifactManager;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ArtifactManager
implements IArtifactManager {
    private static final ILogger logger = GlobalLog.getLogger(ArtifactManager.class);
    private static final List<IUnit> EMPTY = new ArrayList<IUnit>();
    private static ArtifactManager instance;

    public static ArtifactManager getInstance() {
        if (instance == null) {
            instance = new ArtifactManager();
        }
        return instance;
    }

    private String getType(ILiveArtifact artifact) {
        List<IUnit> artifactUnits = artifact.getUnits();
        if (artifactUnits != null && artifactUnits.size() == 1) {
            return artifactUnits.get(0).getFormatType();
        }
        return null;
    }

    @Override
    public List<IUnit> getExpandedUnits(ILiveArtifact artifact) {
        String type = this.getType(artifact);
        if (type == null) {
            return EMPTY;
        }
        IUnit unit0 = artifact.getUnits().get(0);
        return this.getExpandedUnits(unit0, type);
    }

    public List<IUnit> getExpandedUnits(IUnit unit) {
        if (unit == null) {
            return EMPTY;
        }
        return this.getExpandedUnits(unit, unit.getFormatType());
    }

    public List<IUnit> getExpandedUnits(IUnit unit0, String type) {
        if (unit0 == null || !unit0.isProcessed()) {
            return EMPTY;
        }
        if (unit0 instanceof ICodeObjectUnit) {
            ArrayList<IUnit> expanded = new ArrayList<IUnit>();
            expanded.add(unit0);
            return expanded;
        }
        ArrayList<IUnit> expanded = new ArrayList<IUnit>();
        switch (type) {
            case "apk": {
                expanded.add(unit0);
                break;
            }
            case "xapk": {
                expanded.add(unit0);
                if (!(unit0 instanceof IXApkUnit)) break;
                expanded.addAll(this.getExpandedUnits(((IXApkUnit)unit0).getApk(), "apk"));
                break;
            }
            default: {
                if (!this.isArchive(type)) break;
                expanded.add(unit0);
                List<? extends IUnit> subUnits = unit0.getChildren();
                if (subUnits.size() != 1) break;
                expanded.addAll(this.getExpandedUnits(subUnits.get(0), subUnits.get(0).getFormatType()));
            }
        }
        return expanded;
    }

    private boolean isArchive(String type) {
        switch (type) {
            case "zip": 
            case "rar": 
            case "tar": 
            case "gzip": 
            case "ar": 
            case "sevenzip": 
            case "jar": 
            case "composite": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void processLiveArtifact(RcpClientContext context, PartManager pman, ILiveArtifact artifact, TreeViewer projectTreeViewer) {
        String type = this.getType(artifact);
        if (type == null) {
            return;
        }
        IUnit unit0 = artifact.getUnits().get(0);
        this.processUnit(context, pman, unit0, type, projectTreeViewer, artifact.getUnits().size() == 1);
    }

    @Override
    public Supplier<Boolean> processUnit(RcpClientContext context, PartManager pman, IUnit unit, TreeViewer projectTreeViewer) {
        String type = unit.getFormatType();
        if (type == null) {
            return null;
        }
        return this.processUnit(context, pman, unit, type, projectTreeViewer, false);
    }

    public Supplier<Boolean> processUnit(RcpClientContext context, PartManager pman, IUnit unit0, String type, TreeViewer projectTreeViewer, boolean singleUnit) {
        if (unit0 == null) {
            return null;
        }
        if (unit0 instanceof ICodeObjectUnit) {
            ICodeUnit nativeUnit = UnitUtil.findChild(unit0, null, ICodeUnit.class, false, 0);
            if (nativeUnit != null) {
                this.openUnit(context, pman, nativeUnit, projectTreeViewer);
                return null;
            }
        } else {
            List<? extends IUnit> children;
            if (unit0 instanceof INativeCodeUnit) {
                this.openUnit(context, pman, unit0, projectTreeViewer);
                return null;
            }
            if ("gzip".equals(unit0.getFormatType()) && (children = unit0.getChildren()).size() == 1 && "tar".equals(children.get(0).getFormatType())) {
                if (!HandlerUtil.processUnit(projectTreeViewer.getTree().getShell(), context, children.get(0), true)) {
                    return null;
                }
                ArrayList<Object> expanded = new ArrayList<Object>();
                expanded.addAll(this.getExpandedUnits(children.get(0)));
                if (expanded.size() > 0) {
                    expanded.addAll(0, Arrays.asList(projectTreeViewer.getExpandedElements()));
                    projectTreeViewer.setExpandedElements(expanded.toArray());
                }
            }
        }
        switch (type) {
            case "apk": {
                Supplier<Boolean> s = () -> {
                    IDexUnit dexUnit = UnitUtil.findChild(unit0, null, IDexUnit.class, false, 0);
                    if (dexUnit != null) {
                        this.openUnit(context, pman, dexUnit, projectTreeViewer);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                };
                if (s.get() == Boolean.TRUE) break;
                return s;
            }
            case "machofat": {
                ICodeUnit nativeUnit = UnitUtil.findChild(unit0, null, ICodeUnit.class, false, 0);
                if (nativeUnit == null) break;
                this.openUnit(context, pman, nativeUnit, projectTreeViewer);
                break;
            }
            case "xapk": {
                if (!(unit0 instanceof IXApkUnit)) break;
                this.processUnit(context, pman, ((IXApkUnit)unit0).getApk(), "apk", projectTreeViewer, singleUnit);
                break;
            }
            default: {
                if (!singleUnit || !unit0.isProcessed() || this.isArchive(type)) break;
                this.openUnit(context, pman, unit0, projectTreeViewer);
            }
        }
        return null;
    }

    protected void openUnit(RcpClientContext context, PartManager pman, IUnit unit, TreeViewer projectTreeViewer) {
        projectTreeViewer.setSelection(new StructuredSelection(unit), true);
        if (!HandlerUtil.processUnit(projectTreeViewer.getTree().getShell(), context, unit, true)) {
            return;
        }
        pman.create(unit, true);
    }
}

