/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IXmlUnit;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractViewNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class AndroidXmlViewNavigator
extends AbstractViewNavigator {
    private static final ILogger logger = GlobalLog.getLogger(AndroidXmlViewNavigator.class);

    public AndroidXmlViewNavigator(RcpClientContext context) {
        super(context);
    }

    @Override
    public boolean canHandleAddress(AbstractUnitFragment<?> from, String address) {
        return false;
    }

    @Override
    public boolean navigateTo(AbstractUnitFragment<?> from, String address, IViewManager pman, boolean record) {
        return false;
    }

    @Override
    public boolean navigateTo(AbstractUnitFragment<?> from, IActionableItem item, IViewManager pman, boolean record) {
        IUnitCreator parent;
        IAddressableUnit unit = this.retrieveUnit(from);
        if (!(unit instanceof IXmlUnit)) {
            return false;
        }
        Object o = unit.getItemObject(item.getItemId());
        if (!(o instanceof Object[])) {
            return false;
        }
        Object[] array = (Object[])o;
        if (array.length < 2 || !(array[1] instanceof String)) {
            return false;
        }
        String attrval = (String)array[1];
        (new Object[1])[0] = attrval;
        if (attrval == null || attrval.isEmpty()) {
            return false;
        }
        for (parent = unit.getParent(); parent != null && !(parent instanceof IApkUnit); parent = parent.getParent()) {
        }
        if (parent == null) {
            return false;
        }
        IApkUnit apk = (IApkUnit)parent;
        IDexUnit dex = apk.getDex();
        if (dex == null || dex.isDisposed() || !dex.isProcessed()) {
            return false;
        }
        Object cname = attrval.startsWith(".") ? apk.getPackageName() + attrval : attrval;
        String csig = "L" + ((String)cname).replace('.', '/') + ";";
        if (dex.getClass(csig) == null) {
            return false;
        }
        return GraphicalActionExecutor.gotoAddress(this.context, dex, csig);
    }
}

