/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitAddress;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellActivationTracker;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredStructuredViewer;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.parts.IViewNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeHierarchyFragment;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class AddressNavigator {
    private IRcpClientContext context;
    private IUnit managedUnit;
    private IRcpUnitFragment requester;

    public AddressNavigator(IRcpClientContext context, IUnit managedUnit) {
        this(context, managedUnit, null);
    }

    public AddressNavigator(IRcpClientContext context, IUnit managedUnit, IRcpUnitFragment requester) {
        this.context = context;
        this.managedUnit = managedUnit;
        this.requester = requester;
    }

    public void addDefaultListeners(IFilteredStructuredViewer viewer) {
        if (viewer != null) {
            viewer.addDoubleClickListener(event -> this.navigate(null, true));
            viewer.addSelectionChangedListener(event -> this.context.refreshHandlersStates());
        }
    }

    public boolean navigate(String address) {
        return this.navigate(address, true);
    }

    private boolean navigate(String address, boolean createPartIfNotExist) {
        String string;
        IRcpUnitFragment fragment;
        UnitPartManager object;
        boolean autoAddress = false;
        if (address == null) {
            autoAddress = true;
            if (this.requester != null) {
                address = this.requester.getActiveAddress();
            }
            if (address == null) {
                return false;
            }
        }
        if (!this.askProcessUnit(this.managedUnit)) {
            return false;
        }
        PartManager pman = this.context.getPartManager();
        TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>> toFocus = new TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>>();
        IMPart activePart = pman.getActivePart();
        UnitPartManager activePman = pman.getUnitPartManager(activePart);
        if (activePman != null && activePman.getActiveFragment() instanceof CodeHierarchyFragment) {
            Iterator<IMPart> codeUnit = activePman.getUnit();
            for (IMPart vpart : pman.getPartsForUnit(null, 4)) {
                UnitPartManager vpman;
                IUnitFragment iUnitFragment;
                IViewNavigator viewNavigator;
                Object srcUnit;
                IDecompilerUnit decomp;
                IUnit unit = pman.getUnitForPart(vpart);
                if (!(unit instanceof ISourceUnit) || unit.isDisposed() || (decomp = (srcUnit = (ISourceUnit)unit).getDecompiler()).getCodeUnit() != codeUnit || (viewNavigator = ((AbstractUnitFragment)(iUnitFragment = (vpman = pman.getUnitPartManager(vpart)).getActiveFragment())).getViewNavigatorHelper()) == null || !viewNavigator.navigateTo((AbstractUnitFragment<?>)iUnitFragment, address, (IViewManager)pman, true)) continue;
                return vpman.setActiveAddress(address, null, true, true);
            }
        }
        List<IMPart> parts = pman.getPartsForUnit(this.managedUnit, 1);
        for (IMPart iMPart : parts) {
            object = pman.getUnitPartManager(iMPart);
            fragment = this.getActiveDefaultFragment(object);
            if (fragment == null || !this.isValidAddress(fragment, address)) continue;
            this.add(toFocus, new Couple<IMPart, IRcpUnitFragment>(iMPart, fragment));
        }
        if (this.focusOrClear(pman, toFocus, address, false, autoAddress)) {
            return true;
        }
        parts = pman.getPartsForUnitFamily(this.managedUnit, 1);
        for (IMPart iMPart : parts) {
            object = pman.getUnitPartManager(iMPart);
            if (object == null || object.getUnit() == this.managedUnit || (fragment = this.getActiveDefaultFragment(object)) == null || !this.isValidAddress(fragment, address)) continue;
            this.add(toFocus, new Couple<IMPart, IRcpUnitFragment>(iMPart, fragment));
        }
        if (this.focusOrClear(pman, toFocus, address, false, autoAddress)) {
            return true;
        }
        for (IMPart iMPart : parts) {
            object = pman.getUnitPartManager(iMPart);
            if (object == null) continue;
            List<IRcpUnitFragment> fragments = this.getFragmentsDefaultFirst(object);
            for (IRcpUnitFragment fragment3 : fragments) {
                if (fragment3 == null || !this.isValidAddress(fragment3, address)) continue;
                this.add(toFocus, new Couple<IMPart, IRcpUnitFragment>(iMPart, fragment3));
            }
        }
        if (this.focusOrClear(pman, toFocus, address, true, autoAddress)) {
            return true;
        }
        parts = pman.getPartsForUnitFamily(this.managedUnit, 2);
        parts.addAll(0, pman.restoreMissingParts(this.managedUnit));
        IUnit mainUnit = this.getMainUnitForAddress(address);
        if (mainUnit != null) {
            parts.addAll(0, pman.restoreMissingParts(mainUnit));
        }
        for (IMPart part : parts) {
            UnitPartManager object2 = pman.getUnitPartManager(part);
            if (object2 == null) continue;
            IRcpUnitFragment selectedFragment = this.getActiveDefaultFragment(object2);
            if (selectedFragment != null && this.isValidAddress(selectedFragment, address)) {
                this.add(toFocus, new Couple<IMPart, IRcpUnitFragment>(part, selectedFragment));
            }
            List<IRcpUnitFragment> fragments = this.getFragmentsDefaultFirst(object2);
            for (IRcpUnitFragment iRcpUnitFragment : fragments) {
                if (iRcpUnitFragment == null || iRcpUnitFragment == selectedFragment || !this.isValidAddress(iRcpUnitFragment, address)) continue;
                this.add(toFocus, new Couple<IMPart, IRcpUnitFragment>(part, iRcpUnitFragment));
            }
        }
        if (this.focusOrClear(pman, toFocus, address, false, autoAddress)) {
            return true;
        }
        if (createPartIfNotExist) {
            if (this.managedUnit instanceof ICodeObjectUnit) {
                List<INativeCodeUnit> list = UnitUtil.findChildrenByType(this.managedUnit, INativeCodeUnit.class, false);
                if (list != null && list.size() == 1 && !HandlerUtil.isFullyProcessed(list.get(0))) {
                    String message;
                    INativeCodeUnit nativeUnit = list.get(0);
                    if (!this.askProcessUnit(nativeUnit, message = "The native code of " + this.managedUnit.getName() + " is not processed.\n\nProcess it now?")) {
                        return false;
                    }
                    pman.create(nativeUnit, true);
                    return this.navigate(address, false);
                }
            } else {
                parts = pman.create(this.managedUnit, true);
                if (parts == null || parts.isEmpty()) {
                    return false;
                }
                return this.navigate(address, false);
            }
        }
        if (this.requester != null && autoAddress && (string = this.requester.getActiveAddress(AddressConversionPrecision.COARSE)) != null && !address.equals(string)) {
            return this.navigate(string, createPartIfNotExist);
        }
        return false;
    }

    private boolean askProcessUnit(IUnit unit) {
        return this.askProcessUnit(unit, null);
    }

    private boolean askProcessUnit(IUnit unit, String message) {
        if (!HandlerUtil.isFullyProcessed(unit)) {
            boolean r;
            if (HandlerUtil.isPendingAnalysis(unit)) {
                return true;
            }
            ShellActivationTracker tracker = UI.getShellTracker();
            if (message == null) {
                message = Strings.ff("The unit '%s' has not been processed. Would you like to process it now?", unit.getName());
            }
            if (!(r = UI.question(tracker.get(), "Process Unit?", message))) {
                return false;
            }
            this.context.getTelemetry().record("navigateOpenUnit", "unitType", unit.getFormatType());
            if (!HandlerUtil.processUnit(tracker.get(), this.context, unit, true)) {
                return false;
            }
        }
        return true;
    }

    private void add(TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>> toFocus, Couple<IMPart, IRcpUnitFragment> couple) {
        int priority = couple.getSecond().getFocusPriority();
        Maps.putMulti(toFocus, Integer.valueOf(priority), couple);
    }

    private boolean isValidAddress(IRcpUnitFragment fragment, String address) {
        return fragment.isValidActiveAddress(address, null);
    }

    private boolean focusOrClear(PartManager pman, TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>> toFocus, String address, boolean setActiveFragment, boolean autoAddress) {
        if (!toFocus.isEmpty()) {
            this.askProcessUnit(this.managedUnit, "The unit " + this.managedUnit.getName() + " is not processed or is being processed.\n\nAttempt processing?");
            if (this.focus(pman, toFocus, address, setActiveFragment, autoAddress)) {
                return true;
            }
            toFocus.clear();
        }
        return false;
    }

    private boolean focus(PartManager pman, TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>> toFocus, String address, boolean setActiveFragment, boolean autoAddress) {
        IMPart activePart0 = pman.getActivePart();
        for (Map.Entry e : toFocus.descendingMap().entrySet()) {
            Couple foc;
            int i;
            ArrayList<Couple> focus = new ArrayList<Couple>((Collection)e.getValue());
            List<IMPart> parts = ((List)e.getValue()).stream().map(c -> (IMPart)c.getFirst()).collect(Collectors.toList());
            IMPart p = pman.getMostRecentlyFocused(parts);
            for (i = 0; i < focus.size(); ++i) {
                foc = (Couple)focus.get(i);
                if (foc.getFirst() != p) continue;
                focus.add(0, (Couple)focus.remove(i));
            }
            for (i = 0; i < focus.size(); ++i) {
                foc = (Couple)focus.get(i);
                if (!((IRcpUnitFragment)foc.getSecond()).isDefaultFragment()) continue;
                focus.add(0, (Couple)focus.remove(i));
            }
            for (Couple e2 : focus) {
                IMPart part = (IMPart)e2.getFirst();
                IRcpUnitFragment fragment = (IRcpUnitFragment)e2.getSecond();
                if (!fragment.setActiveAddress(address, this.requester == null ? null : this.requester.getExtraAddressDetails(autoAddress ? null : address), true, true)) continue;
                if (pman.getActivePart() == activePart0) {
                    pman.focus(part);
                }
                if (setActiveFragment) {
                    pman.getUnitPartManager(part).setActiveFragment(fragment);
                }
                return true;
            }
        }
        return false;
    }

    private IRcpUnitFragment getActiveDefaultFragment(UnitPartManager object) {
        IRcpUnitFragment fragment = this.getActiveFragment(object);
        if (fragment == null || !fragment.isDefaultFragment()) {
            return null;
        }
        return fragment;
    }

    private IRcpUnitFragment getActiveFragment(UnitPartManager object) {
        if (object == null) {
            return null;
        }
        IUnitFragment fragment = object.getActiveFragment();
        if (fragment == null || fragment == this.requester || fragment.getFocusPriority() == 0) {
            return null;
        }
        return fragment;
    }

    private List<IRcpUnitFragment> getFragmentsDefaultFirst(UnitPartManager object) {
        if (object == null) {
            return null;
        }
        List<IRcpUnitFragment> fragments = object.getFragments();
        for (int i = 0; i < fragments.size(); ++i) {
            IRcpUnitFragment fragment = fragments.get(i);
            if (fragment == null || fragment == this.requester || fragment.getFocusPriority() == 0) {
                fragments.remove(i);
                --i;
            }
            if (fragments.isEmpty()) break;
            if (!fragment.isDefaultFragment()) continue;
            fragments.add(0, fragments.remove(i));
            break;
        }
        return fragments;
    }

    private IUnit getMainUnitForAddress(String address) {
        if (this.managedUnit instanceof IApkUnit) {
            IApkUnit apkUnit = (IApkUnit)this.managedUnit;
            for (IUnit iUnit : apkUnit.getChildren()) {
                if (!(iUnit instanceof IDebuggerUnit)) continue;
                UnitAddress<ICodeUnit> newAddress = ((IDebuggerUnit)iUnit).convertToUnitAddress(address);
                if (newAddress != null) {
                    return newAddress.getUnit();
                }
                for (IUnit iUnit2 : iUnit.getChildren()) {
                    if (!(iUnit2 instanceof IDebuggerUnit) || (newAddress = ((IDebuggerUnit)iUnit2).convertToUnitAddress(address)) == null) continue;
                    return newAddress.getUnit();
                }
            }
        }
        return null;
    }
}

