/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.operations;

import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class ContextMenu {
    private final List<IContextMenu> contextMenus = new ArrayList<IContextMenu>();
    private MenuManager menuManager = new MenuManager();
    private Menu menu;

    public ContextMenu(Control control) {
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            @Override
            public void menuAboutToShow(IMenuManager menuMgr) {
                for (IContextMenu cm : ContextMenu.this.contextMenus) {
                    cm.fillContextMenu(menuMgr);
                }
            }
        });
        this.menu = this.menuManager.createContextMenu(control);
        control.setMenu(this.menu);
        control.addDisposeListener(e -> this.menu.dispose());
    }

    public void addContextMenu(IContextMenu contextMenu) {
        this.contextMenus.add(contextMenu);
    }

    public void clearContextMenu() {
        this.contextMenus.clear();
    }

    public IContextMenu getContextMenu(int index) {
        return this.contextMenus.get(index);
    }

    public int size() {
        return this.contextMenus.size();
    }

    public IContextMenu removeContextMenu(int index) {
        return this.contextMenus.get(index);
    }

    public void add(IContributionItem item) {
        this.menuManager.add(item);
    }

    public MenuManager getMenuMgr() {
        return this.menuManager;
    }

    public Menu getMenu() {
        return this.menuManager.getMenu();
    }

    public void addSubMenu(ContextMenu submenu) {
        this.addContextMenu(menuMgr -> menuMgr.add(submenu.getMenuMgr()));
    }
}

