/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.omnibox;

import com.pnfsoftware.jeb.core.BookmarkManager;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeString;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexString;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.omnibox.CP;
import com.pnfsoftware.jeb.rcpclient.omnibox.UnitContentsCache;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeFragmentUtil;
import com.pnfsoftware.jeb.util.base.StarMatcher;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

class WorkspaceProposalRecorder {
    private static final ILogger logger = GlobalLog.getLogger(WorkspaceProposalRecorder.class);
    private String input;
    private int maxRecordCount;
    private boolean resultCapped;
    private StarMatcher m;
    private IRuntimeProject prj;
    private UnitContentsCache unitTextDocContentsCache;
    private long maxTimeMs;
    private long ts0;
    private boolean resultTimedOut;
    private List<ICompletionProposal> r = new ArrayList<ICompletionProposal>();
    private boolean collectAddresses = false;

    public WorkspaceProposalRecorder(String input, int maxRecordCount, IRuntimeProject prj, UnitContentsCache unitTextDocContentsCache, long maxTimeMs) {
        this.input = input;
        this.maxRecordCount = maxRecordCount;
        this.m = new StarMatcher(input);
        this.prj = prj;
        this.unitTextDocContentsCache = unitTextDocContentsCache;
        this.maxTimeMs = maxTimeMs;
    }

    private boolean record(ICompletionProposal proposal) {
        this.r.add(proposal);
        if (this.maxTimeMs >= 0L && System.currentTimeMillis() - this.ts0 >= this.maxTimeMs) {
            this.resultTimedOut = true;
            return false;
        }
        if (this.r.size() >= this.maxRecordCount) {
            this.resultCapped = true;
            return false;
        }
        return true;
    }

    public boolean isTimedOut() {
        return this.resultTimedOut;
    }

    public boolean isCapped() {
        return this.resultCapped;
    }

    public List<ICompletionProposal> getRecords() {
        return this.r;
    }

    public boolean process() {
        this.ts0 = System.currentTimeMillis();
        if (this.prj != null && !this.processProject()) {
            return false;
        }
        if (RcpClientContext.getInstance() != null) {
            long t0 = System.currentTimeMillis();
            for (JebBaseHandler handler : AllHandlers.getInstance().getAll()) {
                if (!handler.canExecute()) continue;
                Object name = handler.getActionName();
                if (!this.m.matches((String)(name = "Handler: " + ((String)name).replace("&", "").replace("...", "")))) continue;
                CP proposal = new CP(CP.EntryType.Handler, (String)name, this.input);
                proposal.setObject(handler);
                if (handler.getImageDescriptor() != null) {
                    proposal.setImage(UIAssetManager.getInstance().getImage(handler.getImageDescriptor()));
                }
                if (this.record(proposal)) continue;
                (new Object[1])[0] = System.currentTimeMillis() - t0;
                return false;
            }
            (new Object[1])[0] = System.currentTimeMillis() - t0;
        }
        return true;
    }

    private boolean processProject() {
        CP proposal;
        String s;
        IAddressableUnit u;
        List<IUnit> units = RuntimeProjectUtil.getAllUnits(this.prj);
        long t0 = System.currentTimeMillis();
        for (IUnit unit : units) {
            if (!this.m.matches(unit.getName()) && !this.m.matches(unit.getRealName())) continue;
            String unitname = unit.getName();
            CP proposal2 = new CP(CP.EntryType.Unit, unitname, this.input);
            proposal2.setUnit(unit);
            String string = UnitUtil.buildFullyQualifiedUnitPath(unit, this.prj.getArtifactCount() >= 2, ">");
            proposal2.setMetainfo(string);
            if (this.record(proposal2)) continue;
            (new Object[1])[0] = System.currentTimeMillis() - t0;
            return false;
        }
        (new Object[1])[0] = System.currentTimeMillis() - t0;
        t0 = System.currentTimeMillis();
        for (BookmarkManager.Bookmark e : this.prj.getBookmarkManager().getAll()) {
            String line = "Favorite: " + e.getDescription();
            if (!this.m.matches(line)) continue;
            String s2 = Strings.truncateWithSuffix(line, 200, "...");
            s2 = s2.replace("\r\n", " / ").replace("\r", "").replace("\n", " / ");
            CP cP = new CP(CP.EntryType.Comment, s2, this.input);
            cP.setImagePath("eclipse/comment_edit.png");
            cP.setUnit(e.getUnit());
            cP.setUnitAddress(e.getAddress());
            if (this.record(cP)) continue;
            (new Object[1])[0] = System.currentTimeMillis() - t0;
            return false;
        }
        (new Object[1])[0] = System.currentTimeMillis() - t0;
        t0 = System.currentTimeMillis();
        for (IUnit unit : units) {
            if (!unit.isProcessed() || unit.isDisposed() || !(unit instanceof IInteractiveUnit)) continue;
            u = (IInteractiveUnit)unit;
            Map<String, String> comments = u.getFullComments();
            for (Map.Entry<String, String> entry : comments.entrySet()) {
                String comment = entry.getValue();
                if (!this.m.matches(comment)) continue;
                s = Strings.truncateWithSuffix(comment, 200, "...");
                s = s.replace("\r\n", " / ").replace("\r", "").replace("\n", " / ");
                proposal = new CP(CP.EntryType.Comment, s, this.input);
                proposal.setImagePath("eclipse/comment_edit.png");
                proposal.setUnit(unit);
                proposal.setUnitAddress(entry.getKey());
                if (this.record(proposal)) continue;
                (new Object[1])[0] = System.currentTimeMillis() - t0;
                return false;
            }
        }
        (new Object[1])[0] = System.currentTimeMillis() - t0;
        t0 = System.currentTimeMillis();
        for (IUnit unit : units) {
            if (!unit.isProcessed() || unit.isDisposed() || !(unit instanceof ICodeUnit)) continue;
            u = (ICodeUnit)unit;
            for (ICodeString iCodeString : u.getStrings()) {
                String str;
                boolean bl = iCodeString instanceof IDexString && Boolean.FALSE.equals(((IDexString)iCodeString).getHintUsedAsImmediate());
                if (bl || !this.m.matches(str = iCodeString.getValue())) continue;
                s = Strings.truncateWithSuffix(str, 200, "...");
                s = s.replace("\r\n", " / ").replace("\r", "").replace("\n", " / ");
                proposal = new CP(bl ? CP.EntryType.MetaString : CP.EntryType.String, s, this.input);
                proposal.setImagePath(bl ? "" : "eclipse/datasheet.gif");
                proposal.setUnit(unit);
                proposal.setObject(iCodeString);
                proposal.setUnitAddress(iCodeString.getAddress());
                if (this.record(proposal)) continue;
                (new Object[1])[0] = System.currentTimeMillis() - t0;
                return false;
            }
        }
        (new Object[1])[0] = System.currentTimeMillis() - t0;
        t0 = System.currentTimeMillis();
        for (IUnit unit : units) {
            if (!unit.isProcessed() || unit.isDisposed() || !(unit instanceof ICodeUnit)) continue;
            ICodeUnit u2 = (ICodeUnit)unit;
            HashSet<String> codeaddrset = new HashSet<String>();
            for (boolean nameOnly : new boolean[]{true, false}) {
                List<? extends ICodeClass> clist = u2.getClasses();
                if (!this.gatherCodeItems(u2, clist, CP.EntryType.Class, nameOnly, codeaddrset)) {
                    (new Object[1])[0] = System.currentTimeMillis() - t0;
                    return false;
                }
                if (unit instanceof INativeCodeUnit) {
                    if (this.gatherCodeItems(u2, ((INativeCodeUnit)u2).getInternalMethods(), CP.EntryType.Method, nameOnly, codeaddrset)) continue;
                    (new Object[1])[0] = System.currentTimeMillis() - t0;
                    return false;
                }
                if (!(unit instanceof IDexUnit)) continue;
                for (ICodeClass iCodeClass : clist) {
                    if (!this.gatherCodeItems(u2, iCodeClass.getMethods(), CP.EntryType.Method, nameOnly, codeaddrset)) {
                        (new Object[1])[0] = System.currentTimeMillis() - t0;
                        return false;
                    }
                    if (this.gatherCodeItems(u2, iCodeClass.getFields(), CP.EntryType.Field, nameOnly, codeaddrset)) continue;
                    (new Object[1])[0] = System.currentTimeMillis() - t0;
                    return false;
                }
            }
        }
        (new Object[1])[0] = System.currentTimeMillis() - t0;
        if (this.collectAddresses) {
            t0 = System.currentTimeMillis();
            for (IUnit unit : units) {
                if (!unit.isProcessed() || unit.isDisposed() || !(unit instanceof IAddressableUnit)) continue;
                u = (IAddressableUnit)unit;
                for (String string : u.getWellKnownAddresses(this.maxRecordCount, a -> this.m.matches((String)a))) {
                    CP cP = new CP(CP.EntryType.Address, string, this.input);
                    cP.setImagePath("eclipse/forward_nav.png");
                    cP.setUnit(unit);
                    cP.setUnitAddress(string);
                    if (this.record(cP)) continue;
                    (new Object[1])[0] = System.currentTimeMillis() - t0;
                    return false;
                }
            }
            (new Object[1])[0] = System.currentTimeMillis() - t0;
        }
        if (this.unitTextDocContentsCache != null) {
            t0 = System.currentTimeMillis();
            for (IUnit unit : units) {
                if (!unit.isProcessed() || unit.isDisposed() || unit instanceof ICodeUnit || this.m.getCharSearchLength() < 5) continue;
                this.unitTextDocContentsCache.generate(unit);
                List<UnitContentsCache.TextBuffer> buflist = this.unitTextDocContentsCache.get(unit);
                for (UnitContentsCache.TextBuffer textBuffer : buflist) {
                    StarMatcher.Result res;
                    int fromIndex = 0;
                    for (int i = 0; i < 10 && (res = this.m.find(textBuffer.text, fromIndex)) != null; ++i) {
                        int start = textBuffer.text.lastIndexOf(10, res.charStartIndex);
                        start = start == -1 ? res.charStartIndex : ++start;
                        int end = textBuffer.text.indexOf(10, res.charEndIndex);
                        if (end == -1) {
                            end = res.charEndIndex;
                        }
                        String string = textBuffer.text.substring(start, end);
                        CP proposal5 = new CP(CP.EntryType.UnitTextDocument, string, this.input);
                        proposal5.setUnit(unit);
                        String unitpath = UnitUtil.buildFullyQualifiedUnitPath(unit, this.prj.getArtifactCount() >= 2, ">");
                        proposal5.setMetainfo(unitpath);
                        if (!this.record(proposal5)) {
                            (new Object[1])[0] = System.currentTimeMillis() - t0;
                            return false;
                        }
                        fromIndex = res.charEndIndex;
                    }
                }
            }
            (new Object[1])[0] = System.currentTimeMillis() - t0;
        }
        return true;
    }

    private boolean gatherCodeItems(ICodeUnit u, List<? extends ICodeItem> elts, CP.EntryType entryType, boolean nameOnly, Set<String> codeaddrset) {
        block0: for (ICodeItem iCodeItem : elts) {
            if (!iCodeItem.isInternal()) continue;
            String sig = iCodeItem.getSignature();
            String sig0 = iCodeItem.getSignature(false);
            String target = nameOnly ? iCodeItem.getName() : sig;
            String target1 = null;
            String repl = sig;
            while (true) {
                if (this.m.matches(target)) {
                    CP proposal = new CP(entryType, repl, this.input);
                    proposal.setImagePath(CodeFragmentUtil.getCodeNodeIcon(iCodeItem, u).getFirst());
                    proposal.setUnit(u);
                    String addr = iCodeItem.getAddress();
                    if (codeaddrset != null) {
                        codeaddrset.add(addr);
                    }
                    proposal.setUnitAddress(addr);
                    if (!this.record(proposal)) {
                        return false;
                    }
                }
                if (target1 != null || (target1 = nameOnly ? iCodeItem.getName(false) : iCodeItem.getSignature(false)) == null || target1.equals(target)) continue block0;
                target = target1;
                repl = sig0;
            }
        }
        return true;
    }
}

