/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.omnibox;

import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.TextDocumentUtil;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class UnitContentsCache {
    private static final ILogger logger = GlobalLog.getLogger(UnitContentsCache.class);
    private WeakIdentityHashMap<IUnit, List<TextBuffer>> contentsCache = new WeakIdentityHashMap();

    public List<TextBuffer> get(IUnit unit) {
        List<TextBuffer> buflist = this.contentsCache.get(unit);
        if (buflist == null) {
            return Collections.emptyList();
        }
        return buflist;
    }

    public void clear() {
        this.contentsCache.clear();
    }

    public void remove(IUnit unit) {
        this.contentsCache.remove(unit);
    }

    public void generate(IUnit unit) {
        this.generate(unit, false);
    }

    public void generate(IUnit unit, boolean forceRefresh) {
        List<TextBuffer> buflist = this.contentsCache.get(unit);
        if (buflist == null) {
            buflist = new ArrayList<TextBuffer>();
            this.contentsCache.put(unit, buflist);
        } else if (forceRefresh) {
            buflist.clear();
        }
        IUnitFormatter formatter = unit.getFormatter();
        block3: for (IUnitDocumentPresentation pres : formatter.getPresentations()) {
            long presId = pres.getId();
            for (TextBuffer buf : buflist) {
                if (buf.presId != presId) continue;
                continue block3;
            }
            IGenericDocument _doc = pres.getDocument();
            try {
                if (!(_doc instanceof ITextDocument)) continue;
                ITextDocument doc = (ITextDocument)_doc;
                Object[] objectArray = new Object[]{unit.getName(), pres.getLabel()};
                String text = TextDocumentUtil.getText(doc);
                TextBuffer buf = new TextBuffer();
                buf.presId = presId;
                buf.presLabel = pres.getLabel();
                buf.firstAnchor = doc.getFirstAnchor();
                buf.text = text;
                buflist.add(buf);
            }
            finally {
                _doc.dispose();
            }
        }
    }

    static class TextBuffer {
        long presId;
        String presLabel;
        long firstAnchor;
        String text;

        TextBuffer() {
        }
    }
}

